/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.service.ServiceMessages;

public final class DocumentStream
extends FilterInputStream {
    private final URLConnection _connection;
    private final boolean _isFile;
    private final DateTime _stamp;
    private final InputStream _stream;

    private DocumentStream(URLConnection connection, InputStream stream) throws MalformedURLException {
        super(stream);
        long time;
        this._connection = connection;
        this._stream = stream;
        String protocol = this.getFromURL().getProtocol();
        if ("file".equalsIgnoreCase(protocol)) {
            time = new File(this.getFromURL().getPath()).lastModified();
            this._isFile = true;
        } else if ("jar".equalsIgnoreCase(protocol)) {
            URL jarURL = new URL(this.getFromURL().getFile());
            if ("file".equalsIgnoreCase(jarURL.getProtocol())) {
                String jarPath = jarURL.getFile();
                int bangPos = jarPath.indexOf(33);
                if (bangPos >= 0) {
                    jarPath = jarPath.substring(0, bangPos);
                }
                time = new File(jarPath).lastModified();
                this._isFile = true;
            } else {
                time = 0L;
                this._isFile = false;
            }
        } else {
            time = this._connection.getDate();
            this._isFile = false;
        }
        if (time == 0L) {
            Logger.getInstance(this.getClass()).warn(ServiceMessages.TIME_NOT_AVAILABLE, this.getFromURL());
        }
        this._stamp = time > 0L ? DateTime.fromMillis(time) : null;
    }

    @Nonnull
    @CheckReturnValue
    public static DocumentStream create(@Nonnull URL fromURL) throws FileNotFoundException {
        try {
            URLConnection connection = fromURL.openConnection();
            connection.connect();
            return new DocumentStream(connection, connection.getInputStream());
        }
        catch (FileNotFoundException exception) {
            throw exception;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Nonnull
    @CheckReturnValue
    Optional<String> getEncoding() {
        return Optional.ofNullable(this._connection.getContentEncoding());
    }

    @Nonnull
    @CheckReturnValue
    URL getFromURL() {
        return this._connection.getURL();
    }

    @Nonnull
    @CheckReturnValue
    Optional<DateTime> getStamp() {
        return Optional.ofNullable(this._stamp);
    }

    @Nonnull
    @CheckReturnValue
    InputStream getStream() {
        return this._stream;
    }

    @CheckReturnValue
    boolean isFile() {
        return this._isFile;
    }
}

