/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.util.container.KeyedValues;

@NotThreadSafe
final class DocumentSystemProperties
extends KeyedValues {
    private static final DocumentSystemProperties _INSTANCE = new DocumentSystemProperties();
    private static final long serialVersionUID = 1L;

    private DocumentSystemProperties() {
        super(BaseMessages.SYSTEM_TYPE.toString());
    }

    @Override
    public void add(@Nonnull String key, @Nonnull Object value) {
        this.checkNotFrozen();
        System.setProperty(key, value.toString());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValueKey(String key) {
        return System.getProperties().containsKey(key);
    }

    @Override
    public DocumentSystemProperties copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentSystemProperties freeze() {
        super.freeze();
        return this;
    }

    @Override
    public boolean isMultiple(String key) {
        return false;
    }

    @Override
    public void setValue(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValuesHidden(String key) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    @CheckReturnValue
    static DocumentSystemProperties getInstance() {
        return _INSTANCE;
    }

    private Object readResolve() {
        return DocumentSystemProperties.getInstance();
    }
}

