/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.rvpf.base.Params;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.entity.ClassDefEntity;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.MetadataElementLoader;
import org.rvpf.metadata.entity.EngineEntity;
import org.rvpf.metadata.entity.ProxyEntity;

final class EngineLoader
extends MetadataElementLoader {
    EngineLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        if (!this.getMetadataFilter().areEnginesNeeded()) {
            return;
        }
        DocumentElement engineElement = this.getElement();
        String clone = engineElement.getAttributeValue("clone", Optional.empty()).orElse(null);
        EngineEntity.Builder engineBuilder = EngineEntity.newBuilder();
        if (clone == null) {
            this.setUpEntityBuilder(engineBuilder);
            engineBuilder.setClassDef(Optional.of(this.getClassDefEntity(engineElement.getAttributeValue("classDef")))).setParams(this.getParams(engineElement, "Engine")).setAttributes(this.getAttributes(engineElement));
        } else {
            EngineEntity clonedEntity = (EngineEntity)((ProxyEntity)this.getEntity(clone, "G"));
            Optional<String> referenceAttribute = engineElement.getAttributeValue("classDef", Optional.empty());
            ClassDefEntity classDef = referenceAttribute.isPresent() ? this.getClassDefEntity(referenceAttribute.get()) : null;
            engineBuilder.copyFrom(clonedEntity);
            this.setUpEntityBuilder(engineBuilder);
            if (classDef != null) {
                engineBuilder.setClassDef(Optional.ofNullable(classDef));
            }
            Params clonedParams = clonedEntity.getParams().copy();
            Optional<Params> newParams = this.getParams(engineElement, "Engine");
            if (newParams.isPresent()) {
                for (Map.Entry<String, List<Object>> entry : newParams.get().getValuesEntries()) {
                    String name = entry.getKey();
                    for (Object value : entry.getValue()) {
                        clonedParams.add(name, value);
                    }
                }
            }
            engineBuilder.setParams(Optional.of(clonedParams));
            Optional<KeyedGroups> elementAttributes = this.getAttributes(engineElement);
            if (elementAttributes.isPresent()) {
                KeyedGroups attributesMap = clonedEntity.getAttributes().get().copy();
                attributesMap.addAll(elementAttributes.get());
                attributesMap.freeze();
                engineBuilder.setAttributes(attributesMap.isEmpty() ? Optional.empty() : Optional.of(attributesMap));
            }
        }
        EngineEntity engineEntity = engineBuilder.build();
        if (this.getMetadataFilter().isEngineNeeded(engineEntity)) {
            this.addGroupMember(engineEntity);
            this.getMetadata().addEngineEntity(Optional.of(engineEntity));
            this.putEntity(engineEntity);
        }
    }

    @Override
    String getEntityPrefix() {
        return "G";
    }
}

