/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Optional;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Entity;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.config.TopologicalErrorException;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.MetadataElementLoader;
import org.rvpf.metadata.entity.GroupEntity;
import org.rvpf.service.ServiceMessages;

final class GroupLoader
extends MetadataElementLoader {
    GroupLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        if (!this.getMetadataFilter().areGroupsNeeded()) {
            return;
        }
        GroupEntity.Builder groupBuilder = GroupEntity.newBuilder();
        this.setUpEntityBuilder(groupBuilder);
        GroupEntity groupEntity = groupBuilder.build();
        if (!groupEntity.getName().isPresent()) {
            throw new ValidationException(ServiceMessages.GROUP_NEEDS_NAME, new Object[0]);
        }
        this.addGroupMember(groupEntity);
        DocumentElement groupElement = this.getElement();
        for (DocumentElement memberElement : groupElement.getChildren("member")) {
            if (!memberElement.isEnabled() || this._addMember(groupEntity, memberElement, "point", "P") || this._addMember(groupEntity, memberElement, "origin", "O") || this._addMember(groupEntity, memberElement, "store", "S") || this._addMember(groupEntity, memberElement, "content", "N") || this._addMember(groupEntity, memberElement, "transform", "T") || this._addMember(groupEntity, memberElement, "engine", "G")) continue;
            this._addMember(groupEntity, memberElement, "group", "U");
        }
        this.getMetadata().addGroupEntity(Optional.of(groupEntity));
        this.anchorEntity(groupEntity);
        this.putEntity(groupEntity);
    }

    @Override
    String getEntityPrefix() {
        return "U";
    }

    private boolean _addMember(GroupEntity group, DocumentElement element, String attributeName, String prefix) throws ValidationException {
        boolean added;
        Entity member;
        Optional<String> attribute = element.getAttributeValue(attributeName, Optional.empty());
        Entity entity = member = attribute.isPresent() ? this.getEntity(attribute.get(), prefix) : null;
        if (member == null) {
            return false;
        }
        try {
            added = group.addMember(member);
        }
        catch (TopologicalErrorException exception) {
            throw new ValidationException(BaseMessages.VERBATIM, exception.getMessage());
        }
        if (!added) {
            this.getLogger().warn(ServiceMessages.DUPLICATE_GROUP_ENTRY, attributeName, member.getName(), group.getName());
        }
        return true;
    }
}

