/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.security.Crypt;
import org.rvpf.base.security.SecurityContext;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.util.UnicodeStreamReader;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.xml.XMLDocument;
import org.rvpf.config.Config;
import org.rvpf.config.ConfigProperties;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.http.HTTPMessages;
import org.rvpf.service.ServiceMessages;

final class MetadataCache {
    public static final String AFTER_ATTRIBUTE = "after";
    public static final String CACHE_SECTION_NAME = "metadata";
    public static final String DEFAULT_SERVER_PATH = "/metadata/get";
    public static final URI DEFAULT_SERVER_URI = URI.create("http://127.0.0.1/");
    public static final String DOMAIN_PROPERTY = "metadata.domain";
    public static final String REQUEST_FILE_NAME = "next-request.xml";
    public static final String RESPONSE_FILE_NAME = "previous-response.xml";
    public static final String SERVER_PROPERTY = "server";
    public static final String TEMPORARY_FILE_NAME = "response.tmp";
    private static final Logger _LOGGER = Logger.getInstance(MetadataCache.class);
    private File _cacheDir;
    private Crypt _crypt;
    private boolean _decrypt;
    private String[] _decryptKeyIdents;
    private String _domain;
    private MetadataFilter _filter;
    private String _from;
    private Reader _reader;
    private URL _serverURL;
    private UUID _uuid;
    private boolean _verify;
    private String[] _verifyKeyIdents;

    MetadataCache() {
    }

    @CheckReturnValue
    String getFrom() {
        return this._from;
    }

    @CheckReturnValue
    Reader getReader() {
        return this._reader;
    }

    @CheckReturnValue
    boolean refresh() {
        String request;
        File requestFile = new File(this._cacheDir, REQUEST_FILE_NAME);
        File responseFile = new File(this._cacheDir, RESPONSE_FILE_NAME);
        String savedRequest = responseFile.exists() && requestFile.exists() ? this._getSavedRequest(requestFile) : null;
        if (savedRequest != null) {
            request = savedRequest;
        } else {
            request = this._filter.getXML(Optional.ofNullable(this._domain), Optional.empty());
            MetadataCache._deleteFile(requestFile);
            MetadataCache._deleteFile(responseFile);
        }
        this._sendRequest(request, this._serverURL, responseFile, requestFile);
        if (responseFile.exists()) {
            this._from = responseFile.toURI().toASCIIString();
            if (this._verify || this._decrypt) {
                Serializable serializable = this._crypt.load(responseFile, this._verify, this._verifyKeyIdents, this._decrypt, this._decryptKeyIdents);
                if (serializable == null) {
                    return false;
                }
                this._reader = new StringReader(serializable.toString());
            } else {
                try {
                    this._reader = new UnicodeStreamReader(responseFile);
                }
                catch (FileNotFoundException exception) {
                    throw new InternalError(exception);
                }
            }
        } else {
            this._from = null;
        }
        return this._from != null;
    }

    @CheckReturnValue
    boolean setUp(@Nonnull Config config, @Nonnull Optional<UUID> uuid, @Nonnull MetadataFilter filter) {
        ConfigProperties configProperties = config.getProperties();
        KeyedGroups metadataProperties = ((KeyedGroups)configProperties).getGroup(CACHE_SECTION_NAME);
        this._serverURL = MetadataCache._getServerURL(metadataProperties.getString(SERVER_PROPERTY).orElse(null));
        if (this._serverURL == null) {
            return false;
        }
        if (!uuid.isPresent()) {
            _LOGGER.warn(ServiceMessages.METADATA_NEEDS_UUID, new Object[0]);
            return false;
        }
        this._uuid = uuid.get();
        this._filter = filter;
        this._domain = metadataProperties.getString(DOMAIN_PROPERTY).orElse(null);
        this._cacheDir = config.getCacheDir(CACHE_SECTION_NAME, Optional.of(this._uuid), this._filter.getClientIdent());
        if (this._cacheDir == null) {
            return false;
        }
        this._verify = metadataProperties.getBoolean("verify");
        if (this._verify) {
            _LOGGER.debug((Messages.Entry)HTTPMessages.WILL_VERIFY, new Object[0]);
            for (String keyIdent : this._verifyKeyIdents = metadataProperties.getStrings("verify.key")) {
                _LOGGER.debug((Messages.Entry)HTTPMessages.VERIFICATION_KEY, keyIdent);
            }
        }
        this._decrypt = metadataProperties.getBoolean("decrypt");
        if (this._decrypt) {
            _LOGGER.debug((Messages.Entry)HTTPMessages.WILL_DECRYPT, new Object[0]);
            this._decryptKeyIdents = metadataProperties.getStrings("devrypt.key");
            for (String keyIdent : this._decryptKeyIdents) {
                _LOGGER.debug((Messages.Entry)HTTPMessages.DECRYPTION_KEY, keyIdent);
            }
        }
        if (this._verify || this._decrypt) {
            SecurityContext securityContext = new SecurityContext(_LOGGER);
            KeyedGroups securityProperties = metadataProperties.getGroup("security");
            if (securityProperties.isMissing()) {
                _LOGGER.warn(ServiceMessages.MISSING_PROPERTIES, "security");
                return false;
            }
            if (!securityContext.setUp(configProperties, securityProperties)) {
                return false;
            }
            this._crypt = new Crypt();
            if (!this._crypt.setUp(securityContext.getCryptProperties(), Optional.empty())) {
                return false;
            }
        }
        return true;
    }

    void tearDown() {
        this._tearDown();
    }

    private static void _deleteFile(File file) {
        if (file.exists() && !file.delete()) {
            _LOGGER.warn(BaseMessages.FILE_DELETE_FAILED, file.getAbsolutePath());
        }
    }

    private static URL _getServerURL(String serverAddress) {
        URL serverURL;
        if (serverAddress != null) {
            String trimmedAddress = serverAddress.trim();
            if (trimmedAddress.length() > 0) {
                try {
                    String serverHost;
                    URI serverURI = new URI(serverAddress.contains("/") ? serverAddress : "//" + serverAddress);
                    if (serverURI.getRawPath().length() <= 1) {
                        serverURI = serverURI.resolve(DEFAULT_SERVER_PATH);
                    }
                    if ((serverHost = serverURI.getHost()) != null && (serverURI = (URI)Inet.substituteURI(serverURI).orElse(null)) == null) {
                        throw new Exception(Message.format(BaseMessages.UNKNOWN_HOST, serverHost));
                    }
                    serverURL = DEFAULT_SERVER_URI.resolve(serverURI).toURL();
                    _LOGGER.debug(ServiceMessages.METADATA_SERVER, serverURL);
                }
                catch (Exception exception) {
                    _LOGGER.warn(ServiceMessages.BAD_ADDRESS_, serverAddress, exception.getMessage());
                    return null;
                }
            } else {
                serverURL = null;
            }
        } else {
            serverURL = null;
        }
        return serverURL;
    }

    private String _getSavedRequest(File requestFile) {
        String request;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(requestFile), StandardCharsets.UTF_8));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append('\n');
            }
            reader.close();
            request = stringBuilder.toString();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        XMLDocument document = new XMLDocument();
        try {
            document.parse(new StringReader(request));
        }
        catch (XMLDocument.ParseException exception) {
            throw new RuntimeException(exception.getCause());
        }
        Optional<String> afterAttribute = document.getRootElement().getAttributeValue(AFTER_ATTRIBUTE, Optional.empty());
        DateTime after = afterAttribute.isPresent() ? DateTime.now().valueOf(afterAttribute.get()) : null;
        return request.equals(this._filter.getXML(Optional.ofNullable(this._domain), Optional.ofNullable(after))) ? request : null;
    }

    private void _sendRequest(String request, URL serverURL, File responseFile, File requestFile) {
        int responseCode;
        OutputStreamWriter writer;
        HttpURLConnection connection;
        try {
            connection = (HttpURLConnection)serverURL.openConnection();
        }
        catch (IOException exception) {
            _LOGGER.warn(ServiceMessages.CONNECTION_OPEN_FAILED, serverURL, exception.getMessage());
            return;
        }
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        try {
            connection.setRequestMethod("POST");
        }
        catch (ProtocolException exception) {
            throw new RuntimeException(exception);
        }
        connection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
        connection.setRequestProperty("Content-Length", String.valueOf(request.length()));
        try {
            connection.connect();
        }
        catch (IOException exception) {
            _LOGGER.warn(ServiceMessages.CONNECTION_FAILED, serverURL, exception.getMessage());
            return;
        }
        try {
            writer = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);
            writer.write(request);
            ((Writer)writer).close();
        }
        catch (IOException exception) {
            _LOGGER.warn(ServiceMessages.UPLOAD_FAILED, serverURL, exception.getMessage());
            return;
        }
        try {
            responseCode = connection.getResponseCode();
        }
        catch (IOException exception) {
            _LOGGER.warn(ServiceMessages.RESPONSE_GET_FAILED, serverURL, exception.getMessage());
            return;
        }
        if (responseCode == 204 && responseFile.exists()) {
            _LOGGER.info(ServiceMessages.METADATA_CACHE_OK, new Object[0]);
            return;
        }
        if (responseCode == 410) {
            _LOGGER.warn(ServiceMessages.NO_GOOD_METADATA, new Object[0]);
            return;
        }
        if (responseCode != 200) {
            try {
                _LOGGER.warn(ServiceMessages.UNEXPECTED_RESPONSE, String.valueOf(responseCode), URLDecoder.decode(connection.getResponseMessage(), StandardCharsets.UTF_8.name()));
                return;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            File temporaryFile = new File(responseFile.getParentFile(), TEMPORARY_FILE_NAME);
            BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(temporaryFile), StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                writer2.write(line);
                ((Writer)writer2).write(10);
            }
            ((Writer)writer2).close();
            reader.close();
            MetadataCache._deleteFile(responseFile);
            if (!temporaryFile.renameTo(responseFile)) {
                _LOGGER.warn(BaseMessages.FILE_RENAME_FAILED, temporaryFile, responseFile);
                return;
            }
            _LOGGER.info(ServiceMessages.METADATA_CACHE_REFRESHED, new Object[0]);
        }
        catch (IOException exception) {
            _LOGGER.warn(ServiceMessages.RESPONSE_READ_FAILED, serverURL, exception.getMessage());
            return;
        }
        String stamp = connection.getHeaderField("RVPF-Metadata-stamp");
        if (stamp != null) {
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(requestFile), StandardCharsets.UTF_8);
                writer.write(this._filter.getXML(Optional.ofNullable(this._domain), Optional.of(DateTime.now().valueOf(stamp))));
                ((Writer)writer).close();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        } else {
            _LOGGER.warn(ServiceMessages.MISSING_HEADER, "RVPF-Metadata-stamp");
        }
        connection.disconnect();
    }

    private void _tearDown() {
        if (this._crypt != null) {
            this._crypt.tearDown();
        }
    }
}

