/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.Attributes;
import org.rvpf.base.Entity;
import org.rvpf.base.Params;
import org.rvpf.base.UUID;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.document.loader.AttributesDefLoader;
import org.rvpf.document.loader.AttributesLoader;
import org.rvpf.document.loader.BehaviorLoader;
import org.rvpf.document.loader.ConfigDocumentLoader;
import org.rvpf.document.loader.ContentLoader;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.DocumentLoader;
import org.rvpf.document.loader.EngineLoader;
import org.rvpf.document.loader.GroupLoader;
import org.rvpf.document.loader.MetadataCache;
import org.rvpf.document.loader.MetadataElementLoader;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.document.loader.OriginLoader;
import org.rvpf.document.loader.ParamDefLoader;
import org.rvpf.document.loader.PermissionsLoader;
import org.rvpf.document.loader.PointLoader;
import org.rvpf.document.loader.StoreLoader;
import org.rvpf.document.loader.SyncLoader;
import org.rvpf.document.loader.TransformLoader;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.AttributesDefEntity;
import org.rvpf.metadata.entity.ParamDefEntity;
import org.rvpf.service.ServiceMessages;

public final class MetadataDocumentLoader
extends ConfigDocumentLoader {
    public static final String DEFAULT_PATH = "resource:rvpf-metadata.xml";
    public static final String METADATA_PROPERTIES = "metadata";
    public static final String METADATA_ROOT = "metadata";
    public static final String PATH_PROPERTY = "path";
    private static final String[][] _PREFIX_NAMES = new String[][]{{"A", "AttributesDef"}, {"H", "Behavior"}, {"N", "Content"}, {"G", "Engine"}, {"U", "Group"}, {"O", "Origin"}, {"M", "ParamDef"}, {"I", "Permissions"}, {"P", "Point"}, {"S", "Store"}, {"V", "Sync"}, {"T", "Transform"}};
    private final Metadata _metadata;
    private boolean _reloading;

    MetadataDocumentLoader(@Nonnull Metadata metadata) {
        super(metadata, "metadata");
        this._metadata = metadata;
        this.addPrefixNames(_PREFIX_NAMES);
        this.handle("AttributesDef", new AttributesDefLoader());
        this.handle("Behavior", new BehaviorLoader());
        this.handle("Content", new ContentLoader());
        this.handle("Engine", new EngineLoader());
        this.handle("Group", new GroupLoader());
        this.handle("Origin", new OriginLoader());
        this.handle("ParamDef", new ParamDefLoader());
        this.handle("Permissions", new PermissionsLoader());
        this.handle("Point", new PointLoader());
        this.handle("Processor", new OriginLoader());
        this.handle("Store", new StoreLoader());
        this.handle("Sync", new SyncLoader());
        this.handle("Transform", new TransformLoader());
        this.handle("attributes", new AttributesLoader());
    }

    @Nullable
    @CheckReturnValue
    public static Metadata fetchMetadata(@Nonnull MetadataFilter filter, @Nonnull Optional<Config> config, @Nonnull Optional<UUID> uuid, @Nonnull Optional<String> from) {
        MetadataDocumentLoader document;
        Reader reader = null;
        if (!config.isPresent()) {
            config = Optional.ofNullable(ConfigDocumentLoader.loadConfig("", Optional.empty(), Optional.empty()));
            if (!config.isPresent()) {
                return null;
            }
        } else if (!config.get().getProperties().getOverrider().isPresent()) {
            config.get().fetchSystemProperties();
        }
        Metadata metadata = new Metadata(config.get());
        metadata.setFilter(filter);
        if (!from.isPresent()) {
            MetadataCache metadataCache = new MetadataCache();
            if (metadataCache.setUp(config.get(), uuid, filter) && metadataCache.refresh()) {
                from = Optional.ofNullable(metadataCache.getFrom());
                reader = metadataCache.getReader();
            }
            metadataCache.tearDown();
        }
        if (!from.isPresent()) {
            KeyedGroups metadataProperties = config.get().getPropertiesGroup("metadata");
            from = metadataProperties.getString(PATH_PROPERTY, Optional.of(DEFAULT_PATH));
        }
        if (!(document = new MetadataDocumentLoader(metadata)).loadFrom(from.get(), Optional.ofNullable(reader))) {
            return null;
        }
        if (!filter.tidy(metadata)) {
            return null;
        }
        if (!filter.areEntitiesKept()) {
            metadata.returnEntities();
        }
        return metadata;
    }

    @Override
    protected DocumentLoader.RootHandler getRootHandler() {
        return new MetadataHandler();
    }

    @Override
    protected URL getURL() {
        return this._metadata.getURL();
    }

    @Override
    protected boolean loadFrom(String from, Optional<Reader> reader) {
        this._reloading = !this.getEntities().isPresent();
        boolean success = super.loadFrom(from, reader);
        if (this.getMetadata().getDomain().length() > 0) {
            this.getThisLogger().debug(ServiceMessages.METADATA_DOMAIN, this.getMetadata().getDomain());
        }
        return success;
    }

    @Override
    protected boolean read(String xml) {
        if (!super.read(xml)) {
            return false;
        }
        MetadataFilter filter = this._metadata.getFilter();
        if (!filter.tidy(this._metadata)) {
            return false;
        }
        if (!filter.areEntitiesKept()) {
            this._metadata.returnEntities();
        }
        return true;
    }

    @Nonnull
    @CheckReturnValue
    Optional<KeyedGroups> getAttributes(@Nonnull MetadataElementLoader loader, @Nonnull DocumentElement element) throws ValidationException {
        KeyedGroups attributesMap = null;
        if (this.getFilter().areAttributesNeeded()) {
            for (DocumentElement attributesElement : element.getChildren("attributes")) {
                Attributes attributes;
                Optional<AttributesDefEntity> attributesDef;
                if (!attributesElement.isEnabled()) continue;
                String usage = attributesElement.getAttributeValue("usage", Optional.of("\u0000")).orElse(null);
                String upperUsage = usage.toUpperCase(Locale.ROOT);
                if (!this.getFilter().areAttributesNeeded(upperUsage)) continue;
                Optional<Entity> optional = attributesDef = this.isValidationEnabled() ? this.getEntity(upperUsage, "A") : Optional.empty();
                if (attributesMap == null) {
                    attributesMap = new KeyedGroups();
                }
                if (attributesDef.isPresent() && ((AttributesDefEntity)attributesDef.get()).isHidden()) {
                    attributesMap.setValuesHidden(upperUsage);
                }
                if ((attributes = (Attributes)attributesMap.getObject(upperUsage).orElse(null)) == null) {
                    attributes = new Attributes(usage);
                    attributesMap.setValue(upperUsage, attributes);
                }
                if (attributesElement.getAttributeValue("hidden", false)) {
                    attributes.setHidden(true);
                }
                this._fetchAttributes(loader, attributesElement, attributes, attributesDef);
                attributes.freeze();
            }
            if (attributesMap != null) {
                attributesMap.freeze();
            }
        }
        return Optional.ofNullable(attributesMap);
    }

    @Nonnull
    @CheckReturnValue
    MetadataFilter getFilter() {
        return this._metadata.getFilter();
    }

    @Nonnull
    @CheckReturnValue
    Metadata getMetadata() {
        return this._metadata;
    }

    @Nonnull
    @CheckReturnValue
    Optional<Params> getParams(@Nonnull MetadataElementLoader loader, @Nonnull DocumentElement element, @Nonnull String holder) throws ValidationException {
        Params params = new Params();
        String prefix = "M" + holder;
        for (DocumentElement paramElement : element.getChildren("param")) {
            if (!paramElement.isEnabled()) continue;
            String paramName = paramElement.getAttributeValue("name", Optional.empty()).orElse(null);
            ParamDefEntity paramDef = null;
            if (paramName == null || this.isValidationEnabled()) {
                String def = paramElement.getAttributeValue("def", Optional.empty()).orElse(null);
                if (def != null) {
                    if (paramName != null) {
                        this.getThisLogger().warn(ServiceMessages.IGNORED_ATTRIBUTE, "name");
                    }
                    if ((paramDef = (ParamDefEntity)this.getEntity(def, prefix).orElse(null)) == null) {
                        this.getThisLogger().warn(ServiceMessages.PARAM_DEF_NOT_FOUND, def, holder);
                        continue;
                    }
                    if (!holder.equals(paramDef.getHolder())) {
                        this.getThisLogger().warn(ServiceMessages.UNEXPECTED_PARAM_DEF_HOLDER, holder, def, paramDef.getHolder());
                        continue;
                    }
                    paramName = paramDef.getName().get();
                } else if (paramName != null) {
                    paramDef = this.getEntity(paramName, prefix).orElse(null);
                    if (paramDef == null) {
                        this.getThisLogger().warn(ServiceMessages.PARAM_DEF_NOT_FOUND, paramName, holder);
                    }
                } else {
                    this.getThisLogger().warn(ServiceMessages.PARAM_DEF_NOT_NAMED, "name", "def");
                    continue;
                }
            }
            loader.putValues(paramName, paramElement, this._metadata.getProperties(), Optional.ofNullable(paramDef), params);
        }
        if (params.isEmpty()) {
            return Optional.empty();
        }
        params.freeze();
        return Optional.of(params);
    }

    @Override
    boolean isValidationEnabled() {
        return !this._reloading && super.isValidationEnabled();
    }

    private void _fetchAttributes(MetadataElementLoader loader, DocumentElement attributesElement, Attributes attributes, Optional<AttributesDefEntity> attributesDef) throws ValidationException {
        for (DocumentElement attributeElement : attributesElement.getChildren("attribute")) {
            Optional attributeDef;
            if (!attributeElement.isEnabled()) continue;
            String attributeName = attributeElement.getAttributeValue("name");
            String upperAttributeName = attributeName.toUpperCase(Locale.ROOT);
            Optional<Object> optional = attributeDef = attributesDef.isPresent() ? attributesDef.get().getAttributeDef(upperAttributeName) : Optional.empty();
            if (attributesDef.isPresent() && !attributeDef.isPresent() && attributeElement.getAttributeValue("validated", true)) {
                this.getThisLogger().warn(ServiceMessages.ATTRIBUTE_DEF_MISSING, attributeName, attributesDef.get().getUsage());
            }
            loader.putValues(upperAttributeName, attributeElement, this._metadata.getProperties(), attributeDef, attributes);
        }
    }

    protected class MetadataHandler
    extends ConfigDocumentLoader.ConfigHandler {
        protected MetadataHandler() {
        }

        @Override
        public void onRootEnd() {
            Optional<String> domain;
            super.onRootEnd();
            if (this.isEnabled() && (domain = this.getAttribute("domain")).isPresent()) {
                MetadataDocumentLoader.this.getMetadata().setDomain(domain.get());
            }
        }
    }
}

