/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Entity;
import org.rvpf.base.Params;
import org.rvpf.base.UUID;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.TopologicalErrorException;
import org.rvpf.document.loader.ConfigElementLoader;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.MetadataDocumentLoader;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.Text;
import org.rvpf.metadata.entity.GroupEntity;
import org.rvpf.metadata.entity.MetadataEntity;
import org.rvpf.service.ServiceMessages;

public abstract class MetadataElementLoader
extends ConfigElementLoader {
    public static final String ANCHORED_ATTRIBUTE = "anchored";
    public static final String ARG_ELEMENT = "arg";
    public static final String ATTRIBUTES_DEF_ENTITY = "AttributesDef";
    public static final String ATTRIBUTES_ELEMENT = "attributes";
    public static final String ATTRIBUTE_DEF_ELEMENT = "AttributeDef";
    public static final String ATTRIBUTE_ELEMENT = "attribute";
    public static final String BEHAVIOR_ENTITY = "Behavior";
    public static final String BEHAVIOR_REFERENCE = "behavior";
    public static final String CLONE_ATTRIBUTE = "clone";
    public static final String CONTENT_ENTITY = "Content";
    public static final String CONTENT_REFERENCE = "content";
    public static final String CONTROL_ATTRIBUTE = "control";
    public static final String CONVERT_ATTRIBUTE = "convert";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String DOMAIN_ATTRIBUTE = "domain";
    public static final String ELEMENT_ATTRIBUTE = "element";
    public static final String ENGINE_ENTITY = "Engine";
    public static final String ENGINE_REFERENCE = "engine";
    public static final String GROUP_ENTITY = "Group";
    public static final String GROUP_REFERENCE = "group";
    public static final String HOLDER_ATTRIBUTE = "holder";
    public static final String IDENT_ATTRIBUTE = "ident";
    public static final String INPUT_ELEMENT = "input";
    public static final String MEMBER_ELEMENT = "member";
    public static final String NOTES_ATTRIBUTE = "notes";
    public static final String NOTES_ELEMENT = "notes";
    public static final String ORIGIN_ENTITY = "Origin";
    public static final String ORIGIN_REFERENCE = "origin";
    public static final String OTHER_ELEMENT = "other";
    public static final String PARAM_DEF_ENTITY = "ParamDef";
    public static final String PARAM_ELEMENT = "param";
    public static final String PERMISSIONS_ELEMENT = "permissions";
    public static final String PERMISSIONS_ENTITY = "Permissions";
    public static final String PERMISSIONS_REFERENCE = "permissions";
    public static final String POINT_ENTITY = "Point";
    public static final String POINT_REFERENCE = "point";
    public static final String PROCESSOR_ENTITY = "Processor";
    public static final String PROCESSOR_REFERENCE = "processor";
    public static final String REPLICATE_ELEMENT = "replicate";
    public static final String STORE_ENTITY = "Store";
    public static final String STORE_REFERENCE = "store";
    public static final String SYNC_ENTITY = "Sync";
    public static final String SYNC_REFERENCE = "sync";
    public static final String TEXT_ELEMENT = "text";
    public static final String TITLE_ATTRIBUTE = "title";
    public static final String TITLE_ELEMENT = "title";
    public static final String TRANSFORM_ENTITY = "Transform";
    public static final String TRANSFORM_REFERENCE = "transform";
    public static final String UNSPECIFIED_CONTENT = "Unspecified";
    public static final String UNSPECIFIED_ORIGIN = "Unspecified";
    public static final String UNSPECIFIED_STORE = "Unspecified";
    public static final String UNSPECIFIED_TRANSFORM = "Unspecified";
    public static final String USAGE_ATTRIBUTE = "usage";

    protected void anchorEntity(@Nonnull Entity entity) {
        if (this.getElement().getAttributeValue(ANCHORED_ATTRIBUTE, false)) {
            this.getMetadata().anchor(entity);
        }
    }

    @Override
    protected final Optional<String> getLang() {
        return this.getElement().getAttributeValue("lang", super.getLang());
    }

    @Override
    protected final void updateTexts() {
        MetadataEntity entity;
        Optional<UUID> uuid;
        String entityPrefix = this.getEntityPrefix();
        if (entityPrefix.isEmpty() || !this.getMetadataFilter().areTextsNeeded()) {
            return;
        }
        String key = this.getElement().getId().orElse(null);
        if (key == null && (uuid = this.getElement().getUUID()).isPresent()) {
            key = uuid.get().toString();
        }
        if (key == null) {
            key = this.getElement().getNameAttribute().orElse(null);
        }
        if (key == null) {
            this.getLogger().warn(ServiceMessages.ENTITY_FOR_LANG, this.getElement().getName(), this.getLang().orElse(null));
            return;
        }
        try {
            entity = (MetadataEntity)this.getEntity(key, entityPrefix);
        }
        catch (ValidationException exception) {
            this.getLogger().warn(BaseMessages.VERBATIM, exception.getMessage());
            return;
        }
        this._updateTexts(entity);
    }

    final void addGroupMember(@Nonnull Entity member) throws ValidationException {
        if (this.getMetadataFilter().areGroupsNeeded()) {
            Optional<String> groupReference = this.getElement().getAttributeValue(GROUP_REFERENCE, Optional.empty());
            if (groupReference.isPresent()) {
                this._addGroupMember(member, groupReference.get());
            }
            for (DocumentElement groupReferenceElement : this.getElement().getChildren(GROUP_REFERENCE)) {
                groupReference = groupReferenceElement.getAttributeValue(GROUP_REFERENCE, Optional.empty());
                if (!groupReference.isPresent()) {
                    throw new ValidationException(ServiceMessages.MISSING_ATTRIBUTE_IN, GROUP_REFERENCE, groupReferenceElement.getName());
                }
                this._addGroupMember(member, groupReference.get());
            }
        }
    }

    @Nonnull
    @CheckReturnValue
    final Optional<KeyedGroups> getAttributes(@Nonnull DocumentElement element) throws ValidationException {
        return ((MetadataDocumentLoader)this.getDocumentLoader()).getAttributes(this, element);
    }

    @Nonnull
    @CheckReturnValue
    String getEntityPrefix() {
        return "";
    }

    @Nonnull
    @CheckReturnValue
    final Metadata getMetadata() {
        return ((MetadataDocumentLoader)this.getDocumentLoader()).getMetadata();
    }

    @Nonnull
    @CheckReturnValue
    final MetadataFilter getMetadataFilter() {
        return ((MetadataDocumentLoader)this.getDocumentLoader()).getFilter();
    }

    @Nonnull
    @CheckReturnValue
    final Optional<Params> getParams(@Nonnull DocumentElement element, @Nonnull String holder) throws ValidationException {
        return ((MetadataDocumentLoader)this.getDocumentLoader()).getParams(this, element, holder);
    }

    final void setUpEntity(@Nonnull MetadataEntity entity) {
        entity.setUUID(this.getElement().getUUID());
        entity.setName(this.getElement().getNameAttribute());
        this._updateTexts(entity);
    }

    final MetadataEntity.Builder setUpEntityBuilder(@Nonnull MetadataEntity.Builder metadataEntityBuilder) {
        metadataEntityBuilder.setUUID(this.getElement().getUUID().orElse(null)).setName((String)this.getElement().getNameAttribute().orElse(null));
        this._updateTexts(metadataEntityBuilder);
        return metadataEntityBuilder;
    }

    private static void _addTexts(DocumentElement element, String defaultLang, MetadataEntity entity) {
        Text text = new Text(Optional.ofNullable(defaultLang));
        text.setIdent(element.getAttributeValue(IDENT_ATTRIBUTE, Optional.empty()));
        text.setTitle(element.getAttributeValue("title", Optional.empty()));
        text.setDescription(element.getAttributeValue("description", Optional.empty()));
        text.addNotes(element.getAttributeValue("notes", Optional.empty()));
        if (!text.isEmpty()) {
            entity.addText(text);
        }
        for (DocumentElement titleElement : element.getChildren("title")) {
            text = new Text(titleElement.getAttributeValue("lang", Optional.ofNullable(defaultLang)));
            text.setTitle(Optional.of(titleElement.getText()));
            entity.addText(text);
        }
        for (DocumentElement descriptionElement : element.getChildren("description")) {
            text = new Text(descriptionElement.getAttributeValue("lang", Optional.ofNullable(defaultLang)));
            text.setDescription(Optional.of(descriptionElement.getText()));
            entity.addText(text);
        }
        for (DocumentElement notesElement : element.getChildren("notes")) {
            text = new Text(notesElement.getAttributeValue("lang", Optional.ofNullable(defaultLang)));
            text.addNotes(Optional.of(notesElement.getText()));
            entity.addText(text);
        }
        for (DocumentElement otherElement : element.getChildren(OTHER_ELEMENT)) {
            text = new Text(otherElement.getAttributeValue("lang", Optional.ofNullable(defaultLang)));
            text.addOther(otherElement.getAttributeValue(ELEMENT_ATTRIBUTE, Optional.empty()).orElse(null), otherElement.getText());
            entity.addText(text);
        }
    }

    private static void _addTexts(DocumentElement element, String defaultLang, MetadataEntity.Builder entityBuilder) {
        Text text = new Text(Optional.ofNullable(defaultLang));
        text.setIdent(element.getAttributeValue(IDENT_ATTRIBUTE, Optional.empty()));
        text.setTitle(element.getAttributeValue("title", Optional.empty()));
        text.setDescription(element.getAttributeValue("description", Optional.empty()));
        text.addNotes(element.getAttributeValue("notes", Optional.empty()));
        if (!text.isEmpty()) {
            entityBuilder.addText(text);
        }
        for (DocumentElement titleElement : element.getChildren("title")) {
            text = new Text(titleElement.getAttributeValue("lang", Optional.ofNullable(defaultLang)));
            text.setTitle(Optional.of(titleElement.getText()));
            entityBuilder.addText(text);
        }
        for (DocumentElement descriptionElement : element.getChildren("description")) {
            text = new Text(descriptionElement.getAttributeValue("lang", Optional.ofNullable(defaultLang)));
            text.setDescription(Optional.of(descriptionElement.getText()));
            entityBuilder.addText(text);
        }
        for (DocumentElement notesElement : element.getChildren("notes")) {
            text = new Text(notesElement.getAttributeValue("lang", Optional.ofNullable(defaultLang)));
            text.addNotes(Optional.of(notesElement.getText()));
            entityBuilder.addText(text);
        }
        for (DocumentElement otherElement : element.getChildren(OTHER_ELEMENT)) {
            text = new Text(otherElement.getAttributeValue("lang", Optional.ofNullable(defaultLang)));
            text.addOther(otherElement.getAttributeValue(ELEMENT_ATTRIBUTE, Optional.empty()).orElse(null), otherElement.getText());
            entityBuilder.addText(text);
        }
    }

    private void _addGroupMember(Entity groupMember, String groupReference) throws ValidationException {
        boolean addedToGroup;
        GroupEntity groupEntity = (GroupEntity)this.getEntity(groupReference, "U");
        try {
            addedToGroup = groupEntity.addMember(groupMember);
        }
        catch (TopologicalErrorException exception) {
            throw new RuntimeException(exception);
        }
        if (!addedToGroup) {
            this.getLogger().warn(ServiceMessages.DUPLICATE_GROUP_ENTRY, this.getElement().getName(), groupMember.getName().orElse(null), groupEntity.getName().orElse(null));
        }
    }

    private void _updateTexts(MetadataEntity entity) {
        if (this.getMetadataFilter().areTextsNeeded()) {
            DocumentElement element = this.getElement();
            Optional<String> defaultLang = this.getLang();
            MetadataElementLoader._addTexts(element, (String)defaultLang.orElse(null), entity);
            for (DocumentElement textElement : element.getChildren(TEXT_ELEMENT)) {
                String lang = textElement.getAttributeValue("lang", defaultLang).orElse(null);
                MetadataElementLoader._addTexts(textElement, lang, entity);
            }
        }
    }

    private void _updateTexts(MetadataEntity.Builder entityBuilder) {
        if (this.getMetadataFilter().areTextsNeeded()) {
            DocumentElement element = this.getElement();
            Optional<String> defaultLang = this.getLang();
            MetadataElementLoader._addTexts(element, (String)defaultLang.orElse(null), entityBuilder);
            for (DocumentElement textElement : element.getChildren(TEXT_ELEMENT)) {
                String lang = textElement.getAttributeValue("lang", defaultLang).orElse(null);
                MetadataElementLoader._addTexts(textElement, lang, entityBuilder);
            }
        }
    }
}

