/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.base.xml.XMLDocument;
import org.rvpf.base.xml.XMLElement;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.EngineEntity;
import org.rvpf.metadata.entity.OriginEntity;
import org.rvpf.metadata.entity.PointEntity;
import org.rvpf.metadata.entity.StoreEntity;

@ThreadSafe
public class MetadataFilter
implements Cloneable {
    public static final String AFTER_ATTRIBUTE = "after";
    public static final String ATTRIBUTES_ELEMENT = "attributes";
    public static final String CONTENTS_ELEMENT = "contents";
    public static final String DOMAIN_ATTRIBUTE = "domain";
    public static final String ENGINES_ELEMENT = "engines";
    public static final String ENGINE_ATTRIBUTE = "engine";
    public static final String ENGINE_ELEMENT = "engine";
    public static final String GET_METADATA_ROOT = "get-metadata";
    public static final String GROUPS_ELEMENT = "groups";
    public static final String GROUP_ELEMENT = "group";
    public static final String INPUTS_ELEMENT = "inputs";
    public static final String ORIGINS_ELEMENT = "origins";
    public static final String ORIGIN_ATTRIBUTE = "origin";
    public static final String ORIGIN_ELEMENT = "origin";
    public static final String POINTS_ELEMENT = "points";
    public static final String PROPERTIES_ELEMENT = "properties";
    public static final String REPLICATES_ELEMENT = "replicates";
    public static final String RESULTS_ELEMENT = "results";
    public static final String STORES_ELEMENT = "stores";
    public static final String STORE_ATTRIBUTE = "store";
    public static final String STORE_ELEMENT = "store";
    public static final String SYNCS_ELEMENT = "syncs";
    public static final String TEXTS_ELEMENT = "texts";
    public static final String TRANSFORMS_ELEMENT = "transforms";
    private MetadataFilter _defaults;
    private final boolean _keepEntities;

    public MetadataFilter(boolean keepEntities) {
        this._keepEntities = keepEntities;
        this._defaults = this instanceof _Defaults ? null : new _Defaults(this);
    }

    @CheckReturnValue
    public boolean areAttributesNeeded() {
        return this._defaults.areAttributesNeeded();
    }

    @CheckReturnValue
    public boolean areAttributesNeeded(@Nonnull String usage) {
        return this._defaults.areAttributesNeeded(usage);
    }

    @CheckReturnValue
    public boolean areBehaviorsNeeded() {
        return this._defaults.areBehaviorsNeeded();
    }

    @CheckReturnValue
    public boolean areContentsNeeded() {
        return this._defaults.areContentsNeeded();
    }

    @CheckReturnValue
    public boolean areContentsRequired() {
        return this._defaults.areContentsRequired();
    }

    @CheckReturnValue
    public boolean areEnginesFiltered() {
        return this._defaults.areEnginesFiltered();
    }

    @CheckReturnValue
    public boolean areEnginesNeeded() {
        return this._defaults.areEnginesNeeded();
    }

    @CheckReturnValue
    public boolean areEntitiesKept() {
        return this._keepEntities;
    }

    @CheckReturnValue
    public boolean areGroupsNeeded() {
        return this._defaults.areGroupsNeeded();
    }

    @CheckReturnValue
    public boolean areOriginsFiltered() {
        return this._defaults.areOriginsFiltered();
    }

    @CheckReturnValue
    public boolean areOriginsNeeded() {
        return this._defaults.areOriginsNeeded();
    }

    @CheckReturnValue
    public boolean areOriginsRequired() {
        return this._defaults.areOriginsRequired();
    }

    @CheckReturnValue
    public boolean arePermissionsNeeded() {
        return this._defaults.arePermissionsNeeded();
    }

    @CheckReturnValue
    public boolean arePointInputsFlagged() {
        return this._defaults.arePointInputsFlagged();
    }

    @CheckReturnValue
    public boolean arePointInputsNeeded() {
        return this._defaults.arePointInputsNeeded();
    }

    @CheckReturnValue
    public boolean arePointInputsNeeded(@Nonnull PointEntity pointEntity) throws ValidationException {
        return this._defaults.arePointInputsNeeded(pointEntity);
    }

    @CheckReturnValue
    public boolean arePointReplicatesNeeded() {
        return this._defaults.arePointReplicatesNeeded();
    }

    @CheckReturnValue
    public boolean arePointsNeeded() {
        return this._defaults.arePointsNeeded();
    }

    @CheckReturnValue
    public boolean areStoresFiltered() {
        return this._defaults.areStoresFiltered();
    }

    @CheckReturnValue
    public boolean areStoresNeeded() {
        return this._defaults.areStoresNeeded();
    }

    @CheckReturnValue
    public boolean areStoresRequired() {
        return this._defaults.areStoresRequired();
    }

    @CheckReturnValue
    public boolean areSyncsNeeded() {
        return this._defaults.areSyncsNeeded();
    }

    @CheckReturnValue
    public boolean areTextsNeeded() {
        return this._defaults.areTextsNeeded();
    }

    @CheckReturnValue
    public boolean areTransformsNeeded() {
        return this._defaults.areTransformsNeeded();
    }

    @CheckReturnValue
    public boolean areTransformsRequired() {
        return this._defaults.areTransformsRequired();
    }

    public final MetadataFilter clone() {
        MetadataFilter clone;
        try {
            clone = (MetadataFilter)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception);
        }
        clone.reset();
        return clone;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<String> getClientIdent() {
        return this._defaults.getClientIdent();
    }

    @Nonnull
    @CheckReturnValue
    public String getXML(@Nonnull Optional<String> domain, @Nonnull Optional<DateTime> after) {
        XMLDocument document = new XMLDocument(GET_METADATA_ROOT);
        XMLElement root = document.getRootElement();
        if (domain.isPresent()) {
            root.setAttribute(DOMAIN_ATTRIBUTE, domain.get());
        }
        if (after.isPresent()) {
            root.setAttribute(AFTER_ATTRIBUTE, after.get().toString());
        }
        root.addChild(PROPERTIES_ELEMENT);
        this.includePointsXML(root);
        this.includeInputsXML(root);
        this.includeResultsXML(root);
        this.includeReplicatesXML(root);
        this.includeContentsXML(root);
        this.includeOriginsXML(root);
        this.includeStoresXML(root);
        this.includeSyncsXML(root);
        this.includeEnginesXML(root);
        this.includeTransformsXML(root);
        this.includeGroupsXML(root);
        this.includeAttributesXML(root);
        this.includeTextsXML(root);
        return document.toString();
    }

    @CheckReturnValue
    public boolean isEngineNeeded(@Nonnull EngineEntity engineEntity) throws ValidationException {
        return this._defaults.isEngineNeeded(engineEntity);
    }

    @CheckReturnValue
    public boolean isOriginNeeded(@Nonnull OriginEntity originEntity) throws ValidationException {
        return this._defaults.isOriginNeeded(originEntity);
    }

    @CheckReturnValue
    public boolean isPointNeeded(@Nonnull PointEntity pointEntity) throws ValidationException {
        return this._defaults.isPointNeeded(pointEntity);
    }

    @CheckReturnValue
    public boolean isPointTransformNeeded(@Nonnull PointEntity pointEntity) throws ValidationException {
        return this._defaults.isPointTransformNeeded(pointEntity);
    }

    @CheckReturnValue
    public boolean isStoreNeeded(@Nonnull StoreEntity storeEntity) throws ValidationException {
        return this._defaults.isStoreNeeded(storeEntity);
    }

    @CheckReturnValue
    public boolean tidy(@Nonnull Metadata metadata) {
        boolean success = true;
        for (Point point : metadata.getPointsCollection()) {
            success &= ((PointEntity)point).tidy();
        }
        return success && this._defaults.tidy(metadata);
    }

    public String toString() {
        return this.getXML(Optional.empty(), Optional.empty());
    }

    @CheckReturnValue
    protected MetadataFilter callBack() {
        return this;
    }

    protected void includeAttributesXML(@Nonnull XMLElement root) {
        if (this.callBack().areAttributesNeeded()) {
            root.addChild(ATTRIBUTES_ELEMENT);
        }
    }

    protected void includeContentsXML(@Nonnull XMLElement root) {
        if (this.callBack().areContentsNeeded()) {
            root.addChild(CONTENTS_ELEMENT);
        }
    }

    protected void includeEnginesXML(@Nonnull XMLElement root) {
        if (this.callBack().areEnginesNeeded()) {
            root.addChild(ENGINES_ELEMENT);
        }
    }

    protected void includeGroupsXML(@Nonnull XMLElement root) {
        if (this.callBack().areGroupsNeeded()) {
            root.addChild(GROUPS_ELEMENT);
        }
    }

    protected void includeInputsXML(@Nonnull XMLElement root) {
        MetadataFilter callBack = this.callBack();
        if (callBack.arePointInputsNeeded() || callBack.arePointInputsFlagged()) {
            root.addChild(INPUTS_ELEMENT);
        }
    }

    protected void includeOriginsXML(@Nonnull XMLElement root) {
        if (this.callBack().areOriginsNeeded()) {
            root.addChild(ORIGINS_ELEMENT);
        }
    }

    protected void includePointsXML(@Nonnull XMLElement root) {
        if (this.callBack().arePointsNeeded()) {
            root.addChild(POINTS_ELEMENT);
        }
    }

    protected void includeReplicatesXML(@Nonnull XMLElement root) {
        if (this.callBack().arePointReplicatesNeeded()) {
            root.addChild(REPLICATES_ELEMENT);
        }
    }

    protected void includeResultsXML(@Nonnull XMLElement root) {
        if (this.callBack().arePointInputsNeeded()) {
            root.addChild(RESULTS_ELEMENT);
        }
    }

    protected void includeStoresXML(@Nonnull XMLElement root) {
        if (this.callBack().areStoresNeeded()) {
            root.addChild(STORES_ELEMENT);
        }
    }

    protected void includeSyncsXML(@Nonnull XMLElement root) {
        if (this.callBack().areSyncsNeeded()) {
            root.addChild(SYNCS_ELEMENT);
        }
    }

    protected void includeTextsXML(@Nonnull XMLElement root) {
        if (this.callBack().areTextsNeeded()) {
            root.addChild(TEXTS_ELEMENT);
        }
    }

    protected void includeTransformsXML(@Nonnull XMLElement root) {
        if (this.callBack().areTransformsNeeded()) {
            root.addChild(TRANSFORMS_ELEMENT);
        }
    }

    protected void reset() {
    }

    private static final class _Defaults
    extends MetadataFilter {
        private MetadataFilter _child;

        _Defaults(MetadataFilter child) {
            super(false);
            this._child = child;
        }

        @Override
        public boolean areAttributesNeeded() {
            return false;
        }

        @Override
        public boolean areAttributesNeeded(String usage) {
            return this.callBack().areAttributesNeeded();
        }

        @Override
        public boolean areBehaviorsNeeded() {
            return false;
        }

        @Override
        public boolean areContentsNeeded() {
            return this.callBack().arePointInputsNeeded();
        }

        @Override
        public boolean areContentsRequired() {
            return this.callBack().areContentsNeeded();
        }

        @Override
        public boolean areEnginesFiltered() {
            return !this.callBack().areEnginesNeeded();
        }

        @Override
        public boolean areEnginesNeeded() {
            return this.callBack().areTransformsNeeded();
        }

        @Override
        public boolean areEntitiesKept() {
            throw new InternalError();
        }

        @Override
        public boolean areGroupsNeeded() {
            return false;
        }

        @Override
        public boolean areOriginsFiltered() {
            return !this.callBack().areOriginsNeeded();
        }

        @Override
        public boolean areOriginsNeeded() {
            return false;
        }

        @Override
        public boolean areOriginsRequired() {
            return this.callBack().areOriginsNeeded();
        }

        @Override
        public boolean arePermissionsNeeded() {
            return false;
        }

        @Override
        public boolean arePointInputsFlagged() {
            return false;
        }

        @Override
        public boolean arePointInputsNeeded() {
            return false;
        }

        @Override
        public boolean arePointInputsNeeded(PointEntity pointEntity) {
            return this.callBack().arePointInputsNeeded();
        }

        @Override
        public boolean arePointReplicatesNeeded() {
            return false;
        }

        @Override
        public boolean arePointsNeeded() {
            return true;
        }

        @Override
        public boolean areStoresFiltered() {
            return !this.callBack().areStoresNeeded();
        }

        @Override
        public boolean areStoresNeeded() {
            return false;
        }

        @Override
        public boolean areStoresRequired() {
            return this.callBack().areStoresNeeded();
        }

        @Override
        public boolean areSyncsNeeded() {
            return this.callBack().arePointsNeeded();
        }

        @Override
        public boolean areTextsNeeded() {
            return false;
        }

        @Override
        public boolean areTransformsNeeded() {
            return false;
        }

        @Override
        public boolean areTransformsRequired() {
            return false;
        }

        @Override
        public Optional<String> getClientIdent() {
            return Optional.empty();
        }

        @Override
        public boolean isEngineNeeded(EngineEntity engineEntity) {
            return this.callBack().areEnginesNeeded();
        }

        @Override
        public boolean isOriginNeeded(OriginEntity originEntity) {
            return this.callBack().areOriginsNeeded();
        }

        @Override
        public boolean isPointNeeded(PointEntity pointEntity) {
            return this.callBack().arePointsNeeded();
        }

        @Override
        public boolean isPointTransformNeeded(PointEntity pointEntity) {
            return this.callBack().areTransformsNeeded();
        }

        @Override
        public boolean isStoreNeeded(StoreEntity storeEntity) throws ValidationException {
            return this.callBack().areStoresNeeded();
        }

        @Override
        public boolean tidy(Metadata metadata) {
            return true;
        }

        @Override
        protected MetadataFilter callBack() {
            return this._child.callBack();
        }
    }
}

