/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Optional;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.MetadataElementLoader;
import org.rvpf.metadata.entity.OriginEntity;

final class OriginLoader
extends MetadataElementLoader {
    OriginLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        if (!this.getMetadataFilter().areOriginsNeeded()) {
            return;
        }
        OriginEntity.Builder originEntityBuilder = OriginEntity.newBuilder();
        this.setUpEntityBuilder(originEntityBuilder);
        DocumentElement originElement = this.getElement();
        originEntityBuilder.setParams(this.getParams(originElement, "Origin")).setAttributes(this.getAttributes(originElement));
        OriginEntity origin = originEntityBuilder.build();
        if (this.getMetadataFilter().isOriginNeeded(origin)) {
            this.addGroupMember(origin);
            this.getMetadata().addOriginEntity(Optional.of(origin));
            this.anchorEntity(origin);
            this.putEntity(origin);
        }
    }

    @Override
    String getEntityPrefix() {
        return "O";
    }
}

