/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import org.rvpf.base.UUID;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.base.tool.ValueConverter;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.MetadataElementLoader;
import org.rvpf.metadata.Permissions;
import org.rvpf.metadata.entity.PermissionsEntity;
import org.rvpf.service.ServiceMessages;

final class PermissionsLoader
extends MetadataElementLoader {
    PermissionsLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        PermissionsEntity parent;
        PermissionsEntity permissions;
        DocumentElement permissionsElement = this.getElement();
        Optional<String> name = permissionsElement.getNameAttribute();
        Optional<UUID> uuid = permissionsElement.getUUID();
        PermissionsEntity permissionsEntity = permissions = name.isPresent() ? (PermissionsEntity)this.getEntity(name.get(), "I", true).orElse(null) : null;
        if (permissions == null && uuid.isPresent()) {
            permissions = this.getEntity(uuid.get().toRawString(), "I", true).orElse(null);
        }
        if (permissions != null) {
            this.putEntity(permissionsElement.getId().get(), permissions);
            return;
        }
        PermissionsEntity.Builder permissionsBuilder = PermissionsEntity.newBuilder();
        permissionsBuilder.setUUID(uuid.orElse(null)).setName(name);
        permissions = permissionsBuilder.build();
        Optional<String> extendsAttribute = permissionsElement.getAttributeValue("extends", Optional.empty());
        PermissionsEntity permissionsEntity2 = parent = extendsAttribute.isPresent() ? (PermissionsEntity)this.getEntity(extendsAttribute.get(), "I", true).orElse(null) : null;
        if (parent != null) {
            parent.adopt(permissions);
        }
        for (DocumentElement permissionElement : permissionsElement.getChildren("permissions")) {
            if (!permissionElement.isEnabled()) continue;
            String role = permissionElement.getAttributeValue("role", Optional.of("")).get().trim();
            String allow = permissionElement.getAttributeValue("allow", Optional.of("")).get().trim();
            String deny = permissionElement.getAttributeValue("deny", Optional.of("")).get().trim();
            for (Permissions.Action action : PermissionsLoader._splitActions(allow)) {
                permissions.allow(role, action);
            }
            for (Permissions.Action action : PermissionsLoader._splitActions(deny)) {
                permissions.deny(role, action);
            }
        }
        this.putEntity(permissions);
    }

    private static Collection<Permissions.Action> _splitActions(String values) throws ValidationException {
        String[] fields = ValueConverter.splitFields(values);
        ArrayList<Permissions.Action> actions = new ArrayList<Permissions.Action>(fields.length);
        for (String name : fields) {
            if (name.length() <= 0) continue;
            try {
                actions.add(Enum.valueOf(Permissions.Action.class, name.toUpperCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException exception) {
                throw new ValidationException(ServiceMessages.PERMISSION_ACTION_UNKNOWN, name);
            }
        }
        return actions;
    }
}

