/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.rvpf.base.Entity;
import org.rvpf.base.Point;
import org.rvpf.base.UUID;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.ValueConverter;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.MetadataElementLoader;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.metadata.entity.BehaviorEntity;
import org.rvpf.metadata.entity.ContentEntity;
import org.rvpf.metadata.entity.OriginEntity;
import org.rvpf.metadata.entity.PermissionsEntity;
import org.rvpf.metadata.entity.PointEntity;
import org.rvpf.metadata.entity.PointInput;
import org.rvpf.metadata.entity.StoreEntity;
import org.rvpf.metadata.entity.SyncEntity;
import org.rvpf.metadata.entity.TransformEntity;
import org.rvpf.service.ServiceMessages;

final class PointLoader
extends MetadataElementLoader {
    PointLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        StoreEntity storeEntity;
        OriginEntity originEntity;
        DocumentElement pointElement = this.getElement();
        Optional<UUID> uuid = pointElement.getUUID();
        if (!uuid.isPresent()) {
            throw new ValidationException(ServiceMessages.POINT_NEEDS_UUID, new Object[0]);
        }
        Optional<String> name = pointElement.getAttributeValue("name", Optional.empty());
        PointEntity.Definition point = new PointEntity.Definition();
        this.setUpEntity(point);
        this._forgetReference(uuid.get().toString(), point);
        if (name.isPresent()) {
            this._forgetReference(name.get(), point);
        }
        this._forgetReference(pointElement.getId().orElse(null), point);
        HashSet<String> aliases = new HashSet<String>();
        for (DocumentElement aliasElement : pointElement.getChildren("alias")) {
            if (!aliasElement.isEnabled()) continue;
            String alias = aliasElement.getAttributeValue("name");
            aliases.add(alias);
            this._forgetReference(alias, point);
        }
        MetadataFilter filter = this.getMetadataFilter();
        Optional<String> originKey = pointElement.getAttributeValue("origin", Optional.empty());
        if (!originKey.isPresent() && !(originKey = pointElement.getAttributeValue("processor", Optional.empty())).isPresent() && filter.areOriginsRequired()) {
            originKey = Optional.of("Unspecified");
        }
        if (originKey.isPresent() && (originEntity = (OriginEntity)this.getEntity(originKey.get(), "O", filter.areOriginsFiltered()).orElse(null)) != null) {
            point.setOriginEntity(Optional.of(originEntity));
            Require.success(originEntity.addPointEntity(point));
        }
        Optional<String> referenceAttribute = pointElement.getAttributeValue("store", filter.areStoresRequired() ? Optional.of("Unspecified") : Optional.empty());
        StoreEntity storeEntity2 = storeEntity = referenceAttribute.isPresent() ? (StoreEntity)this.getEntity(referenceAttribute.get(), "S", filter.areStoresFiltered()).orElse(null) : null;
        if (storeEntity != null) {
            point.setStoreEntity(Optional.of(storeEntity));
            Require.success(storeEntity.addPointReference(point));
        }
        if (filter.areContentsNeeded()) {
            ContentEntity contentEntity;
            Optional<String> defaultReference = filter.areContentsRequired() ? Optional.of("Unspecified") : Optional.empty();
            Optional<String> referenceAttribute2 = pointElement.getAttributeValue("content", defaultReference);
            ContentEntity contentEntity2 = contentEntity = referenceAttribute2.isPresent() ? (ContentEntity)this.getEntity(referenceAttribute2.get(), "N") : null;
            if (contentEntity != null) {
                point.setContentEntity(contentEntity);
            }
        }
        if (filter.areSyncsNeeded()) {
            referenceAttribute = pointElement.getAttributeValue("sync", Optional.empty());
            SyncEntity syncEntity = referenceAttribute.isPresent() ? (SyncEntity)this.getEntity(referenceAttribute.get(), "V") : null;
            point.setSyncEntity(Optional.ofNullable(syncEntity));
        }
        if (filter.arePermissionsNeeded()) {
            referenceAttribute = pointElement.getAttributeValue("permissions", Optional.empty());
            PermissionsEntity permissionsEntity = referenceAttribute.isPresent() ? (PermissionsEntity)this.getEntity(referenceAttribute.get(), "I") : null;
            point.setPermissionsEntity(Optional.ofNullable(permissionsEntity));
        }
        point.setParams(this.getParams(pointElement, "Point"));
        point.setAttributes(this.getAttributes(pointElement));
        if (filter.isPointTransformNeeded(point)) {
            TransformEntity transformEntity;
            referenceAttribute = pointElement.getAttributeValue("transform", filter.areTransformsRequired() ? Optional.of("Unspecified") : Optional.empty());
            TransformEntity transformEntity2 = transformEntity = referenceAttribute.isPresent() ? (TransformEntity)this.getEntity(referenceAttribute.get(), "T") : null;
            if (transformEntity != null) {
                if (originKey.isPresent() || !filter.areOriginsNeeded()) {
                    point.setTransformEntity(transformEntity);
                } else {
                    OriginEntity unspecifiedOrigin = (OriginEntity)this.getEntity("Unspecified", "O", false).get();
                    point.setOriginEntity(Optional.of(unspecifiedOrigin));
                }
            }
        }
        if (filter.isPointNeeded(point)) {
            List<DocumentElement> inputElements = pointElement.getChildren("input");
            if (!inputElements.isEmpty()) {
                if (filter.arePointInputsNeeded(point)) {
                    this._addInputs(inputElements, point, aliases, filter);
                } else if (filter.arePointInputsFlagged()) {
                    this._flagInputs(inputElements, point, aliases);
                }
            }
            if (filter.arePointReplicatesNeeded()) {
                for (DocumentElement replicateElement : pointElement.getChildren("replicate")) {
                    if (!replicateElement.isEnabled()) continue;
                    PointEntity replicatePoint = this._getPointEntity(replicateElement, aliases, point);
                    Optional<Boolean> convert = ValueConverter.convertToBoolean(ServiceMessages.ATTRIBUTE_TYPE.toString(), "convert", replicateElement.getAttributeValue("convert", Optional.empty()), Optional.empty());
                    if (replicatePoint == point) {
                        throw new ValidationException(ServiceMessages.SELF_REFERENCE_REPLICATE, point);
                    }
                    point.addReplicate(new Point.Replicate(replicatePoint, convert));
                }
            }
            this.addGroupMember(point);
            this.getMetadata().addPointEntity(Optional.of(point));
            this.anchorEntity(point);
            for (String alias : aliases) {
                this.getMetadata().addPointAlias(point, alias);
            }
        } else {
            point.setDropped(true);
        }
        this.putEntity(point);
    }

    @Override
    String getEntityPrefix() {
        return "P";
    }

    private void _addInputs(List<DocumentElement> inputElements, PointEntity point, Collection<String> aliases, MetadataFilter metadataFilter) throws ValidationException {
        Iterator<TransformEntity.Arg> argsIterator;
        Optional<TransformEntity> transformEntity = point.getTransformEntity();
        Iterator<TransformEntity.Arg> iterator = argsIterator = transformEntity.isPresent() ? transformEntity.get().getArgs().iterator() : null;
        if (!transformEntity.isPresent() && metadataFilter.areTransformsRequired() && metadataFilter.isPointTransformNeeded(point)) {
            throw new ValidationException(ServiceMessages.POINT_NEEDS_TRANSFORM, point);
        }
        for (DocumentElement inputElement : inputElements) {
            SyncEntity syncEntity;
            TransformEntity.Arg arg;
            if (!inputElement.isEnabled()) continue;
            String sync = inputElement.getAttributeValue("sync", Optional.empty()).orElse(null);
            PointEntity inputPoint = this._getPointEntity(inputElement, aliases, point);
            PointInput relation = new PointInput(inputPoint, point);
            relation.setControl(inputElement.getAttributeValue("control", false));
            if (metadataFilter.areBehaviorsNeeded()) {
                String behaviorReference = inputElement.getAttributeValue("behavior", Optional.empty()).orElse(null);
                if (behaviorReference != null) {
                    relation.addBehaviorEntity((BehaviorEntity)this.getEntity(behaviorReference, "H"));
                }
                for (DocumentElement behaviorElement : inputElement.getChildren("behavior")) {
                    if (!behaviorElement.isEnabled()) continue;
                    behaviorReference = behaviorElement.getAttributeValue("behavior", Optional.empty()).orElse(null);
                    if (behaviorReference == null) {
                        throw new ValidationException(ServiceMessages.MISSING_ATTRIBUTE_IN, "behavior", behaviorElement.getName());
                    }
                    relation.addBehaviorEntity((BehaviorEntity)this.getEntity(behaviorReference, "H"));
                }
            }
            TransformEntity.Arg arg2 = arg = argsIterator != null && argsIterator.hasNext() ? argsIterator.next() : null;
            if (metadataFilter.areSyncsNeeded() && (syncEntity = sync != null ? (SyncEntity)this.getEntity(sync, "V") : (arg != null ? (SyncEntity)arg.getSyncEntity().orElse(null) : null)) != null) {
                relation.setSyncEntity(Optional.of(syncEntity));
            }
            relation.setParams(this.getParams(inputElement, "input"));
            point.addInputRelation(relation);
        }
    }

    private void _flagInputs(List<DocumentElement> inputElements, PointEntity point, Collection<String> aliases) throws ValidationException {
        for (DocumentElement inputElement : inputElements) {
            this._getPointEntity(inputElement, aliases, point).flagResultRelations();
        }
    }

    private void _forgetReference(String pointKey, PointEntity pointDefinition) throws ValidationException {
        Optional<? extends Entity> pointReference;
        if (pointKey != null && (pointReference = this.getEntity(pointKey, "P", true)).isPresent()) {
            if (((PointEntity)pointReference.get()).isDefinition()) {
                throw new ValidationException(ServiceMessages.POINT_MULTIPLE, pointReference);
            }
            ((PointEntity)pointReference.get()).setDefinition(pointDefinition);
            this.removeEntity(pointKey, "P");
        }
    }

    private PointEntity _getPointEntity(DocumentElement inputElement, Collection<String> aliases, PointEntity self) throws ValidationException {
        PointEntity point;
        String pointKey = inputElement.getAttributeValue("point");
        if (".".equals(pointKey)) {
            point = self;
        } else {
            point = this.getEntity(pointKey, "P", true).orElse(null);
            if (point == null) {
                point = this.getMetadata().getPointByName(pointKey).orElse(null);
            }
            if (point == null) {
                UUID selfUUID = self.getUUID().get();
                if (pointKey.equalsIgnoreCase(self.getName().orElse(null)) || pointKey.equalsIgnoreCase(selfUUID.toString()) || pointKey.equals(inputElement.getId().orElse(null))) {
                    point = self;
                } else {
                    for (String alias : aliases) {
                        if (!pointKey.equalsIgnoreCase(alias)) continue;
                        point = self;
                        break;
                    }
                }
            }
            if (point == null) {
                point = new PointEntity.Reference();
                point.setName(Optional.of(pointKey));
                this.putEntity(pointKey, point);
            }
        }
        return point;
    }
}

