/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Optional;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.config.entity.PropertiesDefEntity;
import org.rvpf.config.entity.PropertyDefEntity;
import org.rvpf.config.entity.ValidatorDefEntity;
import org.rvpf.document.loader.ConfigElementLoader;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.PropertyDefLoader;
import org.rvpf.service.ServiceMessages;

final class PropertiesDefLoader
extends ConfigElementLoader {
    PropertiesDefLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        DocumentElement propertiesDefElement;
        Optional<String> nameAttribute = (propertiesDefElement = this.getElement()).getNameAttribute();
        PropertiesDefEntity oldPropertiesDefEntity = nameAttribute.isPresent() ? (PropertiesDefEntity)this.getEntity(nameAttribute.get(), "R", true).orElse(null) : null;
        PropertiesDefEntity newPropertiesDefEntity = this._preparePropertiesDef(propertiesDefElement, oldPropertiesDefEntity);
        if (newPropertiesDefEntity != oldPropertiesDefEntity) {
            newPropertiesDefEntity.setUUID(propertiesDefElement.getUUID());
            this.putEntity(newPropertiesDefEntity);
        }
    }

    private PropertiesDefEntity _preparePropertiesDef(DocumentElement propertiesDefElement, PropertiesDefEntity propertiesDefEntity) throws ValidationException {
        Optional<String> extendsAttribute;
        ValidatorDefEntity extended;
        if (propertiesDefEntity == null) {
            propertiesDefEntity = new PropertiesDefEntity();
        }
        ValidatorDefEntity validatorDefEntity = extended = (extendsAttribute = propertiesDefElement.getAttributeValue("extends", Optional.empty())).isPresent() ? (PropertiesDefEntity)this.getEntity(extendsAttribute.get(), "R", true).orElse(null) : null;
        if (extended != null) {
            propertiesDefEntity.setHidden(extended.isHidden());
            propertiesDefEntity.setMultiple(extended.isMultiple());
            propertiesDefEntity.setValidated(((PropertiesDefEntity)extended).isValidated());
            for (PropertyDefEntity extendedPropertyDef : ((PropertiesDefEntity)extended).getPropertyDefs()) {
                propertiesDefEntity.addPropertyDef(extendedPropertyDef);
            }
            for (PropertiesDefEntity extendedPropertiesDef : ((PropertiesDefEntity)extended).getPropertiesDefs()) {
                propertiesDefEntity.addPropertiesDef(extendedPropertiesDef);
            }
        }
        propertiesDefEntity.setName(propertiesDefElement.getNameAttribute());
        propertiesDefEntity.setHidden(propertiesDefElement.getAttributeValue("hidden", propertiesDefEntity.isHidden()));
        propertiesDefEntity.setMultiple(propertiesDefElement.getAttributeValue("multiple", propertiesDefEntity.isMultiple()));
        propertiesDefEntity.setValidated(propertiesDefElement.getAttributeValue("validated", propertiesDefEntity.isValidated()));
        for (DocumentElement child : propertiesDefElement.getChildren()) {
            String childNameAttribute;
            PropertiesDefEntity oldPropertiesDef;
            PropertiesDefEntity newPropertiesDef;
            if (!child.isEnabled() || child.getAttributeValue("lang", Optional.empty()).isPresent()) continue;
            if ("PropertyDef".equals(child.getName())) {
                if (propertiesDefEntity.addPropertyDef(PropertyDefLoader.preparePropertyDef(child))) continue;
                throw new ValidationException(ServiceMessages.PROPERTY_DEF_MULTIPLE, child.getNameAttribute());
            }
            if (!"PropertiesDef".equals(child.getName()) || (newPropertiesDef = this._preparePropertiesDef(child, oldPropertiesDef = (childNameAttribute = (String)child.getNameAttribute().orElse(null)) != null ? (PropertiesDefEntity)propertiesDefEntity.getPropertiesDef(childNameAttribute).orElse(null) : null)) == oldPropertiesDef) continue;
            propertiesDefEntity.addPropertiesDef(newPropertiesDef);
        }
        return propertiesDefEntity;
    }
}

