/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.base.logger.Message;
import org.rvpf.base.security.Crypt;
import org.rvpf.base.security.SecurityContext;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.xml.XMLDocument;
import org.rvpf.config.ConfigProperties;
import org.rvpf.config.entity.PropertiesDefEntity;
import org.rvpf.document.loader.ConfigDocumentLoader;
import org.rvpf.document.loader.ConfigElementLoader;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.DocumentPropertiesMap;
import org.rvpf.document.loader.DocumentStream;
import org.rvpf.document.loader.DocumentSystemProperties;
import org.rvpf.document.loader.PropertyLoader;
import org.rvpf.service.ServiceMessages;

final class PropertiesLoader
extends ConfigElementLoader {
    private static final String[] _EMPTY_KEY_IDENTS = new String[0];

    PropertiesLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        PropertiesDefEntity propertiesDef;
        DocumentElement propertiesElement = this.getElement();
        boolean system = propertiesElement.getAttributeValue("system", false);
        Optional<String> name = propertiesElement.getNameAttribute();
        if (system && name.isPresent()) {
            throw new ValidationException(ServiceMessages.CONFLICTING_ATTRIBUTES, "system", "name");
        }
        boolean validate = ((ConfigDocumentLoader)this.getDocumentLoader()).isValidationEnabled() && propertiesElement.getAttributeValue("validated", true);
        String def = propertiesElement.getAttributeValue("def", Optional.empty()).orElse(null);
        if (validate && name.isPresent()) {
            propertiesDef = this.getEntity(def != null ? def : name.get(), "R", true).orElse(null);
            if (propertiesDef == null) {
                this.getLogger().warn(ServiceMessages.PROPERTIES_DEF_MISSING, name.get());
            }
        } else {
            propertiesDef = null;
        }
        ConfigProperties group = new ConfigProperties(name);
        ConfigProperties configProperties = this.getConfig().getProperties();
        PropertiesLoader.prepareGroup(group, this, propertiesElement, configProperties, Optional.ofNullable(propertiesDef), validate && !system);
        String from = propertiesElement.getAttributeValue("from", Optional.empty()).orElse(null);
        if (from != null) {
            this._fetchFromFile(propertiesElement, from, group);
        }
        if (system) {
            this._setSystemProperties(group);
        } else {
            PropertiesLoader._addGroupProperties(configProperties, name.orElse(null), group);
            if (name.isPresent() && propertiesDef != null && configProperties.getGroups(name.get()).length > 1 && !propertiesDef.isMultiple()) {
                this.getLogger().warn(ServiceMessages.PROPERTIES_MULTIPLE, name.get());
            }
        }
    }

    static void prepareGroup(@Nonnull ConfigProperties group, @Nonnull ConfigElementLoader loader, @Nonnull DocumentElement propertiesElement, @Nonnull ConfigProperties context, @Nonnull Optional<PropertiesDefEntity> groupDef, boolean validate) throws ValidationException {
        String extended;
        boolean hidden = groupDef.isPresent() ? groupDef.get().isHidden() : false;
        group.setHidden(hidden || propertiesElement.getAttributeValue("hidden", false));
        validate &= !groupDef.isPresent() || groupDef.get().isValidated();
        boolean overrides = propertiesElement.getAttributeValue("overrides", false);
        if (overrides) {
            if (!group.getName().isPresent()) {
                throw new ValidationException(ServiceMessages.MISSING_ATTRIBUTE_IN, "name", propertiesElement.getName());
            }
            context.removeGroup(group.getName().get());
        }
        if ((extended = (String)propertiesElement.getAttributeValue("extends", Optional.empty()).orElse(null)) != null) {
            if (!group.getName().isPresent()) {
                throw new ValidationException(ServiceMessages.MISSING_ATTRIBUTE_IN, "name", propertiesElement.getName());
            }
            ConfigProperties extendedProperties = context.getGroup(extended);
            if (extendedProperties.isMissing()) {
                throw new ValidationException(ServiceMessages.PROPERTIES_NOT_FOUND, extended);
            }
            PropertiesLoader._addExtendedProperties(extendedProperties, group);
        }
        group.setOverriden(context);
        for (DocumentElement childElement : propertiesElement.getChildren()) {
            if (!childElement.isEnabled()) continue;
            if ("property".equals(childElement.getName())) {
                PropertyLoader.addPropertyValues(loader, childElement, group, groupDef, validate);
                continue;
            }
            if (!"properties".equals(childElement.getName())) continue;
            PropertiesLoader._addChildGroup(group, loader, childElement, groupDef.orElse(null), validate);
        }
        group.clearOverriden();
    }

    private static void _addChildGroup(ConfigProperties group, ConfigElementLoader loader, DocumentElement childElement, PropertiesDefEntity groupDef, boolean validate) throws ValidationException {
        PropertiesDefEntity propertiesDef;
        Optional<String> name = childElement.getNameAttribute();
        if (!name.isPresent()) {
            propertiesDef = groupDef;
        } else if (validate &= childElement.getAttributeValue("validated", true)) {
            String def = childElement.getAttributeValue("def", name).orElse(null);
            propertiesDef = groupDef == null ? (PropertiesDefEntity)loader.getDocumentLoader().getEntity(def, "R").orElse(null) : (PropertiesDefEntity)groupDef.getPropertiesDef(def).orElse(null);
            if (propertiesDef == null) {
                if (groupDef != null) {
                    childElement.getDocumentLogger().warn(ServiceMessages.PROPERTIES_DEF_MISSING_IN, name.get(), groupDef.getName().orElse(null));
                } else {
                    childElement.getDocumentLogger().warn(ServiceMessages.PROPERTIES_DEF_MISSING, name.get());
                }
            }
        } else {
            propertiesDef = null;
        }
        ConfigProperties childGroup = new ConfigProperties(name);
        PropertiesLoader.prepareGroup(childGroup, loader, childElement, group, Optional.ofNullable(propertiesDef), validate && childElement.getAttributeValue("validated", true));
        PropertiesLoader._addGroupProperties(group, name.orElse(null), childGroup);
        if (propertiesDef != null && name.isPresent() && group.getGroups(name.get()).length > 1 && !propertiesDef.isMultiple()) {
            if (groupDef != null) {
                childElement.getDocumentLogger().warn(ServiceMessages.PROPERTIES_MULTIPLE_IN, name.get(), groupDef.getName().get());
            } else {
                childElement.getDocumentLogger().warn(ServiceMessages.PROPERTIES_MULTIPLE, name.get());
            }
        }
    }

    private static void _addExtendedProperties(KeyedGroups extendedProperties, KeyedGroups properties) {
        for (Map.Entry<String, List<Object>> entry : extendedProperties.getValuesEntries()) {
            for (Object value : entry.getValue()) {
                properties.add(entry.getKey(), value);
            }
        }
        for (Map.Entry<String, List<Object>> entry : extendedProperties.getGroupsEntries()) {
            String name = entry.getKey();
            List<Object> groups = entry.getValue();
            for (Object object : groups) {
                ConfigProperties childProperties = (ConfigProperties)object;
                ConfigProperties groupProperties = new ConfigProperties(childProperties.getName());
                PropertiesLoader._addGroupProperties(properties, name, groupProperties);
                PropertiesLoader._addExtendedProperties(childProperties, groupProperties);
            }
        }
    }

    private static void _addGroupProperties(KeyedGroups group, String key, KeyedGroups properties) {
        if (key != null) {
            group.addGroup(key, properties);
        } else {
            group.addAll(properties);
        }
    }

    private static String[] getKeyIdents(DocumentElement propertiesElement, String elementName) {
        List<DocumentElement> children = propertiesElement.getChildren(elementName);
        String[] keyIdents = new String[children.size()];
        int childIndex = 0;
        for (DocumentElement child : children) {
            keyIdents[childIndex++] = child.getText();
        }
        return keyIdents;
    }

    private void _fetchFromFile(DocumentElement propertiesElement, String from, ConfigProperties group) throws ValidationException {
        try {
            StringReader reader;
            URL fromURL = new URL(this.getContextURL(), from);
            boolean verify = propertiesElement.getAttributeValue("verify", false);
            String[] verifyKeyIdents = verify ? PropertiesLoader.getKeyIdents(propertiesElement, "verifyKey") : _EMPTY_KEY_IDENTS;
            boolean decrypt = propertiesElement.getAttributeValue("decrypt", false);
            String[] decryptKeyIdents = decrypt ? PropertiesLoader.getKeyIdents(propertiesElement, "decryptKey") : _EMPTY_KEY_IDENTS;
            String security = propertiesElement.getAttributeValue("security", Optional.empty()).orElse(null);
            DocumentStream documentStream = DocumentStream.create(fromURL);
            if (verify || decrypt) {
                KeyedGroups securityProperties;
                XMLDocument xmlDocument = new XMLDocument();
                try {
                    xmlDocument.parse(documentStream, documentStream.getEncoding());
                }
                catch (XMLDocument.ParseException exception) {
                    throw new RuntimeException(exception.getCause());
                }
                try {
                    documentStream.close();
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
                SecurityContext securityContext = new SecurityContext(this.getLogger());
                ConfigProperties configProperties = this.getConfig().getProperties();
                KeyedGroups keyedGroups = securityProperties = security != null ? ((KeyedGroups)configProperties).getGroup(security) : KeyedGroups.MISSING_KEYED_GROUP;
                if (!securityContext.setUp(configProperties, securityProperties)) {
                    throw new ValidationException(ServiceMessages.PROPERTIES_GET_FAILED, new Object[0]);
                }
                Crypt crypt = new Crypt();
                if (!crypt.setUp(securityContext.getCryptProperties(), Optional.empty())) {
                    throw new ValidationException(ServiceMessages.PROPERTIES_GET_FAILED, new Object[0]);
                }
                Serializable serializable = crypt.load(xmlDocument, from, verify, verifyKeyIdents, decrypt, decryptKeyIdents);
                if (serializable == null) {
                    throw new ValidationException(ServiceMessages.PROPERTIES_GET_FAILED, new Object[0]);
                }
                reader = new StringReader(String.valueOf(serializable));
            } else {
                reader = null;
            }
            DocumentPropertiesMap properties = DocumentPropertiesMap.fetch(documentStream, Optional.ofNullable(reader));
            properties.forEach((key, value) -> {
                String substitute = this.getDocumentLoader().substitute((String)value);
                if (group.getObject((String)key).isPresent()) {
                    this.getLogger().debug(ServiceMessages.PREVIOUS_VALUE_OVERRIDDEN, key, substitute);
                }
                group.setValue((String)key, substitute);
            });
            this.getDocumentLoader().updateStamp(properties.getStamp());
            this.getLogger().debug(ServiceMessages.GOT_PROPERTIES_FROM, documentStream.getFromURL());
        }
        catch (IOException exception) {
            boolean optional = propertiesElement.getAttributeValue("optional", false);
            Message message = new Message(ServiceMessages.PROPERTIES_GET_FAILED_, from, exception.getMessage());
            if (optional) {
                this.getLogger().debug(message);
            }
            this.getLogger().error(message);
        }
    }

    private void _setSystemProperties(ConfigProperties group) {
        DocumentSystemProperties properties = DocumentSystemProperties.getInstance();
        for (Map.Entry<String, List<Object>> entry : group.getValuesEntries()) {
            String key = entry.getKey();
            for (Object value : entry.getValue()) {
                if (properties.containsValueKey(key)) {
                    this.getLogger().warn(ServiceMessages.PROPERTY_MULTIPLE, key);
                }
                properties.add(key, value);
            }
        }
    }
}

