/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.config.entity.PropertyDefEntity;
import org.rvpf.document.loader.ConfigElementLoader;
import org.rvpf.document.loader.DocumentElement;

final class PropertyDefLoader
extends ConfigElementLoader {
    PropertyDefLoader() {
    }

    @Override
    protected void process() {
        DocumentElement propertyDefElement = this.getElement();
        PropertyDefEntity propertyDef = PropertyDefLoader.preparePropertyDef(propertyDefElement);
        propertyDef.setUUID(propertyDefElement.getUUID());
        this.putEntity(propertyDef);
    }

    @Nonnull
    @CheckReturnValue
    static PropertyDefEntity preparePropertyDef(@Nonnull DocumentElement element) {
        PropertyDefEntity.Builder propertyDefBuilder = PropertyDefEntity.newBuilder();
        propertyDefBuilder.setName(element.getNameAttribute().get());
        propertyDefBuilder.setHidden(element.getAttributeValue("hidden", false)).setMultiple(element.getAttributeValue("multiple", false));
        return propertyDefBuilder.build();
    }
}

