/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.config.ConfigProperties;
import org.rvpf.config.entity.PropertiesDefEntity;
import org.rvpf.config.entity.PropertyDefEntity;
import org.rvpf.document.loader.ConfigDocumentLoader;
import org.rvpf.document.loader.ConfigElementLoader;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.DocumentSystemProperties;
import org.rvpf.service.ServiceMessages;

final class PropertyLoader
extends ConfigElementLoader {
    PropertyLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        DocumentElement propertyElement = this.getElement();
        if (propertyElement.getAttributeValue("system", false)) {
            Optional<String> name = propertyElement.getNameAttribute();
            if (!name.isPresent()) {
                throw new ValidationException(ServiceMessages.PROPERTY_NAME_MISSING, new Object[0]);
            }
            this.putValues(name.get(), propertyElement, this.getConfig().getProperties(), Optional.empty(), DocumentSystemProperties.getInstance());
        } else {
            PropertyLoader.addPropertyValues(this, propertyElement, this.getConfig().getProperties(), Optional.empty(), ((ConfigDocumentLoader)this.getDocumentLoader()).isValidationEnabled());
        }
    }

    static void addPropertyValues(@Nonnull ConfigElementLoader loader, @Nonnull DocumentElement element, @Nonnull ConfigProperties context, @Nonnull Optional<PropertiesDefEntity> propertiesDef, boolean validate) throws ValidationException {
        String name = element.getNameAttribute().orElse(null);
        if (name == null) {
            throw new ValidationException(ServiceMessages.PROPERTY_NAME_MISSING, new Object[0]);
        }
        loader.putValues(name, element, context, Optional.empty(), context);
        if (validate && element.getAttributeValue("validated", true)) {
            PropertyDefEntity propertyDef;
            String def = element.getAttributeValue("def", Optional.empty()).orElse(null);
            if (def == null) {
                def = name;
            }
            if ((propertyDef = propertiesDef.isPresent() ? (PropertyDefEntity)propertiesDef.get().getPropertyDef(def).orElse(null) : (PropertyDefEntity)loader.getDocumentLoader().getEntity(def, "Y").orElse(null)) == null) {
                if (propertiesDef.isPresent()) {
                    loader.getLogger().warn(ServiceMessages.PROPERTY_DEF_MISSING_IN, name, propertiesDef.get().getName().orElse(null));
                } else {
                    loader.getLogger().warn(ServiceMessages.PROPERTY_DEF_MISSING, name);
                }
            } else if (context.isMultiple(name) && !propertyDef.isMultiple()) {
                if (propertiesDef.isPresent()) {
                    loader.getLogger().warn(ServiceMessages.PROPERTY_MULTIPLE_IN, name, propertiesDef.get().getName().orElse(null));
                } else {
                    loader.getLogger().warn(ServiceMessages.PROPERTY_MULTIPLE, name);
                }
            }
        }
    }
}

