/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Optional;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.document.loader.ConfigDocumentLoader;
import org.rvpf.document.loader.ConfigElementLoader;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.PropertiesLoader;
import org.rvpf.service.ServiceContext;
import org.rvpf.service.ServiceMessages;

final class ServiceLoader
extends ConfigElementLoader {
    ServiceLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        DocumentElement serviceElement = this.getElement();
        if (this.getDocumentLoader().getClass() != ConfigDocumentLoader.class) {
            throw new ValidationException(ServiceMessages.CONFIG_ELEMENT, serviceElement.getName());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setServiceName(serviceElement.getAttributeValue("name"));
        for (DocumentElement aliasElement : serviceElement.getChildren("alias")) {
            if (!aliasElement.isEnabled()) continue;
            serviceContext.addServiceAlias(aliasElement.getAttributeValue("name"));
        }
        if (serviceContext.getServiceName().equals(this.getConfig().getServiceName())) {
            PropertiesLoader.prepareGroup(serviceContext, this, serviceElement, this.getConfig().getProperties(), Optional.empty(), ((ConfigDocumentLoader)this.getDocumentLoader()).isValidationEnabled());
            for (DocumentElement classLibElement : serviceElement.getChildren("classLib")) {
                if (!classLibElement.isEnabled()) continue;
                serviceContext.addClassLib(this.getClassLibEntity(classLibElement.getAttributeValue("classLib")));
            }
        }
        this.getConfig().addServiceContext(serviceContext);
    }
}

