/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Optional;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.MetadataElementLoader;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.metadata.entity.PermissionsEntity;
import org.rvpf.metadata.entity.StoreEntity;

final class StoreLoader
extends MetadataElementLoader {
    StoreLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        MetadataFilter filter = this.getMetadataFilter();
        if (!filter.areStoresNeeded()) {
            return;
        }
        StoreEntity.Builder storeEntityBuilder = StoreEntity.newBuilder();
        this.setUpEntityBuilder(storeEntityBuilder);
        DocumentElement storeElement = this.getElement();
        Optional<String> referenceAttribute = storeElement.getAttributeValue("classDef", Optional.empty());
        storeEntityBuilder.setClassDef(referenceAttribute.isPresent() ? Optional.of(this.getClassDefEntity(referenceAttribute.get())) : Optional.empty());
        if (filter.arePermissionsNeeded()) {
            referenceAttribute = storeElement.getAttributeValue("permissions", Optional.empty());
            PermissionsEntity permissionsEntity = referenceAttribute.isPresent() ? (PermissionsEntity)this.getEntity(referenceAttribute.get(), "I") : null;
            storeEntityBuilder.setPermissions(Optional.ofNullable(permissionsEntity));
        }
        storeEntityBuilder.setParams(this.getParams(storeElement, "Store")).setAttributes(this.getAttributes(storeElement));
        StoreEntity store = storeEntityBuilder.build();
        if (filter.isStoreNeeded(store)) {
            this.addGroupMember(store);
            this.getMetadata().addStoreEntity(Optional.of(store));
            this.anchorEntity(store);
            this.putEntity(store);
        }
    }

    @Override
    String getEntityPrefix() {
        return "S";
    }
}

