/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Optional;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.config.entity.ClassDefEntity;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.MetadataElementLoader;
import org.rvpf.metadata.entity.SyncEntity;

final class SyncLoader
extends MetadataElementLoader {
    SyncLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        if (!this.getMetadataFilter().areSyncsNeeded()) {
            return;
        }
        SyncEntity.Builder syncEntityBuilder = SyncEntity.newBuilder();
        this.setUpEntityBuilder(syncEntityBuilder);
        DocumentElement syncElement = this.getElement();
        ClassDefEntity classDef = this.getClassDefEntity(syncElement.getAttributeValue("classDef"));
        syncEntityBuilder.setClassDef(classDef).setParams(this.getParams(syncElement, "Sync")).setAttributes(this.getAttributes(syncElement));
        SyncEntity syncEntity = syncEntityBuilder.build();
        this.getMetadata().addSyncEntity(Optional.of(syncEntity));
        this.anchorEntity(syncEntity);
        this.putEntity(syncEntity);
    }

    @Override
    String getEntityPrefix() {
        return "V";
    }
}

