/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Optional;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.MetadataElementLoader;
import org.rvpf.metadata.entity.BehaviorEntity;
import org.rvpf.metadata.entity.ContentEntity;
import org.rvpf.metadata.entity.EngineEntity;
import org.rvpf.metadata.entity.SyncEntity;
import org.rvpf.metadata.entity.TransformEntity;

final class TransformLoader
extends MetadataElementLoader {
    TransformLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        if (!this.getMetadataFilter().areTransformsNeeded()) {
            return;
        }
        TransformEntity.Builder transformBuilder = TransformEntity.newBuilder();
        DocumentElement transformElement = this.getElement();
        this.setUpEntityBuilder(transformBuilder);
        EngineEntity engineEntity = this.getEntity(transformElement.getAttributeValue("engine"), "G", this.getMetadataFilter().areEnginesFiltered()).orElse(null);
        transformBuilder.setEngineEntity(Optional.ofNullable(engineEntity)).setParams(this.getParams(transformElement, "Transform")).setAttributes(this.getAttributes(transformElement));
        for (DocumentElement argElement : transformElement.getChildren("arg")) {
            if (!argElement.isEnabled()) continue;
            TransformEntity.Arg.Builder argBuilder = TransformEntity.Arg.newBuilder();
            String behavior = argElement.getAttributeValue("behavior", Optional.empty()).orElse(null);
            String content = argElement.getAttributeValue("content", Optional.empty()).orElse(null);
            String sync = argElement.getAttributeValue("sync", Optional.empty()).orElse(null);
            if (this.getMetadataFilter().areBehaviorsNeeded()) {
                if (behavior != null) {
                    argBuilder.addBehaviorEntity((BehaviorEntity)this.getEntity(behavior, "H"));
                }
                for (DocumentElement behaviorElement : argElement.getChildren("behavior")) {
                    argBuilder.addBehaviorEntity((BehaviorEntity)this.getEntity(behaviorElement.getAttributeValue("behavior"), "H"));
                }
            }
            if (this.getMetadataFilter().areContentsNeeded() && content != null) {
                argBuilder.setContentEntity((ContentEntity)this.getEntity(content, "N"));
            }
            if (sync != null) {
                argBuilder.setSyncEntity((SyncEntity)this.getEntity(sync, "V"));
            }
            argBuilder.setMultiple(argElement.getAttributeValue("multiple", false)).setParams(this.getParams(argElement, "arg"));
            transformBuilder.addArg(argBuilder.build());
        }
        TransformEntity transform = transformBuilder.build();
        this.addGroupMember(transform);
        this.getMetadata().addTransformEntity(Optional.of(transform));
        this.putEntity(transform);
    }

    @Override
    String getEntityPrefix() {
        return "T";
    }
}

