/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.version;

import java.io.File;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ClassDef;
import org.rvpf.base.alert.Event;
import org.rvpf.base.alert.Signal;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.document.version.VersionControl;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;
import org.rvpf.service.app.ServiceAppImpl;

public final class DocumentVersionControlAppImpl
extends ServiceAppImpl
implements ServiceThread.Target {
    private final Object _mutex = new Object();
    private String _previousRevision;
    private Event _restoreEvent;
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();
    private Signal _updateSignal;
    private VersionControl _versionControl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onEvent(Event event) {
        if ("BadDocument".equalsIgnoreCase(event.getName())) {
            Object object = this._mutex;
            synchronized (object) {
                this._restoreEvent = event;
                this._mutex.notifyAll();
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onSignal(Signal signal) {
        if ("UpdateDocument".equalsIgnoreCase(signal.getName())) {
            Object object = this._mutex;
            synchronized (object) {
                this._updateSignal = signal;
                this._mutex.notifyAll();
            }
            return false;
        }
        return true;
    }

    @Override
    public void run() throws InterruptedException {
        Object object = this._mutex;
        synchronized (object) {
            while (true) {
                if (this._updateSignal == null && this._restoreEvent == null) {
                    this._mutex.wait();
                    continue;
                }
                if (this._updateSignal != null) {
                    this._update();
                    this._updateSignal = null;
                    this._restoreEvent = null;
                    continue;
                }
                if (this._restoreEvent == null) continue;
                this._restore();
                this._restoreEvent = null;
            }
        }
    }

    @Override
    public boolean setUp(Service service) {
        if (!super.setUp(service)) {
            return false;
        }
        Config config = service.getConfig();
        KeyedGroups properties = config.getPropertiesGroup("document.version");
        if (properties.isMissing()) {
            this.getThisLogger().error(ServiceMessages.MISSING_PROPERTIES, "document.version");
            return false;
        }
        Optional<String> workspace = properties.getString("workspace");
        if (!workspace.isPresent()) {
            this.getThisLogger().error(BaseMessages.MISSING_PROPERTY_IN, "workspace", "document.version");
            return false;
        }
        File directory = config.getFile(workspace.get());
        if (!directory.isDirectory()) {
            this.getThisLogger().error(ServiceMessages.WORKSPACE_LOCATION_NOT_DIR, directory);
            return false;
        }
        ClassDef classDef = properties.getClassDef("control.class", VersionControl.DEFAULT_VERSION_CONTROL_CLASS);
        this._versionControl = classDef.createInstance(VersionControl.class);
        if (this._versionControl == null) {
            return false;
        }
        Optional<String> user = properties.getString("repository.user");
        Optional<char[]> password = properties.getPassword("repository.password");
        if (user.isPresent()) {
            this._versionControl.setUser(user.get());
            this._versionControl.setPassword(password);
        }
        if (!this._versionControl.selectWorkspace(directory)) {
            return false;
        }
        this.getThisLogger().info(ServiceMessages.WORKSPACE_LOCATION, directory.getAbsolutePath());
        this.getThisLogger().info(ServiceMessages.WORKSPACE_REVISION, this._versionControl.getWorkspaceRevision());
        Optional<String> updateTrigger = properties.getString("update.trigger");
        if (updateTrigger.isPresent()) {
            File triggerFile = config.getFile(updateTrigger.get());
            this.getThisLogger().info(ServiceMessages.TRIGGER_FILE, triggerFile.getAbsolutePath());
            if (triggerFile.exists()) {
                this.getThisLogger().info(ServiceMessages.WORKSPACE_UPDATE, new Object[0]);
                this._update();
                if (!triggerFile.delete()) {
                    this.getThisLogger().info(ServiceMessages.TRIGGER_DELETE_FAILED, new Object[0]);
                }
            }
        }
        return true;
    }

    @Override
    public void start() {
        ServiceThread thread = new ServiceThread(this, "Document version control");
        if (this._thread.compareAndSet(null, thread)) {
            this.getThisLogger().debug(ServiceMessages.STARTING_THREAD, thread.getName());
            thread.start();
        }
    }

    @Override
    public void stop() {
        ServiceThread thread = this._thread.getAndSet(null);
        if (thread != null) {
            this.getThisLogger().debug(ServiceMessages.STOPPING_THREAD, thread.getName());
            Require.ignored(thread.interruptAndJoin(this.getThisLogger(), this.getJoinTimeout()));
        }
    }

    @Override
    public void tearDown() {
        if (this._versionControl != null) {
            this._versionControl.dispose();
            this._versionControl = null;
        }
        super.tearDown();
    }

    private void _restore() {
        String rejectedRevision = this._restoreEvent.getInfo().orElse(null);
        String currentRevision = this._versionControl.getWorkspaceRevision();
        if (this._previousRevision != null && !this._previousRevision.equals(currentRevision) && currentRevision.equals(rejectedRevision)) {
            if (this._versionControl.update(Optional.of(this._previousRevision))) {
                String restoredRevision = this._versionControl.getWorkspaceRevision();
                this.getThisLogger().info(ServiceMessages.WORKSPACE_RESTORED, restoredRevision);
                this.getService().sendEvent("DocumentRestored", Optional.of(restoredRevision));
            }
            this._previousRevision = null;
        }
    }

    private void _update() {
        Optional<String> requestedRevision = this._updateSignal.getInfo();
        this._previousRevision = this._versionControl.getWorkspaceRevision();
        if (this._versionControl.update(requestedRevision)) {
            String info;
            String updatedRevision = this._versionControl.getWorkspaceRevision();
            if (updatedRevision.equals(this._previousRevision)) {
                this.getThisLogger().info(ServiceMessages.WORKSPACE_UPDATED, updatedRevision);
                info = updatedRevision;
                this._previousRevision = null;
            } else {
                this.getThisLogger().info(ServiceMessages.WORKSPACE_UPDATED_TO, this._previousRevision, updatedRevision);
                info = updatedRevision + " " + this._previousRevision;
            }
            if (this._updateSignal != null) {
                this.getService().sendEvent("DocumentUpdated", Optional.of(info));
            }
        }
    }
}

