/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.jmx;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.util.LoginInfo;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.jmx.AgentSessionFactoryImpl;
import org.rvpf.service.ServiceActivator;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.StatsHolder;
import org.rvpf.service.rmi.ServiceRegistry;
import org.rvpf.service.rmi.SessionFactoryImpl;
import org.rvpf.service.rmi.SessionSecurityContext;

public final class Agent {
    public static final String JMX_PROPERTIES = "jmx";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String PLATFORM_PROPERTY = "platform";
    public static final String REGISTRATION_ENABLED_PROPERTY = "registration.enabled";
    public static final String REGISTRY_PREFIX = "service/";
    public static final String ROLE_CONNECT_PROPERTY = "role.connect";
    public static final String USER_PROPERTY = "user";
    private static final Agent _INSTANCE = new Agent();
    private static final Logger _LOGGER = Logger.getInstance(Agent.class);
    private volatile AgentSessionFactoryImpl _sessionFactory;

    private Agent() {
    }

    @Nonnull
    @CheckReturnValue
    public static Agent getInstance() {
        return _INSTANCE;
    }

    @Nonnull
    @CheckReturnValue
    public static LoginInfo getLoginInfo(@Nonnull Config config) {
        KeyedGroups jmxProperties = config.getPropertiesGroup(JMX_PROPERTIES);
        if (jmxProperties.isMissing()) {
            return new LoginInfo(Optional.empty(), Optional.empty());
        }
        return new LoginInfo(jmxProperties.getString(USER_PROPERTY), jmxProperties.getPassword(PASSWORD_PROPERTY));
    }

    @CheckReturnValue
    public static boolean isRegistrationEnabled(@Nonnull Config config) {
        KeyedGroups jmxProperties = config.getPropertiesGroup(JMX_PROPERTIES);
        return jmxProperties != null && jmxProperties.getBoolean(REGISTRATION_ENABLED_PROPERTY);
    }

    @CheckReturnValue
    public synchronized boolean exportService(@Nonnull ServiceActivator serviceActivator) {
        String name = serviceActivator.getObjectName().toString();
        if (!ServiceRegistry.getInstance().register(this._sessionFactory, REGISTRY_PREFIX + name, _LOGGER)) {
            return false;
        }
        _LOGGER.info(ServiceMessages.JMX_AGENT_EXPORTED, name);
        return true;
    }

    @CheckReturnValue
    public synchronized boolean registerService(@Nonnull ServiceActivator serviceActivator) {
        return this.setUp(serviceActivator.getConfig().get()) && this.registerStatsHolder(serviceActivator);
    }

    @CheckReturnValue
    public synchronized boolean registerStatsHolder(@Nonnull StatsHolder statsHolder) {
        try {
            this._sessionFactory.getServer().registerMBean(statsHolder, statsHolder.getObjectName());
        }
        catch (InstanceAlreadyExistsException exception) {
            _LOGGER.warn(ServiceMessages.OBJECT_NAME_COLLISION, statsHolder.getObjectName());
            return false;
        }
        catch (JMException exception) {
            throw new RuntimeException(exception);
        }
        _LOGGER.info(ServiceMessages.JMX_OBJECT_REGISTERED, statsHolder.getObjectName());
        return true;
    }

    @CheckReturnValue
    public boolean setUp(@Nonnull Config config) {
        if (this._sessionFactory == null) {
            KeyedGroups jmxProperties = config.getPropertiesGroup(JMX_PROPERTIES);
            SessionSecurityContext securityContext = SessionFactoryImpl.createSecurityContext(config.getProperties(), jmxProperties.getGroup("security"), _LOGGER);
            if (securityContext == null) {
                return false;
            }
            AgentSessionFactoryImpl sessionFactory = new AgentSessionFactoryImpl(securityContext);
            if (!sessionFactory.setUp(config, jmxProperties.getBoolean(PLATFORM_PROPERTY))) {
                return false;
            }
            this._sessionFactory = sessionFactory;
            _LOGGER.debug(ServiceMessages.AGENT_FACTORY_OPENED, config.getServiceName());
        }
        return true;
    }

    public void tearDown(@Nonnull Config config) {
        AgentSessionFactoryImpl sessionFactory = this._sessionFactory;
        if (sessionFactory != null && config == sessionFactory.getConfig()) {
            this._sessionFactory = null;
            sessionFactory.tearDown();
            _LOGGER.debug(ServiceMessages.AGENT_FACTORY_CLOSED, new Object[0]);
        }
    }

    public synchronized void unexportService(@Nonnull ServiceActivator serviceActivator) {
        AgentSessionFactoryImpl sessionFactory = this._sessionFactory;
        if (sessionFactory == null) {
            _LOGGER.warn(ServiceMessages.UNEXPORT_OUT_OF_ORDER, serviceActivator.getObjectName());
            return;
        }
        ServiceRegistry.getInstance().unregister(REGISTRY_PREFIX + serviceActivator.getObjectName(), _LOGGER);
    }

    public synchronized void unregisterService(@Nonnull ServiceActivator serviceActivator) {
        this.unregisterStatsHolder(serviceActivator);
        this.tearDown(serviceActivator.getConfig().get());
    }

    public synchronized void unregisterStatsHolder(@Nonnull StatsHolder statsHolder) {
        AgentSessionFactoryImpl sessionFactory = this._sessionFactory;
        if (sessionFactory == null) {
            _LOGGER.warn(ServiceMessages.UNREGISTRATION_OUT_OF_ORDER, statsHolder.getObjectName());
            return;
        }
        try {
            sessionFactory.getServer().unregisterMBean(statsHolder.getObjectName());
        }
        catch (JMException exception) {
            _LOGGER.warn(ServiceMessages.UNREGISTRATION_FAILED, statsHolder.getObjectName());
            return;
        }
        _LOGGER.info(ServiceMessages.UNREGISTERED_JMX, statsHolder.getObjectName());
    }
}

