/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.jmx.AgentSession;
import org.rvpf.jmx.AgentSessionFactory;
import org.rvpf.jmx.AgentSessionImpl;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.StatsHolder;
import org.rvpf.service.rmi.SessionFactoryImpl;
import org.rvpf.service.rmi.SessionSecurityContext;

@ThreadSafe
final class AgentSessionFactoryImpl
extends SessionFactoryImpl
implements AgentSessionFactory {
    private boolean _platform;
    private MBeanServer _server;

    AgentSessionFactoryImpl(@Nonnull SessionSecurityContext securityContext) {
        super(Optional.of(securityContext));
    }

    @Override
    public AgentSession createAgentSession(UUID uuid, String clientName) throws SessionException {
        return (AgentSession)this.createSession(uuid, clientName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUp(@Nonnull Config config, boolean platform) {
        if (!this.setUp(config)) {
            return false;
        }
        AgentSessionFactoryImpl agentSessionFactoryImpl = this;
        synchronized (agentSessionFactoryImpl) {
            this._platform = platform;
            this._server = this._platform ? ManagementFactory.getPlatformMBeanServer() : MBeanServerFactory.createMBeanServer(StatsHolder.getDefaultDomain());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() {
        AgentSessionFactoryImpl agentSessionFactoryImpl = this;
        synchronized (agentSessionFactoryImpl) {
            if (this._server != null) {
                if (!this._platform) {
                    MBeanServerFactory.releaseMBeanServer(this._server);
                }
                this._server = null;
            }
        }
        super.tearDown();
    }

    @Override
    @GuardedBy(value="this")
    protected void fillRolesMap() {
        KeyedGroups jmxProperties = this.getConfig().getPropertiesGroup("jmx");
        if (jmxProperties != null) {
            this.mapRoles("Connect", jmxProperties.getStrings("role.connect"));
        }
    }

    @Override
    protected Session newSession(Session.ConnectionMode connectionMode, Optional<RMIClientSocketFactory> clientSocketFactory, Optional<RMIServerSocketFactory> serverSocketFactory, Object reference) {
        AgentSessionImpl session;
        try {
            session = new AgentSessionImpl(clientSocketFactory, serverSocketFactory);
            session.open(reference.toString(), this, connectionMode);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return session;
    }

    @Nonnull
    @CheckReturnValue
    synchronized MBeanServer getServer() {
        return Require.notNull(this._server);
    }

    static abstract class AbstractAgentSession
    extends RMIJRMPServerImpl {
        private final AtomicBoolean _closed = new AtomicBoolean();

        AbstractAgentSession(@Nonnull Optional<RMIClientSocketFactory> clientSocketFactory, @Nonnull Optional<RMIServerSocketFactory> serverSocketFactory) throws IOException {
            super(0, clientSocketFactory.orElse(null), serverSocketFactory.orElse(null), null);
        }

        @Override
        public void close() {
            if (this._closed.compareAndSet(false, true)) {
                try {
                    super.close();
                }
                catch (IOException exception) {
                    Logger.getInstance(this.getClass()).debug(ServiceMessages.CLOSE_EXCEPTION, exception.getMessage());
                }
            }
        }
    }
}

