/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.jmx;

import java.io.IOException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.Unreferenced;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectorServer;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.jmx.AgentSession;
import org.rvpf.jmx.AgentSessionFactoryImpl;
import org.rvpf.service.rmi.SessionImpl;

public final class AgentSessionImpl
extends AgentSessionFactoryImpl.AbstractAgentSession
implements AgentSession,
Unreferenced {
    static final String CONNECT_ROLE = "Connect";
    private volatile RMIConnectorServer _connectorServer;
    private volatile SessionImpl _session;

    AgentSessionImpl(@Nonnull Optional<RMIClientSocketFactory> clientSocketFactory, @Nonnull Optional<RMIServerSocketFactory> serverSocketFactory) throws IOException {
        super(clientSocketFactory, serverSocketFactory);
    }

    @Override
    public synchronized void close() {
        SessionImpl session;
        super.close();
        RMIConnectorServer connectorServer = this._connectorServer;
        if (connectorServer != null) {
            try {
                connectorServer.stop();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        if ((session = this._session) != null && !session.isClosed()) {
            session.close();
        }
    }

    @Override
    public Session.ConnectionMode getConnectionMode() {
        return this._session.getConnectionMode();
    }

    @Override
    public void login(String identifier, char[] password) throws SessionException {
        this._session.login(identifier, password);
    }

    @Override
    public void logout() {
        this._session.logout();
    }

    @Override
    public RMIConnection newClient(Object credentials) throws IOException {
        try {
            this._session.securityCheck(CONNECT_ROLE);
        }
        catch (SessionException exception) {
            throw new RuntimeException(exception);
        }
        return super.newClient(credentials);
    }

    @Override
    public void unreferenced() {
        this.close();
    }

    @CheckReturnValue
    boolean isConnectorServerActive() {
        RMIConnectorServer connectorServer = this._connectorServer;
        return connectorServer != null && connectorServer.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open(@Nonnull String clientName, @Nonnull AgentSessionFactoryImpl sessionFactory, @Nonnull Session.ConnectionMode connectionMode) throws IOException {
        MBeanServer mbeanServer = sessionFactory.getServer();
        AgentSessionImpl agentSessionImpl = this;
        synchronized (agentSessionImpl) {
            SessionImpl session = new SessionImpl(clientName, sessionFactory, connectionMode){

                @Override
                public void close() {
                    super.close();
                    if (AgentSessionImpl.this.isConnectorServerActive()) {
                        AgentSessionImpl.this.close();
                    }
                }

                @Override
                public boolean isClosed() {
                    return !AgentSessionImpl.this.isConnectorServerActive();
                }
            };
            session.open();
            this._session = session;
            this._connectorServer = new RMIConnectorServer(new JMXServiceURL(this.getProtocol(), null, 0), null, this, mbeanServer);
            this._connectorServer.start();
        }
    }
}

