/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.jmx;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import org.rvpf.base.logger.Message;
import org.rvpf.base.rmi.CatchedSessionException;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.SessionClientContext;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.rmi.SessionProxy;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.LoginInfo;
import org.rvpf.jmx.AgentSessionFactory;
import org.rvpf.service.ServiceMessages;

public final class AgentSessionProxy
extends SessionProxy {
    private MBeanServerConnection _agentConnection;
    private RMIConnector _connector;
    private final ObjectName _objectName;

    AgentSessionProxy(@Nonnull String clientName, @Nonnull Optional<LoginInfo> loginInfo, @Nonnull SessionClientContext context, @Nonnull Optional<SessionProxy.Listener> listener, boolean autoconnect, @Nonnull ObjectName objectName) {
        super(clientName, loginInfo, context, listener, autoconnect);
        this._objectName = objectName;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    public synchronized void closeConnection() {
        if (this._connector != null) {
            try {
                this._connector.close();
            }
            catch (IOException exception) {
                this.getThisLogger().debug(ServiceMessages.CONNECTION_CLOSE_FAILED, exception.getMessage());
            }
            this._connector = null;
            this._agentConnection = null;
        }
    }

    @Override
    public void disconnect() {
        this.closeConnection();
        super.disconnect();
    }

    @Nonnull
    @CheckReturnValue
    public synchronized MBeanServerConnection getConnection() throws SessionException {
        if (this._connector == null) {
            this._connector = new RMIConnector((RMIServer)((Object)this.getSession()), null);
            try {
                this._connector.connect();
                this._agentConnection = this._connector.getMBeanServerConnection();
            }
            catch (IOException exception) {
                throw new CatchedSessionException(exception);
            }
        }
        return this._agentConnection;
    }

    @Nonnull
    @CheckReturnValue
    public <T> T getMBeanProxy(@Nonnull Class<T> objectClass) throws SessionException {
        return this.getMBeanProxy(this.getObjectName(), objectClass, false);
    }

    @Nonnull
    @CheckReturnValue
    public <T> T getMBeanProxy(@Nonnull ObjectName objectName, @Nonnull Class<T> objectClass, boolean notificationBroadcaster) throws SessionException {
        return MBeanServerInvocationHandler.newProxyInstance(this.getConnection(), objectName, objectClass, notificationBroadcaster);
    }

    @Nonnull
    @CheckReturnValue
    public String getObjectClassName(@Nonnull ObjectName objectName) throws SessionException {
        try {
            return this.getConnection().getMBeanInfo(objectName).getClassName();
        }
        catch (InstanceNotFoundException exception) {
            throw new ServiceClosedException(exception);
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
    }

    @Nonnull
    @CheckReturnValue
    public ObjectName getObjectName() {
        return Require.notNull(this._objectName);
    }

    @Nonnull
    @CheckReturnValue
    public ObjectName[] getObjectNames() throws SessionException {
        Set<ObjectName> names;
        try {
            names = this.getConnection().queryNames(null, null);
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
        ObjectName[] objectNames = new ObjectName[names.size()];
        Iterator<ObjectName> iterator = names.iterator();
        for (int i = 0; i < objectNames.length; ++i) {
            objectNames[i] = iterator.next();
        }
        Arrays.sort(objectNames, Comparator.comparing(ObjectName::toString));
        return objectNames;
    }

    @Override
    protected Session createSession() throws RemoteException, SessionException {
        return ((AgentSessionFactory)this.getFactory()).createAgentSession(this.getContextUUID(), this.getClientName());
    }

    public static final class Builder
    extends SessionProxy.Builder {
        @Override
        public AgentSessionProxy build() {
            ObjectName objectName;
            if (!this.setUp()) {
                return null;
            }
            String serverName = this.getContext().getServerURI().getPath().substring(1);
            if (serverName.isEmpty() || !serverName.startsWith("service/")) {
                throw new IllegalArgumentException(Message.format(ServiceMessages.AGENT_URI_PATH, new Object[0]));
            }
            serverName = serverName.substring("service/".length());
            try {
                objectName = ObjectName.getInstance(serverName);
            }
            catch (MalformedObjectNameException exception) {
                throw new RuntimeException(exception);
            }
            return new AgentSessionProxy(this.getClientName(), this.getLoginInfo(), this.getContext(), this.getListener(), this.isAutoconnect(), objectName);
        }
    }
}

