/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Entity;
import org.rvpf.base.Point;
import org.rvpf.base.Points;
import org.rvpf.base.UUID;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.IdentityHashSet;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.xml.XMLDocument;
import org.rvpf.config.Config;
import org.rvpf.config.ConfigProperties;
import org.rvpf.config.TopologicalErrorException;
import org.rvpf.document.exporter.MetadataExporter;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.metadata.entity.BehaviorEntity;
import org.rvpf.metadata.entity.ContentEntity;
import org.rvpf.metadata.entity.EngineEntity;
import org.rvpf.metadata.entity.GroupEntity;
import org.rvpf.metadata.entity.OriginEntity;
import org.rvpf.metadata.entity.PointEntity;
import org.rvpf.metadata.entity.StoreEntity;
import org.rvpf.metadata.entity.SyncEntity;
import org.rvpf.metadata.entity.TransformEntity;
import org.rvpf.metadata.processor.Transform;
import org.rvpf.service.ServiceMessages;

public final class Metadata
extends Config
implements Points {
    public static final String RVPF_SCHEME = "rvpf";
    private final Set<Entity> _anchor = new IdentityHashSet<Entity>();
    private KeyedGroups _attributes = new KeyedGroups();
    private final Config _config;
    private final Map<String, Reference<ContentEntity>> _contentsByName = new HashMap<String, Reference<ContentEntity>>();
    private final Map<Class<?>, BehaviorEntity> _defaultBehaviors = new HashMap();
    private String _domain;
    private final Map<String, Reference<EngineEntity>> _enginesByName = new HashMap<String, Reference<EngineEntity>>();
    private MetadataFilter _filter;
    private final Map<String, GroupEntity> _groupsByName = new HashMap<String, GroupEntity>();
    private final Map<String, Reference<OriginEntity>> _originsByName = new HashMap<String, Reference<OriginEntity>>();
    private final Points.Impl _points = new Points.Impl();
    private final Map<UUID, Set<String>> _pointsAliases = new WeakHashMap<UUID, Set<String>>();
    private final Map<String, Reference<StoreEntity>> _storesByName = new HashMap<String, Reference<StoreEntity>>();
    private final Map<String, Reference<SyncEntity>> _syncsByName = new HashMap<String, Reference<SyncEntity>>();
    private final Map<String, Reference<TransformEntity>> _transformsByName = new HashMap<String, Reference<TransformEntity>>();
    private URL _url;

    public Metadata(@Nonnull Config config) {
        super(config.getServiceName(), new ConfigProperties(ServiceMessages.METADATA_PROPERTIES_TYPE, Optional.of(config.getServiceName())));
        this.setClassLoader(Optional.of(config.getClassLoader()));
        this.getProperties().setOverrider(config.getProperties());
        this.updateStamp(config.getStamp());
        this._config = config;
    }

    public void addContentEntity(@Nonnull Optional<ContentEntity> contentEntity) {
        Optional<String> name;
        if (contentEntity.isPresent() && (name = contentEntity.get().getNameInUpperCase()).isPresent() && !this._contentsByName.containsKey(name.get())) {
            this._contentsByName.put(name.get(), new WeakReference<ContentEntity>(contentEntity.get()));
        }
    }

    public void addEngineEntity(@Nonnull Optional<EngineEntity> engineEntity) {
        Optional<String> name;
        if (engineEntity.isPresent() && (name = engineEntity.get().getNameInUpperCase()).isPresent() && !this._enginesByName.containsKey(name.get())) {
            this._enginesByName.put(name.get(), new WeakReference<EngineEntity>(engineEntity.get()));
        }
    }

    public void addGroupEntity(@Nonnull Optional<GroupEntity> groupEntity) {
        Optional<String> name;
        if (groupEntity.isPresent() && (name = groupEntity.get().getNameInUpperCase()).isPresent() && !this._groupsByName.containsKey(name.get())) {
            this._groupsByName.put(name.get(), groupEntity.get());
        }
    }

    public void addOriginEntity(@Nonnull Optional<OriginEntity> originEntity) {
        Optional<String> name;
        if (originEntity.isPresent() && (name = originEntity.get().getNameInUpperCase()).isPresent() && !this._originsByName.containsKey(name.get())) {
            this._originsByName.put(name.get(), new WeakReference<OriginEntity>(originEntity.get()));
        }
    }

    public void addPointAlias(@Nonnull PointEntity pointEntity, @Nonnull String alias) {
        Optional previousPoint;
        UUID pointUUID = pointEntity.getUUID().get();
        Set<String> aliases = this._pointsAliases.get(pointUUID);
        if (aliases == null) {
            aliases = new HashSet<String>();
            this._pointsAliases.put(pointUUID, aliases);
        }
        aliases.add(alias);
        Optional<Reference<Point>> previousReference = this._points.addAlias(alias, pointEntity);
        Optional<Object> optional = previousPoint = previousReference.isPresent() ? Optional.of(previousReference.get().get()) : Optional.empty();
        if (previousPoint.isPresent() && !((Point)previousPoint.get()).equals(pointEntity)) {
            this.getThisLogger().warn(ServiceMessages.POINT_ALIAS_HIDES, alias, pointEntity, previousPoint.get());
        }
    }

    public void addPointEntity(@Nonnull Optional<PointEntity> pointEntity) {
        if (pointEntity.isPresent()) {
            this._points.addPoint(pointEntity.get());
        }
    }

    public void addStoreEntity(@Nonnull Optional<StoreEntity> storeEntity) {
        Optional<String> name;
        if (storeEntity.isPresent() && (name = storeEntity.get().getNameInUpperCase()).isPresent() && !this._storesByName.containsKey(name.get())) {
            this._storesByName.put(name.get(), new WeakReference<StoreEntity>(storeEntity.get()));
        }
    }

    public void addSyncEntity(@Nonnull Optional<SyncEntity> syncEntity) {
        Optional<String> name;
        if (syncEntity.isPresent() && (name = syncEntity.get().getNameInUpperCase()).isPresent() && !this._syncsByName.containsKey(name.get())) {
            this._syncsByName.put(name.get(), new WeakReference<SyncEntity>(syncEntity.get()));
        }
    }

    public void addTransformEntity(@Nonnull Optional<TransformEntity> transformEntity) {
        Optional<String> name;
        if (transformEntity.isPresent() && (name = transformEntity.get().getNameInUpperCase()).isPresent() && !this._transformsByName.containsKey(name.get())) {
            this._transformsByName.put(name.get(), new WeakReference<TransformEntity>(transformEntity.get()));
        }
    }

    @CheckReturnValue
    public boolean adjustPointsLevel() {
        boolean success = true;
        for (Point point : this.getPointsCollection()) {
            try {
                ((PointEntity)point).adjustLevel();
            }
            catch (TopologicalErrorException exception) {
                this.getThisLogger().error(BaseMessages.VERBATIM, exception.getMessage());
                success = false;
            }
        }
        return success;
    }

    public void anchor(@Nonnull Entity entity) {
        this._anchor.add(entity);
    }

    public void cleanUp() {
        boolean cleaned;
        this._defaultBehaviors.clear();
        do {
            cleaned = false;
            System.gc();
            cleaned |= Metadata._cleanUp(this._contentsByName);
            cleaned |= Metadata._cleanUp(this._enginesByName);
            cleaned |= Metadata._cleanUp(this._points.getUUIDMap());
            cleaned |= Metadata._cleanUp(this._points.getNamesMap());
            cleaned |= Metadata._cleanUp(this._originsByName);
            cleaned |= Metadata._cleanUp(this._storesByName);
            cleaned |= Metadata._cleanUp(this._syncsByName);
            cleaned |= Metadata._cleanUp(this._transformsByName);
            for (GroupEntity group : this.getGroupEntities()) {
                cleaned |= group.cleanUp();
            }
        } while (cleaned);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Metadata) {
            Metadata otherMetadata = (Metadata)other;
            if (!this.getDomain().equals(otherMetadata.getDomain())) {
                return false;
            }
            if (!this.getProperties().equals(otherMetadata.getProperties())) {
                return false;
            }
            if (!Objects.equals(this._attributes, otherMetadata._attributes)) {
                return false;
            }
            ArrayList<Point> points = new ArrayList<Point>(this.getPointsCollection());
            ArrayList<Point> otherPoints = new ArrayList<Point>(otherMetadata.getPointsCollection());
            points.sort(Entity.UUID_COMPARATOR);
            otherPoints.sort(Entity.UUID_COMPARATOR);
            if (!points.equals(otherPoints)) {
                return false;
            }
            for (Point point : points) {
                if (this.getPointAliases(point).equals(otherMetadata.getPointAliases(point))) continue;
                return false;
            }
            if (this._groupsByName.size() != otherMetadata._groupsByName.size()) {
                return false;
            }
            for (Map.Entry entry : this._groupsByName.entrySet()) {
                if (((GroupEntity)entry.getValue()).equals(otherMetadata._groupsByName.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public KeyedGroups getAttributes() {
        return this._attributes;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Attributes> getAttributes(@Nonnull String usage) {
        return this._attributes.getObject(usage.toUpperCase(Locale.ROOT));
    }

    @Nonnull
    @CheckReturnValue
    public Config getConfig() {
        return this._config;
    }

    @Nonnull
    @CheckReturnValue
    public Collection<ContentEntity> getContentEntities() {
        LinkedList<ContentEntity> contentEntities = new LinkedList<ContentEntity>();
        for (Reference<ContentEntity> reference : this._contentsByName.values()) {
            ContentEntity contentEntity;
            if (reference == null || (contentEntity = reference.get()) == null) continue;
            contentEntities.add(contentEntity);
        }
        return contentEntities;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<ContentEntity> getContentEntity(@Nonnull Optional<String> name) {
        Reference<ContentEntity> reference = name.isPresent() ? this._contentsByName.get(name.get().trim().toUpperCase(Locale.ROOT)) : null;
        return Optional.ofNullable(reference != null ? (ContentEntity)reference.get() : null);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<BehaviorEntity> getDefaultBehavior(@Nonnull Class<?> behaviorClass) {
        return Optional.ofNullable(this._defaultBehaviors.get(behaviorClass));
    }

    @Nonnull
    @CheckReturnValue
    public String getDomain() {
        return this._domain != null ? this._domain : "";
    }

    @Nonnull
    @CheckReturnValue
    public Collection<EngineEntity> getEngineEntities() {
        LinkedList<EngineEntity> engineEntities = new LinkedList<EngineEntity>();
        for (Reference<EngineEntity> reference : this._enginesByName.values()) {
            EngineEntity engineEntity = reference != null ? reference.get() : null;
            if (engineEntity == null) continue;
            engineEntities.add(engineEntity);
        }
        return engineEntities;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<EngineEntity> getEngineEntity(@Nonnull Optional<String> name) {
        Reference<EngineEntity> reference = name.isPresent() ? this._enginesByName.get(name.get().trim().toUpperCase(Locale.ROOT)) : null;
        return Optional.ofNullable(reference != null ? (EngineEntity)reference.get() : null);
    }

    @Nonnull
    @CheckReturnValue
    public MetadataFilter getFilter() {
        MetadataFilter filter = this._filter;
        if (filter == null) {
            this._filter = filter = new MetadataFilter(false);
        }
        return filter;
    }

    @Nonnull
    @CheckReturnValue
    public Collection<GroupEntity> getGroupEntities() {
        return this._groupsByName.values();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<GroupEntity> getGroupEntity(@Nonnull Optional<String> name) {
        return Optional.ofNullable(name.isPresent() ? this._groupsByName.get(name.get().trim().toUpperCase(Locale.ROOT)) : null);
    }

    @Nonnull
    @CheckReturnValue
    public Collection<OriginEntity> getOriginEntities() {
        LinkedList<OriginEntity> originEntities = new LinkedList<OriginEntity>();
        for (Reference<OriginEntity> reference : this._originsByName.values()) {
            OriginEntity originEntity = reference != null ? reference.get() : null;
            if (originEntity == null) continue;
            originEntities.add(originEntity);
        }
        return originEntities;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<OriginEntity> getOriginEntity(@Nonnull Optional<String> name) {
        Reference<OriginEntity> reference = name.isPresent() ? this._originsByName.get(name.get().trim().toUpperCase(Locale.ROOT)) : null;
        return Optional.ofNullable(reference != null ? (OriginEntity)reference.get() : null);
    }

    @Override
    public Optional<Point> getPoint(String key) {
        return this._points.getPoint(key);
    }

    @Nonnull
    @CheckReturnValue
    public Set<String> getPointAliases(@Nonnull Point point) {
        Set<String> aliases = this._pointsAliases.get(point.getUUID().get());
        if (aliases == null) {
            aliases = Collections.emptySet();
        }
        return aliases;
    }

    @Override
    public Optional<Point> getPointByName(String name) {
        return this._points.getPointByName(name);
    }

    @Override
    public Optional<Point> getPointByUUID(UUID uuid) {
        return this._points.getPointByUUID(uuid);
    }

    @Override
    public Collection<Point> getPointsCollection() {
        return this._points.getPointsCollection();
    }

    @Nonnull
    @CheckReturnValue
    public Collection<StoreEntity> getStoreEntities() {
        LinkedList<StoreEntity> storeEntities = new LinkedList<StoreEntity>();
        for (Reference<StoreEntity> reference : this._storesByName.values()) {
            StoreEntity storeEntity = reference != null ? reference.get() : null;
            if (storeEntity == null) continue;
            storeEntities.add(storeEntity);
        }
        return storeEntities;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<StoreEntity> getStoreEntity(@Nonnull Optional<String> name) {
        Reference<StoreEntity> reference = name.isPresent() ? this._storesByName.get(name.get().trim().toUpperCase(Locale.ROOT)) : null;
        return Optional.ofNullable(reference != null ? (StoreEntity)reference.get() : null);
    }

    @Nonnull
    @CheckReturnValue
    public Collection<SyncEntity> getSyncEntities() {
        LinkedList<SyncEntity> syncEntities = new LinkedList<SyncEntity>();
        for (Reference<SyncEntity> reference : this._syncsByName.values()) {
            SyncEntity syncEntity = reference != null ? reference.get() : null;
            if (syncEntity == null) continue;
            syncEntities.add(syncEntity);
        }
        return syncEntities;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<SyncEntity> getSyncEntity(@Nonnull Optional<String> name) {
        Reference<SyncEntity> reference = name.isPresent() ? this._syncsByName.get(name.get().trim().toUpperCase(Locale.ROOT)) : null;
        return Optional.ofNullable(reference != null ? (SyncEntity)reference.get() : null);
    }

    @Nonnull
    @CheckReturnValue
    public Collection<TransformEntity> getTransformEntities() {
        LinkedList<TransformEntity> transformEntities = new LinkedList<TransformEntity>();
        for (Reference<TransformEntity> reference : this._transformsByName.values()) {
            TransformEntity transformEntity = reference != null ? reference.get() : null;
            if (transformEntity == null) continue;
            transformEntities.add(transformEntity);
        }
        return transformEntities;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<TransformEntity> getTransformEntity(@Nonnull Optional<String> name) {
        Reference<TransformEntity> reference = name.isPresent() ? this._transformsByName.get(name.get().trim().toUpperCase(Locale.ROOT)) : null;
        return Optional.ofNullable(reference != null ? (TransformEntity)reference.get() : null);
    }

    @Nonnull
    @CheckReturnValue
    public URI getURI(@Nonnull Entity entity) {
        try {
            return new URI(RVPF_SCHEME, entity.getElementName().toLowerCase(Locale.ROOT) + ":" + this.getDomain(), entity.getName().orElse(null));
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public URL getURL() {
        URL url = this._url;
        return url != null ? url : this.getConfig().getURL();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @CheckReturnValue
    public boolean isAnchored(@Nonnull Entity entity) {
        return this._anchor.contains(entity);
    }

    @Override
    public boolean isIncluded(URL url) {
        return super.isIncluded(url) || this._config.isIncluded(url);
    }

    @Override
    public boolean registerClassLib(String classLibName) {
        return this._config.registerClassLib(classLibName);
    }

    public final void setAttributes(@Nonnull KeyedGroups attributes) {
        this._attributes = Require.notNull(attributes);
    }

    public void setDefaultBehavior(@Nonnull Class<?> behaviorClass, @Nonnull BehaviorEntity behaviorEntity) {
        this._defaultBehaviors.put(behaviorClass, behaviorEntity);
    }

    public void setDomain(@Nonnull String domain) {
        if ((domain = domain.trim()).isEmpty()) {
            domain = null;
        }
        this._domain = domain;
    }

    public void setFilter(@Nonnull MetadataFilter filter) {
        this._filter = Require.notNull(filter);
    }

    @Override
    public void setURL(URL url) {
        this._url = url;
    }

    @Override
    public void tearDown() {
        super.tearDown();
        if (this._config != null) {
            this._config.tearDown();
        }
    }

    public void tearDownPoints() {
        for (Point point : this.getPointsCollection()) {
            ((PointEntity)point).tearDown();
        }
    }

    @Override
    public String toString() {
        return this.toXML().toString();
    }

    public XMLDocument toXML() {
        return MetadataExporter.export((Metadata)this, Optional.of(Collections.emptySet()), Optional.of(Collections.emptySet()), (boolean)true);
    }

    @CheckReturnValue
    public boolean validatePointsRelationships() {
        boolean success = true;
        for (Point point : this.getPointsCollection()) {
            if (((PointEntity)point).setUp(this)) continue;
            success = false;
        }
        if (success) {
            for (Point point : this.getPointsCollection()) {
                PointEntity pointEntity = (PointEntity)point;
                if (pointEntity.getTransformEntity() == null || pointEntity.setUpRelations(this)) continue;
                success = false;
            }
        }
        if (success) {
            for (Point point : this.getPointsCollection()) {
                Optional<Transform> transform = ((PointEntity)point).getTransform();
                if (!transform.isPresent() || transform.get().setUp(point)) continue;
                success = false;
            }
        }
        return success;
    }

    private static boolean _cleanUp(Map<?, ?> map) {
        boolean cleaned = false;
        Iterator<Map.Entry<?, ?>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<?, ?> entry = i.next();
            Reference reference = (Reference)entry.getValue();
            if (reference.get() != null) continue;
            i.remove();
            cleaned = true;
        }
        return cleaned;
    }
}

