/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.Params;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.ProxyEntity;

public interface Proxied {
    @Nonnull
    @CheckReturnValue
    public String getName();

    @Nonnull
    @CheckReturnValue
    public Params getParams();

    @Nonnull
    @CheckReturnValue
    public ProxyEntity getProxyEntity();

    @CheckReturnValue
    public boolean setUp(@Nonnull Metadata var1, @Nonnull ProxyEntity var2);

    public void tearDown();

    @NotThreadSafe
    public static abstract class Abstract
    implements Proxied {
        private volatile Logger _logger;
        private Metadata _metadata;
        private ProxyEntity _proxyEntity;

        @Nonnull
        @CheckReturnValue
        public final Metadata getMetadata() {
            return Require.notNull(this._metadata);
        }

        @Override
        public final String getName() {
            return this._proxyEntity.getName().orElseGet(() -> this.getClass().getName());
        }

        @Override
        public final Params getParams() {
            return this._proxyEntity.getParams();
        }

        @Override
        public final ProxyEntity getProxyEntity() {
            return this._proxyEntity;
        }

        @Override
        public boolean setUp(Metadata metadata, ProxyEntity proxyEntity) {
            this._metadata = metadata;
            this._proxyEntity = proxyEntity;
            return true;
        }

        @Override
        public void tearDown() {
            ProxyEntity proxyEntity = this._proxyEntity;
            if (proxyEntity != null) {
                proxyEntity.clearInstance();
                this._proxyEntity = null;
            }
            this._metadata = null;
        }

        @Nonnull
        @CheckReturnValue
        protected Logger getThisLogger() {
            Logger logger = this._logger;
            if (logger == null) {
                this._logger = logger = Logger.getInstance(this.getClass());
            }
            return logger;
        }
    }
}

