/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;

public final class Text {
    private String _description;
    private String _ident;
    private final String _lang;
    private List<String> _notes;
    private List<Other> _others;
    private String _title;

    public Text(@Nonnull Optional<String> lang) {
        this._lang = lang.isPresent() ? lang.get().trim().toLowerCase(Locale.ROOT) : "";
    }

    public void addNotes(@Nonnull Optional<String> notes) {
        if (notes.isPresent()) {
            if (this._notes == null) {
                this._notes = new LinkedList<String>();
            }
            this._notes.add(notes.get());
        }
    }

    public void addOther(@Nonnull String element, @Nonnull String text) {
        if (this._others == null) {
            this._others = new LinkedList<Other>();
        }
        this._others.add(new Other(element, text));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Text) {
            Text otherText = (Text)other;
            if (this._ident == null ? otherText._ident != null : !this._ident.equals(otherText._ident)) {
                return false;
            }
            if (this._title == null ? otherText._title != null : !this._title.equals(otherText._title)) {
                return false;
            }
            if (this._description == null ? otherText._description != null : !this._description.equals(otherText._description)) {
                return false;
            }
            if (!this.getNotes().equals(otherText.getNotes())) {
                return false;
            }
            return this.getOthers().equals(otherText.getOthers());
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<String> getDescription() {
        return Optional.ofNullable(this._description);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<String> getIdent() {
        return Optional.ofNullable(this._ident);
    }

    @Nonnull
    @CheckReturnValue
    public String getLang() {
        return this._lang;
    }

    @Nonnull
    @CheckReturnValue
    public List<String> getNotes() {
        return this._notes != null ? this._notes : Collections.emptyList();
    }

    @Nonnull
    @CheckReturnValue
    public List<Other> getOthers() {
        return this._others != null ? this._others : Collections.emptyList();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<String> getTitle() {
        return Optional.ofNullable(this._title);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @CheckReturnValue
    public boolean isEmpty() {
        return this._ident == null && this._title == null && this._description == null && this._notes == null && this._others == null;
    }

    public void merge(@Nonnull Text previous) {
        if (this._ident == null) {
            this._ident = previous._ident;
        }
        if (this._title == null) {
            this._title = previous._title;
        }
        if (this._description == null) {
            this._description = previous._description;
        }
        if (previous._notes != null) {
            if (this._notes == null) {
                this._notes = previous._notes;
            } else {
                this._notes.addAll(0, previous._notes);
            }
        }
        if (previous._others != null) {
            if (this._others == null) {
                this._others = previous._others;
            } else {
                this._others.addAll(0, previous._others);
            }
        }
    }

    public void setDescription(Optional<String> description) {
        if (description.isPresent()) {
            this._description = description.get();
        }
    }

    public void setIdent(Optional<String> ident) {
        if (ident.isPresent()) {
            this._ident = ident.get().trim();
        }
    }

    public void setTitle(Optional<String> title) {
        if (title.isPresent()) {
            this._title = title.get().trim();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this));
    }

    public static final class Other {
        private final String _element;
        private final String _text;

        Other(@Nonnull String element, @Nonnull String text) {
            this._element = Require.notNull(element);
            this._text = Require.notNull(text);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Other) {
                Other otherOther = (Other)other;
                if (this._element == null ? otherOther._element != null : !this._element.equals(otherOther._element)) {
                    return false;
                }
                return this._text != null ? this._text.equals(otherOther._text) : otherOther._text == null;
            }
            return false;
        }

        public String getElement() {
            return this._element;
        }

        public String getText() {
            return this._text;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this));
        }
    }
}

