/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.UUID;
import org.rvpf.base.tool.Require;
import org.rvpf.config.entity.ValidatorDefEntity;
import org.rvpf.metadata.entity.AttributeDefEntity;
import org.rvpf.service.ServiceMessages;

public final class AttributesDefEntity
extends ValidatorDefEntity {
    public static final String ELEMENT_NAME = "AttributesDef";
    public static final String ENTITY_PREFIX = "A";
    private final Map<String, AttributeDefEntity> _attributeDefs;
    private final String _usage;

    AttributesDefEntity(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, boolean hidden, boolean multiple, @Nonnull String usage, @Nonnull Map<String, AttributeDefEntity> attributeDefs) {
        super(name, uuid, hidden, multiple);
        this._usage = Require.notNull(usage);
        this._attributeDefs = Require.notNull(attributeDefs);
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public AttributesDefEntity copy() {
        return AttributesDefEntity.newBuilder().copyFrom(this).build();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<AttributeDefEntity> getAttributeDef(@Nonnull String name) {
        return Optional.ofNullable(this._attributeDefs.get(name.toUpperCase(Locale.ROOT)));
    }

    @Nonnull
    @CheckReturnValue
    public Collection<AttributeDefEntity> getAttributeDefs() {
        return this._attributeDefs.values();
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public String getPrefix() {
        return ENTITY_PREFIX;
    }

    @Override
    public String getReferenceName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTarget() {
        return "attributes";
    }

    @Nonnull
    @CheckReturnValue
    public String getUsage() {
        return this._usage;
    }

    @Nonnull
    @CheckReturnValue
    Map<String, AttributeDefEntity> _getAttributeDefs() {
        return this._attributeDefs;
    }

    public static final class Builder
    extends ValidatorDefEntity.Builder {
        private Map<String, AttributeDefEntity> _attributeDefs;
        private String _usage;

        Builder() {
        }

        @Nonnull
        public Builder addAttributeDef(@Nonnull AttributeDefEntity attributeDef) {
            String attributeName = attributeDef.getName().get();
            if (this._attributeDefs == null) {
                this._attributeDefs = new HashMap<String, AttributeDefEntity>();
            }
            if (this._attributeDefs.put(attributeName.toUpperCase(Locale.ROOT), attributeDef) != null) {
                this.getThisLogger().warn(ServiceMessages.ATTRIBUTE_DEF_MULTIPLE, attributeName);
            }
            return this;
        }

        @Override
        public AttributesDefEntity build() {
            AttributesDefEntity attributesDef = new AttributesDefEntity(this.getName(), this.getUUID(), this.isHidden(), this.isMultiple(), Require.notNull(this._usage), this._attributeDefs != null ? this._attributeDefs : new HashMap<String, AttributeDefEntity>());
            this._attributeDefs = null;
            return attributesDef;
        }

        @Nonnull
        public final Builder copyFrom(@Nonnull AttributesDefEntity attributesDef) {
            super.copyFrom(attributesDef);
            this._usage = attributesDef.getUsage();
            this._attributeDefs = new HashMap<String, AttributeDefEntity>(attributesDef._getAttributeDefs());
            return this;
        }

        @Nonnull
        public Builder setUsage(@Nonnull String usage) {
            this._usage = Require.notNull(usage);
            return this;
        }
    }
}

