/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.entity;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.DateTime;
import org.rvpf.base.Params;
import org.rvpf.base.Point;
import org.rvpf.base.PointRelation;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.sync.Sync;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.ResultValue;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.Proxied;
import org.rvpf.metadata.entity.BehaviorEntity;
import org.rvpf.metadata.entity.PointInput;
import org.rvpf.metadata.entity.ProxyEntity;
import org.rvpf.metadata.entity.SyncEntity;
import org.rvpf.metadata.processor.Batch;
import org.rvpf.metadata.processor.Behavior;
import org.rvpf.service.ServiceMessages;

public final class BehaviorEntityReference
implements Behavior {
    private static final Logger _LOGGER = Logger.getInstance(BehaviorEntityReference.class);
    private BehaviorEntity _entity;
    private boolean _inherited;
    private Metadata _metadata;
    private Behavior _next;
    private PointInput _relation;

    public BehaviorEntityReference(@Nonnull PointRelation relation, @Nonnull BehaviorEntity entity, boolean inherited) {
        this._relation = (PointInput)relation;
        this._entity = entity;
        this._inherited = inherited;
    }

    public void add(@Nonnull BehaviorEntityReference reference) {
        Optional<Behavior> nextBehavior = this.getNext();
        if (nextBehavior.isPresent()) {
            ((BehaviorEntityReference)nextBehavior.get()).add(reference);
        } else {
            this._next = reference;
        }
    }

    @Override
    public <T extends Behavior> Optional<T> getBehavior(Class<T> behaviorClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BehaviorEntity getEntity() {
        return this._entity;
    }

    @Override
    public Point getInputPoint() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<Behavior> getNext() {
        return Optional.ofNullable(this._next);
    }

    @Override
    public Params getParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProxyEntity getProxyEntity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<PointRelation> getRelation() {
        return Optional.ofNullable(this._relation);
    }

    @Override
    public Optional<Sync> getRelationSync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<SyncEntity> getRelationSyncEntity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Point getResultPoint() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    @CheckReturnValue
    public Behavior instantiate() {
        Behavior instance;
        Class<?> behaviorClass = this.getEntity().getInstance().get().getClass();
        try {
            instance = (Behavior)behaviorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException exception) {
            _LOGGER.warn(ServiceMessages.BEHAVIORS_CLASS, Proxied.Abstract.class.getName());
            return null;
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        instance.setRelation(this.getRelation().orElse(null));
        instance.setInherited(this.isInherited());
        if (!instance.setUp(this._metadata, this.getEntity())) {
            return null;
        }
        Behavior next = this.getNext().orElse(null);
        if (next != null) {
            if ((next = ((BehaviorEntityReference)next).instantiate()) == null) {
                return null;
            }
            instance.setNext(next);
        }
        return instance;
    }

    @Override
    public boolean isInherited() {
        return this._inherited;
    }

    @Override
    public boolean isInputExtrapolated() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInputInterpolated() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInputRequired() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInputValid(PointValue inputValue, ResultValue resultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPrimary() {
        return ((Behavior)this.getEntity().getInstance().get()).isPrimary();
    }

    @Override
    public boolean isResultFetched(PointValue noticeValue, ResultValue resultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSynchronized() {
        return ((Behavior)this.getEntity().getInstance().get()).isSynchronized();
    }

    @Override
    public ResultValue newResultValue(Optional<DateTime> stamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean prepareSelect(ResultValue resultValue, Batch batch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean prepareTrigger(PointValue noticeValue, Batch batch) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    @CheckReturnValue
    public BehaviorEntityReference primary() {
        return this._primary(false);
    }

    @Override
    public boolean select(ResultValue resultValue, Batch batch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInherited(boolean inherited) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNext(Behavior next) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRelation(PointRelation relation) {
        throw new UnsupportedOperationException();
    }

    @CheckReturnValue
    public boolean setUp(@Nonnull Metadata metadata) {
        this._metadata = metadata;
        if (!this.getEntity().setUp(metadata)) {
            return false;
        }
        return this._next == null || ((BehaviorEntityReference)this._next).setUp(metadata);
    }

    @Override
    public boolean setUp(Metadata metadata, ProxyEntity proxyEntity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void tearDown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void trigger(PointValue noticeValue, Batch batch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean validate() {
        throw new UnsupportedOperationException();
    }

    private BehaviorEntityReference _primary(boolean isFound) {
        BehaviorEntityReference nextPrimary;
        boolean isSynchronized = this.isSynchronized();
        boolean isPrimary = !isSynchronized && this.isPrimary();
        BehaviorEntityReference next = this.getNext().orElse(null);
        BehaviorEntityReference behaviorEntityReference = nextPrimary = next != null ? next._primary(isPrimary | isFound) : null;
        if (isFound) {
            if (isPrimary) {
                _LOGGER.warn(ServiceMessages.MULTIPLE_PRIMARY, this.getResultPoint());
            }
            return null;
        }
        if (nextPrimary != null && nextPrimary.isPrimary()) {
            if (nextPrimary == next) {
                this._next = null;
            }
            return nextPrimary;
        }
        return this;
    }
}

