/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.entity;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Entity;
import org.rvpf.base.UUID;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.WeakDeputy;
import org.rvpf.config.TopologicalErrorException;
import org.rvpf.metadata.Text;
import org.rvpf.metadata.entity.MetadataEntity;

public final class GroupEntity
extends MetadataEntity {
    public static final String ELEMENT_NAME = "Group";
    public static final String ENTITY_PREFIX = "U";
    public static final String ENTITY_REFERENCE_NAME = "group";
    private boolean _busy;
    private int _level;
    private final List<Reference<Entity>> _members = new LinkedList<Reference<Entity>>();
    private final Map<Class<? extends Entity>, Set<Reference<Entity>>> _membersByClass = new HashMap<Class<? extends Entity>, Set<Reference<Entity>>>();

    GroupEntity(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, @Nonnull Optional<KeyedGroups> attributes, @Nonnull Optional<Map<String, Text>> texts) {
        super(name, uuid, attributes, texts);
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @CheckReturnValue
    public boolean addMember(@Nonnull Entity member) throws TopologicalErrorException {
        boolean added;
        Set<Reference<Entity>> members = this._membersByClass.get(member.getClass());
        if (members == null) {
            members = new HashSet<Reference<Entity>>();
            this._membersByClass.put(member.getClass(), members);
        }
        if (added = members.add(new WeakDeputy<Entity>(member))) {
            if (member.getClass() == this.getClass()) {
                ((GroupEntity)member)._adjustLevel(this._level - 1);
            }
            this._members.add(new WeakDeputy<Entity>(member));
        }
        return added;
    }

    @CheckReturnValue
    public boolean cleanUp() {
        boolean cleaned = false;
        Iterator<Reference<Entity>> iterator = this._members.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().get() != null) continue;
            iterator.remove();
            cleaned = true;
        }
        return cleaned;
    }

    @Override
    public int compareTo(Entity other) {
        GroupEntity otherGroup = (GroupEntity)other;
        int comparison = this._level - otherGroup._level;
        if (comparison == 0) {
            comparison = this.getName().get().compareTo(otherGroup.getName().get());
        }
        return comparison;
    }

    @CheckReturnValue
    public boolean contains(@Nonnull Entity member, boolean recursive) {
        if (this._membersByClass == null) {
            return false;
        }
        if (this.getMembers(member.getClass()).contains(member)) {
            return true;
        }
        if (recursive) {
            for (Entity entity : this.getMembers(GroupEntity.class)) {
                if (!((GroupEntity)entity).contains(member, true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public GroupEntity copy() {
        return GroupEntity.newBuilder().copyFrom(this).build();
    }

    @Override
    public boolean equals(Object other) {
        List<Entity> otherMembers;
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        GroupEntity otherGroup = (GroupEntity)other;
        List<Entity> members = this.getMembers();
        return members.equals(otherMembers = otherGroup.getMembers());
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Nonnull
    @CheckReturnValue
    public List<Entity> getMembers() {
        ArrayList<Entity> members = new ArrayList<Entity>(this._members.size());
        for (Reference<Entity> reference : this._members) {
            members.add(reference.get());
        }
        return members;
    }

    @Nonnull
    @CheckReturnValue
    public <T extends Entity> Set<T> getMembers(@Nonnull Class<T> membersClass) {
        Set<Reference<Entity>> memberReferences;
        Set<Reference<Entity>> set = memberReferences = this._membersByClass != null ? this._membersByClass.get(membersClass) : null;
        if (memberReferences == null) {
            return Collections.emptySet();
        }
        HashSet<Entity> members = new HashSet<Entity>();
        for (Reference<Entity> memberReference : memberReferences) {
            members.add(memberReference.get());
        }
        return members;
    }

    @Nonnull
    @CheckReturnValue
    public <T extends Entity> Set<T> getMembers(@Nonnull Class<T> membersClass, boolean recursive) {
        HashSet<T> members = new HashSet<T>(this.getMembers(Require.notNull(membersClass)));
        if (recursive) {
            for (Entity entity : this.getMembers(GroupEntity.class)) {
                members.addAll(((GroupEntity)entity).getMembers(membersClass, true));
            }
        }
        return members;
    }

    @Override
    public String getPrefix() {
        return ENTITY_PREFIX;
    }

    @Override
    public String getReferenceName() {
        return ENTITY_REFERENCE_NAME;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private void _adjustLevel(int level) throws TopologicalErrorException {
        if (this._busy) {
            throw new TopologicalErrorException(this);
        }
        if (level > this._level) {
            this._level = level;
            this._busy = true;
            for (Entity member : this.getMembers(this.getClass())) {
                ((GroupEntity)member)._adjustLevel(this._level - 1);
            }
            this._busy = false;
        }
    }

    public static class Builder
    extends MetadataEntity.Builder {
        Builder() {
        }

        @Override
        public GroupEntity build() {
            return new GroupEntity(this.getName(), this.getUUID(), this.getAttributes(), this.getTexts());
        }

        @Nonnull
        public final Builder copyFrom(@Nonnull GroupEntity group) {
            super.copyFrom(group);
            return this;
        }
    }
}

