/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.entity;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.UUID;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.entity.AbstractEntity;
import org.rvpf.metadata.Text;

public abstract class MetadataEntity
extends AbstractEntity {
    private Optional<KeyedGroups> _attributes;
    private Optional<Map<String, Text>> _texts;

    protected MetadataEntity() {
        this._attributes = Optional.empty();
        this._texts = Optional.empty();
    }

    protected MetadataEntity(@Nonnull MetadataEntity other) {
        super(other);
        this._attributes = other._attributes.isPresent() ? Optional.of(other._attributes.get().copy()) : Optional.empty();
        this._texts = other._texts.isPresent() ? Optional.of(new TreeMap<String, Text>(other._texts.get())) : Optional.empty();
    }

    protected MetadataEntity(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, @Nonnull Optional<KeyedGroups> attributes, @Nonnull Optional<Map<String, Text>> texts) {
        super(name, uuid);
        this._attributes = Require.notNull(attributes);
        this._texts = Require.notNull(texts);
    }

    public final void addText(@Nonnull Text text) {
        if (!this._texts.isPresent()) {
            this._texts = Optional.of(new TreeMap());
        }
        if ((text = this._texts.get().put(text.getLang(), text)) != null) {
            this._texts.get().get(text.getLang()).merge(text);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            MetadataEntity otherEntity = (MetadataEntity)other;
            if (!Objects.equals(this._attributes, otherEntity._attributes)) {
                return false;
            }
            return Objects.equals(this._texts, otherEntity._texts);
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<KeyedGroups> getAttributes() {
        return this._attributes;
    }

    @Override
    public final Optional<Attributes> getAttributes(String usage) {
        Optional<Attributes> attributes = this._attributes.isPresent() ? this._attributes.get().getObject(usage.toUpperCase(Locale.ROOT)) : Optional.empty();
        return attributes;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<Map<String, Text>> getTexts() {
        return this._texts;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public final void setAttributes(@Nonnull Optional<KeyedGroups> attributes) {
        this._attributes = Require.notNull(attributes);
    }

    public static abstract class Builder
    extends AbstractEntity.Builder {
        private Optional<KeyedGroups> _attributes = Optional.empty();
        private Optional<Map<String, Text>> _texts = Optional.empty();

        protected Builder() {
        }

        @Nonnull
        public final Builder addText(@Nonnull Text text) {
            if (!this._texts.isPresent()) {
                this._texts = Optional.of(new TreeMap());
            }
            if ((text = this._texts.get().put(text.getLang(), text)) != null) {
                this._texts.get().get(text.getLang()).merge(text);
            }
            return this;
        }

        @Nonnull
        public final Builder setAttributes(@Nonnull Optional<KeyedGroups> attributes) {
            this._attributes = attributes;
            return this;
        }

        @Nonnull
        protected Builder copyFrom(@Nonnull MetadataEntity entity) {
            super.copyFrom(entity);
            this._attributes = entity.getAttributes();
            this._texts = entity.getTexts();
            return this;
        }

        @Nonnull
        @CheckReturnValue
        protected final Optional<KeyedGroups> getAttributes() {
            return this._attributes;
        }

        @Nonnull
        @CheckReturnValue
        protected final Optional<Map<String, Text>> getTexts() {
            return this._texts;
        }
    }
}

