/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.entity;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Origin;
import org.rvpf.base.Params;
import org.rvpf.base.UUID;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.IdentityHashSet;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.metadata.Text;
import org.rvpf.metadata.entity.ParamsEntity;
import org.rvpf.metadata.entity.PointEntity;

public final class OriginEntity
extends ParamsEntity
implements Origin {
    public static final String ELEMENT_NAME = "Origin";
    public static final String ENTITY_PREFIX = "O";
    public static final String ENTITY_REFERENCE_NAME = "origin";
    private final Set<PointEntity> _pointEntities;

    protected OriginEntity(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, @Nonnull Optional<KeyedGroups> attributes, @Nonnull Optional<Map<String, Text>> texts, @Nonnull Optional<Params> params, @Nonnull Set<PointEntity> pointEntities) {
        super(name, uuid, attributes, texts, params);
        this._pointEntities = Require.notNull(pointEntities);
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @CheckReturnValue
    public boolean addPointEntity(@Nonnull PointEntity pointEntity) {
        return this._pointEntities.add(pointEntity);
    }

    @Override
    public OriginEntity copy() {
        return OriginEntity.newBuilder().copyFrom(this).build();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return super.equals(other);
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Nonnull
    @CheckReturnValue
    public Set<PointEntity> getPointEntities() {
        return this._pointEntities;
    }

    @Override
    public String getPrefix() {
        return ENTITY_PREFIX;
    }

    @Override
    public String getReferenceName() {
        return ENTITY_REFERENCE_NAME;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static final class Builder
    extends ParamsEntity.Builder {
        private Set<PointEntity> _pointEntities;

        Builder() {
        }

        @Override
        public OriginEntity build() {
            OriginEntity originEntity = new OriginEntity(this.getName(), this.getUUID(), this.getAttributes(), this.getTexts(), this.getParams(), this._pointEntities != null ? this._pointEntities : new IdentityHashSet<PointEntity>());
            this._pointEntities = null;
            return originEntity;
        }

        @Nonnull
        protected Builder copyFrom(@Nonnull OriginEntity originEntity) {
            super.copyFrom(originEntity);
            this._pointEntities = new IdentityHashSet<PointEntity>(originEntity.getPointEntities());
            return this;
        }
    }
}

