/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.entity;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Entity;
import org.rvpf.base.UUID;
import org.rvpf.base.tool.Require;
import org.rvpf.config.entity.ValidatorDefEntity;

public final class ParamDefEntity
extends ValidatorDefEntity {
    public static final String ELEMENT_NAME = "ParamDef";
    public static final String ENTITY_PREFIX = "M";
    private final String _holder;

    ParamDefEntity(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, boolean hidden, boolean multiple, @Nonnull String holder) {
        super(name, uuid, hidden, multiple);
        this._holder = Require.notNull(holder);
    }

    @Nonnull
    @CheckReturnValue
    public static String createKey(@Nonnull String holder, @Nonnull String name) {
        return holder + "." + name;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public int compareTo(Entity other) {
        int comparison = super.compareTo(other);
        if (comparison == 0) {
            comparison = this.getHolder().compareTo(((ParamDefEntity)other).getHolder());
        }
        return comparison;
    }

    @Override
    public ParamDefEntity copy() {
        return ParamDefEntity.newBuilder().copyFrom(this).build();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (super.equals(other)) {
            return this.getHolder().equals(((ParamDefEntity)other).getHolder());
        }
        return false;
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Nonnull
    @CheckReturnValue
    public String getHolder() {
        return this._holder;
    }

    @Nonnull
    @CheckReturnValue
    public String getKey() {
        return ParamDefEntity.createKey(this._holder, this.getName().get());
    }

    @Override
    public String getPrefix() {
        return ENTITY_PREFIX + this._holder;
    }

    @Override
    public String getReferenceName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTarget() {
        return "param";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static final class Builder
    extends ValidatorDefEntity.Builder {
        private String _holder;

        Builder() {
        }

        @Override
        public ParamDefEntity build() {
            return new ParamDefEntity(this.getName(), this.getUUID(), this.isHidden(), this.isMultiple(), this._holder);
        }

        @Nonnull
        public final Builder copyFrom(@Nonnull ParamDefEntity propertyDef) {
            super.copyFrom(propertyDef);
            return this;
        }

        @Nonnull
        public Builder setHolder(@Nonnull String holder) {
            this._holder = Require.notNull(holder);
            return this;
        }
    }
}

