/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.entity;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Params;
import org.rvpf.base.UUID;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.metadata.Text;
import org.rvpf.metadata.entity.MetadataEntity;

public abstract class ParamsEntity
extends MetadataEntity {
    private Optional<Params> _params;

    protected ParamsEntity() {
        this._params = Optional.empty();
    }

    protected ParamsEntity(@Nonnull ParamsEntity other) {
        super(other);
        this._params = other._params.isPresent() ? Optional.of(other._params.get().copy()) : Optional.empty();
    }

    protected ParamsEntity(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, @Nonnull Optional<KeyedGroups> attributes, @Nonnull Optional<Map<String, Text>> texts, @Nonnull Optional<Params> params) {
        super(name, uuid, attributes, texts);
        this._params = Require.notNull(params);
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            return this.getParams().equals(((ParamsEntity)other).getParams());
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public final Params getParams() {
        return this._params.isPresent() ? this._params.get() : Params.EMPTY_PARAMS;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public final void setParams(@Nonnull Optional<Params> params) {
        this._params = Require.notNull(params);
    }

    @Nonnull
    @CheckReturnValue
    final Optional<Params> _getParams() {
        return this._params;
    }

    public static abstract class Builder
    extends MetadataEntity.Builder {
        private Optional<Params> _params = Optional.empty();

        protected Builder() {
        }

        public final Optional<Params> getParams() {
            return this._params;
        }

        @Nonnull
        public final Builder setParams(@Nonnull Optional<Params> params) {
            this._params = Require.notNull(params);
            return this;
        }

        @Nonnull
        protected Builder copyFrom(@Nonnull ParamsEntity entity) {
            super.copyFrom(entity);
            Optional<Params> params = entity._getParams();
            this._params = params.isPresent() ? Optional.of(params.get().copy()) : Optional.empty();
            return this;
        }
    }
}

