/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.entity;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.UUID;
import org.rvpf.base.security.Identity;
import org.rvpf.config.entity.AbstractEntity;
import org.rvpf.metadata.Permissions;

public final class PermissionsEntity
extends AbstractEntity
implements Permissions {
    public static final String ELEMENT_NAME = "Permissions";
    public static final String ENTITY_PREFIX = "I";
    private final Map<String, Set<Permissions.Action>> _permissions;

    PermissionsEntity(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, @Nonnull Map<String, Set<Permissions.Action>> permissions) {
        super(name, uuid);
        this._permissions = permissions;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    public void adopt(@Nonnull PermissionsEntity child) {
        for (Map.Entry<String, Set<Permissions.Action>> entry : this._permissions.entrySet()) {
            String role = entry.getKey();
            for (Permissions.Action action : entry.getValue()) {
                child.allow(role, action);
            }
        }
    }

    public void allow(@Nonnull String role, @Nonnull Permissions.Action action) {
        Set<Permissions.Action> permissions = this._permissions.get(role);
        if (permissions == null) {
            permissions = EnumSet.noneOf(Permissions.Action.class);
            this._permissions.put(role, permissions);
        }
        permissions.add(action);
    }

    @Override
    public boolean check(Permissions.Action action, Optional<Identity> identity) {
        if (!identity.isPresent() || this._check(action, "")) {
            return true;
        }
        for (String role : identity.get().getRoles()) {
            if (!this._check(action, role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PermissionsEntity copy() {
        return PermissionsEntity.newBuilder().copyFrom(this).build();
    }

    public void deny(@Nonnull String role, @Nonnull Permissions.Action action) {
        Set<Permissions.Action> permissions = this._permissions.get(role);
        if (permissions != null) {
            permissions.remove((Object)action);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (super.equals(other)) {
            return this._permissions.equals(((PermissionsEntity)other)._permissions);
        }
        return false;
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Nonnull
    @CheckReturnValue
    public Map<String, Set<Permissions.Action>> getPermissions() {
        return this._permissions;
    }

    @Override
    public String getPrefix() {
        return ENTITY_PREFIX;
    }

    @Override
    public String getReferenceName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private boolean _check(Permissions.Action action, String role) {
        Set<Permissions.Action> permissions = this._permissions.get(role);
        return permissions != null && permissions.contains((Object)action);
    }

    public static class Builder
    extends AbstractEntity.Builder {
        private Map<String, Set<Permissions.Action>> _permissions;

        Builder() {
        }

        @Override
        public PermissionsEntity build() {
            return new PermissionsEntity(this.getName(), this.getUUID(), this._permissions != null ? this._permissions : new HashMap<String, Set<Permissions.Action>>());
        }

        @Nonnull
        public final Builder copyFrom(@Nonnull PermissionsEntity permissions) {
            super.copyFrom(permissions);
            this._permissions = permissions.getPermissions();
            return this;
        }
    }
}

