/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.entity;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.ClassDef;
import org.rvpf.base.ClassDefImpl;
import org.rvpf.base.Content;
import org.rvpf.base.Entity;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.PointRelation;
import org.rvpf.base.UUID;
import org.rvpf.base.store.Store;
import org.rvpf.base.sync.Sync;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.filter.DisabledFilter;
import org.rvpf.base.value.filter.ValueFilter;
import org.rvpf.config.TopologicalErrorException;
import org.rvpf.config.UndefinedEntityException;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.Permissions;
import org.rvpf.metadata.Proxied;
import org.rvpf.metadata.entity.ContentEntity;
import org.rvpf.metadata.entity.OriginEntity;
import org.rvpf.metadata.entity.ParamsEntity;
import org.rvpf.metadata.entity.PermissionsEntity;
import org.rvpf.metadata.entity.PointInput;
import org.rvpf.metadata.entity.StoreEntity;
import org.rvpf.metadata.entity.SyncEntity;
import org.rvpf.metadata.entity.TransformEntity;
import org.rvpf.metadata.entity.filter.StepFilterFactory;
import org.rvpf.metadata.entity.filter.ValueFilterFactory;
import org.rvpf.metadata.processor.Transform;
import org.rvpf.service.ServiceMessages;

public abstract class PointEntity
extends ParamsEntity
implements Point {
    public static final ClassDef DEFAULT_FILTER = new ClassDefImpl(StepFilterFactory.class);
    public static final String ELEMENT_NAME = "Point";
    public static final String ENTITY_PREFIX = "P";
    public static final String ENTITY_REFERENCE_NAME = "point";
    private static final List<Point.Replicate> _EMPTY_REPLICATES_LIST = Collections.unmodifiableList(new LinkedList());
    private static final List<PointInput> _EMPTY_RELATIONS_LIST = Collections.unmodifiableList(new LinkedList());
    private boolean _busy;
    private Optional<ContentEntity> _contentEntity;
    private volatile boolean _dropped;
    private List<PointInput> _inputRelations;
    private int _level = -1;
    private Boolean _nullRemoves;
    private Optional<OriginEntity> _originEntity;
    private Optional<PermissionsEntity> _permissionsEntity;
    private int _recalcLatest;
    private List<Point.Replicate> _replicates;
    private List<PointInput> _resultRelations;
    private boolean _setUp;
    private Optional<StoreEntity> _storeEntity;
    private Optional<SyncEntity> _syncEntity;
    private boolean _tidied;
    private Optional<TransformEntity> _transformEntity;
    private boolean _volatile;

    protected PointEntity() {
        this._originEntity = Optional.empty();
        this._storeEntity = Optional.empty();
        this._syncEntity = Optional.empty();
        this._permissionsEntity = Optional.empty();
        this._contentEntity = Optional.empty();
        this._transformEntity = Optional.empty();
    }

    protected PointEntity(@Nonnull PointEntity other) {
        super(other);
        this._originEntity = other._originEntity;
        this._storeEntity = other._storeEntity;
        this._syncEntity = other._syncEntity;
        this._inputRelations = other._inputRelations;
        this._resultRelations = other._resultRelations;
        this._permissionsEntity = other._permissionsEntity;
        this._nullRemoves = other._nullRemoves;
        this._replicates = other._replicates;
        this._recalcLatest = other._recalcLatest;
        this._volatile = other._volatile;
        this._tidied = other._tidied;
        this._dropped = other._dropped;
        this._level = other._level;
        this._contentEntity = other._contentEntity;
        this._transformEntity = other._transformEntity;
    }

    public final void addInputRelation(@Nonnull PointInput inputRelation) {
        if (this._inputRelations == null) {
            this._inputRelations = new LinkedList<PointInput>();
        }
        this._inputRelations.add(Require.notNull(inputRelation));
    }

    public final void addReplicate(@Nonnull Point.Replicate replicate) {
        if (replicate.getPoint() == this) {
            throw new IllegalArgumentException();
        }
        if (this._replicates == null) {
            this._replicates = new LinkedList<Point.Replicate>();
        }
        this._replicates.add(replicate);
    }

    public final void adjustLevel() throws TopologicalErrorException {
        this._adjustLevel(0);
    }

    public final void clearContentEntity() {
        this._contentEntity = Optional.empty();
    }

    public final void clearInputs() {
        if (this._inputRelations != null) {
            this._inputRelations.clear();
        }
    }

    public final void clearResults() {
        if (this._resultRelations != null) {
            this._resultRelations.clear();
        }
    }

    public final void clearTransformEntity() {
        this._transformEntity = Optional.empty();
    }

    public final void close() {
        Optional<? extends Store> store = this.getStore();
        if (store.isPresent()) {
            store.get().close();
        }
    }

    @Override
    public final int compareTo(Entity other) {
        if (other == this) {
            return 0;
        }
        PointEntity otherPoint = (PointEntity)other;
        int comparison = this._level - otherPoint._level;
        if (comparison == 0) {
            UUID pointUUID = this.getUUID().get();
            UUID otherPointUUID = otherPoint.getUUID().get();
            comparison = pointUUID.compareTo(otherPointUUID);
        }
        return comparison;
    }

    @CheckReturnValue
    public final boolean contentIs(@Nonnull String name) throws UndefinedEntityException {
        if (!this._contentEntity.isPresent()) {
            return false;
        }
        return this._contentEntity.get().is(Require.notNull(name));
    }

    @Override
    public abstract PointEntity copy();

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            PointEntity otherPoint = (PointEntity)other;
            if (!Objects.equals(this._originEntity, otherPoint._originEntity)) {
                return false;
            }
            if (!Objects.equals(this._contentEntity, otherPoint._contentEntity)) {
                return false;
            }
            if (!Objects.equals(this._storeEntity, otherPoint._storeEntity)) {
                return false;
            }
            if (!Objects.equals(this._syncEntity, otherPoint._syncEntity)) {
                return false;
            }
            if (!Objects.equals(this._transformEntity, otherPoint._transformEntity)) {
                return false;
            }
            if (!Objects.equals(this._permissionsEntity, otherPoint._permissionsEntity)) {
                return false;
            }
            if (this._volatile != otherPoint._volatile) {
                return false;
            }
            List<Point.Replicate> replicates = this.getReplicates();
            List<Point.Replicate> otherReplicates = otherPoint.getReplicates();
            if (replicates.size() != otherReplicates.size()) {
                return false;
            }
            Iterator<Point.Replicate> replicatesIterator = replicates.iterator();
            Iterator<Point.Replicate> otherReplicatesIterator = otherReplicates.iterator();
            while (replicatesIterator.hasNext()) {
                if (Objects.equals(replicatesIterator.next().getPointUUID(), otherReplicatesIterator.next().getPointUUID())) continue;
                return false;
            }
            return this.getInputs().equals(otherPoint.getInputs());
        }
        return false;
    }

    @Override
    public final ValueFilter filter() {
        ClassDef filterFactoryClassDef = this.getParams().getClassDef("Filter", DEFAULT_FILTER);
        ValueFilterFactory filterFactory = filterFactoryClassDef.createInstance(ValueFilterFactory.class);
        return filterFactory != null ? filterFactory.newFilter(this.getParams()) : new DisabledFilter();
    }

    public void flagResultRelations() {
        if (this._resultRelations == null) {
            this._resultRelations = new LinkedList<PointInput>();
        }
    }

    @Override
    public final Optional<Content> getContent() {
        return this._contentEntity.isPresent() ? Optional.of((Content)((Object)this._contentEntity.get().getInstance().get())) : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<ContentEntity> getContentEntity() {
        return this._contentEntity;
    }

    @Nonnull
    @CheckReturnValue
    public abstract Optional<PointEntity> getDefinition();

    @Override
    public final String getElementName() {
        return ELEMENT_NAME;
    }

    public final List<PointInput> getInputs() {
        return this._inputRelations != null ? Collections.unmodifiableList(this._inputRelations) : _EMPTY_RELATIONS_LIST;
    }

    @Override
    public final int getLevel() {
        return this._level;
    }

    @Override
    public final Optional<? extends Origin> getOrigin() {
        return this._originEntity;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<OriginEntity> getOriginEntity() {
        return this._originEntity;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<? extends Permissions> getPermissions() {
        if (!this._permissionsEntity.isPresent() && this._storeEntity.isPresent()) {
            return this._storeEntity.get().getPermissions();
        }
        return this._permissionsEntity;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<PermissionsEntity> getPermissionsEntity() {
        return this._permissionsEntity;
    }

    @Override
    public final String getPrefix() {
        return ENTITY_PREFIX;
    }

    @CheckReturnValue
    public final int getRecalcLatest() {
        return this._recalcLatest;
    }

    @Override
    public String getReferenceName() {
        return ENTITY_REFERENCE_NAME;
    }

    @Override
    public List<Point.Replicate> getReplicates() {
        return this._replicates != null ? Collections.unmodifiableList(this._replicates) : _EMPTY_REPLICATES_LIST;
    }

    public final List<PointInput> getResults() {
        return this._resultRelations != null ? Collections.unmodifiableList(this._resultRelations) : _EMPTY_RELATIONS_LIST;
    }

    @Override
    public final Optional<? extends Store> getStore() {
        return this._storeEntity.isPresent() ? this._storeEntity.get().getInstance() : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<StoreEntity> getStoreEntity() {
        return this._storeEntity;
    }

    @Override
    public final Optional<Sync> getSync() {
        return this._syncEntity.isPresent() ? Optional.of(this._syncEntity.get().getSync()) : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<SyncEntity> getSyncEntity() {
        return this._syncEntity;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<Transform> getTransform() {
        return Optional.ofNullable(this._transformEntity.isPresent() ? this._transformEntity.get().getTransform() : null);
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<TransformEntity> getTransformEntity() {
        return this._transformEntity;
    }

    @CheckReturnValue
    public final boolean hasInputRelations() {
        return this._inputRelations != null;
    }

    @CheckReturnValue
    public final boolean hasResultRelations() {
        return this._resultRelations != null;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @CheckReturnValue
    public abstract boolean isDefinition();

    @Override
    public final boolean isDropped() {
        return this._dropped;
    }

    @Override
    public final boolean isNullRemoves(boolean defaultNullRemoves) {
        return this._nullRemoves != null ? this._nullRemoves : defaultNullRemoves;
    }

    @Override
    public boolean isSynced() {
        return this._syncEntity.isPresent();
    }

    @Override
    public final boolean isVolatile() {
        return this._volatile;
    }

    public final void resetInputs() {
        this._inputRelations = null;
    }

    public final void resetReplicates() {
        this._replicates = null;
    }

    public final void resetResults() {
        this._resultRelations = null;
    }

    public final void setContentEntity(@Nonnull ContentEntity content) {
        this._contentEntity = Optional.of(content);
    }

    public abstract void setDefinition(@Nonnull PointEntity var1);

    public final void setDropped(boolean dropped) {
        this._dropped = dropped;
    }

    public final void setOriginEntity(@Nonnull Optional<OriginEntity> originEntity) {
        this._originEntity = originEntity;
    }

    public final void setPermissionsEntity(@Nonnull Optional<PermissionsEntity> permissions) {
        this._permissionsEntity = permissions;
    }

    public final void setStoreEntity(@Nonnull Optional<StoreEntity> storeEntity) {
        this._storeEntity = storeEntity;
    }

    public final void setSyncEntity(@Nonnull Optional<SyncEntity> syncEntity) {
        this._syncEntity = syncEntity;
    }

    public final void setTransformEntity(@Nonnull TransformEntity transform) {
        this._transformEntity = Optional.of(transform);
    }

    @CheckReturnValue
    public final boolean setUp(@Nonnull Metadata metadata) {
        if (this._setUp) {
            return true;
        }
        if (this._contentEntity.isPresent()) {
            Proxied proxied;
            if (!this._contentEntity.get().setUp(metadata)) {
                return this._failed();
            }
            try {
                proxied = (Proxied)((Object)this.getContent().get().getInstance(this));
            }
            catch (ClassCastException exception) {
                this.getThisLogger().error(ServiceMessages.CONTENT_PROXIED, this._contentEntity.get().getName());
                return this._failed();
            }
            if (proxied == null) {
                return this._failed();
            }
            this._contentEntity = Optional.of((ContentEntity)this._contentEntity.get().getProxy(proxied));
        }
        if (!this.setUpStore(metadata)) {
            return this._failed();
        }
        if (this._transformEntity.isPresent()) {
            if (!this._transformEntity.get().setUp(metadata)) {
                return this._failed();
            }
            this._recalcLatest = (this.getParams().containsValueKey("RecalcLatest") ? this.getParams() : this._transformEntity.get().getParams()).getInt("RecalcLatest", -1);
        }
        if (this._syncEntity.isPresent() && !this._syncEntity.get().setUp()) {
            return this._failed();
        }
        this._volatile = this.getParams().getBoolean("Volatile");
        if (this.getParams().containsValueKey("NullRemoves")) {
            this._nullRemoves = this.getParams().getBoolean("NullRemoves");
        }
        this._setUp = true;
        return true;
    }

    @CheckReturnValue
    public final boolean setUpRelations(@Nonnull Metadata metadata) {
        if (this._transformEntity.isPresent()) {
            Transform transform = this._transformEntity.get().getTransform();
            Iterator<TransformEntity.Arg> args = this._transformEntity.get().getArgs().iterator();
            TransformEntity.Arg arg = null;
            if (transform == null) {
                return this._failed();
            }
            for (PointInput pointInput : this.getInputs()) {
                if (args.hasNext()) {
                    arg = args.next();
                } else if (arg != null && !arg.isMultiple() && !pointInput.isControl()) {
                    this.getThisLogger().warn(ServiceMessages.POINT_INPUTS_HIGH, this);
                    arg = null;
                }
                if (pointInput.setUp(metadata, Optional.ofNullable(arg))) continue;
                return this._failed();
            }
            if (args.hasNext() && !args.next().isMultiple()) {
                this.getThisLogger().warn(ServiceMessages.POINT_INPUTS_LOW, this);
            }
            for (PointInput pointInput : this.getInputs()) {
                if (pointInput.validate()) continue;
                return this._failed();
            }
            Optional<? extends Transform> proxiedTransform = transform.getInstance(this);
            if (!proxiedTransform.isPresent()) {
                return this._failed();
            }
            this._transformEntity = Optional.of((TransformEntity)this._transformEntity.get().getProxy(proxiedTransform.get()));
        }
        return true;
    }

    @CheckReturnValue
    public final boolean setUpStore(@Nonnull Metadata metadata) {
        if (this._storeEntity.isPresent()) {
            if (!this._storeEntity.get().setUp(metadata)) {
                return false;
            }
            Store storeInstance = this.getStore().orElse(null);
            if (storeInstance == null) {
                return false;
            }
            this._nullRemoves = storeInstance.isNullRemoves() || this.getParams().containsValueKey("NullRemoves") ? Boolean.valueOf(this.getParams().getBoolean("NullRemoves", true)) : null;
            this._storeEntity = Optional.of((StoreEntity)this._storeEntity.get().getProxy((Proxied)((Object)storeInstance)));
            storeInstance.bind(this);
        }
        return true;
    }

    public final void tearDown() {
        for (PointInput pointInput : this.getInputs()) {
            pointInput.tearDown();
        }
        if (this._syncEntity.isPresent()) {
            this._syncEntity.get().tearDown();
        }
        if (this._transformEntity.isPresent()) {
            this._transformEntity.get().tearDown();
        }
        this.tearDownStore();
        if (this._contentEntity.isPresent()) {
            this._contentEntity.get().tearDown();
        }
    }

    public final void tearDownStore() {
        if (this._storeEntity.isPresent()) {
            this._storeEntity.get().tearDown();
        }
    }

    public final boolean tidy() {
        if (this._tidied) {
            return true;
        }
        this._tidied = this._tidyInputRelations() && this._tidyReplicates();
        return this._tidied;
    }

    @Override
    public final String toString() {
        Optional<String> name = this.getName();
        if (name.isPresent()) {
            return name.get();
        }
        Optional<UUID> uuid = this.getUUID();
        return uuid.isPresent() ? uuid.get().toString() : "?";
    }

    private void _addResultRelation(PointInput resultRelation) {
        this.flagResultRelations();
        this._resultRelations.add(resultRelation);
    }

    private void _adjustLevel(int level) throws TopologicalErrorException {
        if (this._busy) {
            throw new TopologicalErrorException(this);
        }
        if (level > this._level) {
            this._level = level;
            this._busy = true;
            for (PointRelation pointRelation : this.getResults()) {
                PointEntity point = (PointEntity)pointRelation.getResultPoint();
                if (point == this) continue;
                point._adjustLevel(this._level + 1);
            }
            for (Point.Replicate replicate : this.getReplicates()) {
                if (replicate.getPoint() != this) continue;
                throw new TopologicalErrorException(this);
            }
            this._busy = false;
        }
    }

    private boolean _failed() {
        this.getThisLogger().error(ServiceMessages.POINT_SET_UP_FAILED, this);
        return false;
    }

    private boolean _tidyInputRelations() {
        if (this._inputRelations == null) {
            return true;
        }
        boolean success = true;
        Iterator<PointInput> iterator = this._inputRelations.iterator();
        while (iterator.hasNext()) {
            PointInput inputRelation = iterator.next();
            PointEntity inputPoint = inputRelation.getInputPointEntity();
            if (inputPoint.isDropped()) {
                iterator.remove();
                continue;
            }
            if (!inputPoint.isDefinition()) {
                if ((inputPoint = (PointEntity)inputPoint.getDefinition().orElse(null)) != null) {
                    inputRelation.setInputPoint(inputPoint);
                } else {
                    this.getThisLogger().error(ServiceMessages.POINT_INPUT_UNDEFINED, this, inputRelation.getInputPointEntity());
                    success = false;
                    continue;
                }
            }
            inputPoint._addResultRelation(inputRelation);
        }
        return success;
    }

    private boolean _tidyReplicates() {
        if (this._replicates == null) {
            return true;
        }
        boolean success = true;
        for (int i = 0; i < this._replicates.size(); ++i) {
            Point.Replicate replicate = this._replicates.get(i);
            PointEntity pointEntity = (PointEntity)replicate.getPoint();
            if (pointEntity.isDefinition()) continue;
            if ((pointEntity = (PointEntity)pointEntity.getDefinition().orElse(null)) != null) {
                this._replicates.set(i, new Point.Replicate(pointEntity, replicate.getConvert()));
                continue;
            }
            this.getThisLogger().error(ServiceMessages.POINT_REPLICATE_UNDEFINED, this, replicate.getPoint());
            success = false;
        }
        return success;
    }

    public static final class Reference
    extends PointEntity {
        private PointEntity _definition;

        public Reference() {
        }

        private Reference(Reference other) {
            super(other);
            this._definition = other._definition;
        }

        @Override
        public Reference copy() {
            return new Reference(this);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return super.equals(other);
        }

        @Override
        public Optional<PointEntity> getDefinition() {
            return Optional.ofNullable(this._definition);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean isDefinition() {
            return false;
        }

        @Override
        public void setDefinition(PointEntity definition) {
            this._definition = definition;
        }
    }

    public static final class Definition
    extends PointEntity {
        public Definition() {
        }

        private Definition(Definition other) {
            super(other);
        }

        @Override
        public Definition copy() {
            return new Definition(this);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return super.equals(other);
        }

        @Override
        public Optional<PointEntity> getDefinition() {
            return Optional.of(this);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean isDefinition() {
            return true;
        }

        @Override
        public void setDefinition(PointEntity definition) {
            Require.failure();
        }
    }
}

