/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.entity;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.Params;
import org.rvpf.base.Point;
import org.rvpf.base.PointRelation;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.sync.Sync;
import org.rvpf.base.tool.Require;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.BehaviorEntity;
import org.rvpf.metadata.entity.BehaviorEntityReference;
import org.rvpf.metadata.entity.PointEntity;
import org.rvpf.metadata.entity.SyncEntity;
import org.rvpf.metadata.entity.TransformEntity;
import org.rvpf.metadata.processor.Behavior;
import org.rvpf.service.ServiceMessages;

@NotThreadSafe
public final class PointInput
implements PointRelation {
    private static final Logger _LOGGER = Logger.getInstance(PointInput.class);
    private Optional<Behavior> _behavior;
    private boolean _control;
    private PointEntity _inputPoint;
    private Optional<Params> _params;
    private PointEntity _resultPoint;
    private Optional<SyncEntity> _syncEntity;
    private boolean _validated;

    public PointInput(@Nonnull PointInput original) {
        this._behavior = original._behavior;
        this._control = original._control;
        this._inputPoint = original._inputPoint;
        this._params = original._params;
        this._resultPoint = original._resultPoint;
        this._syncEntity = original._syncEntity;
        this._validated = original._validated;
    }

    public PointInput(@Nonnull PointEntity inputPoint, @Nonnull PointEntity resultPoint) {
        this._behavior = Optional.empty();
        this._inputPoint = Require.notNull(inputPoint);
        this._params = Optional.empty();
        this._resultPoint = Require.notNull(resultPoint);
        this._syncEntity = Optional.empty();
    }

    public void addBehaviorEntity(@Nonnull BehaviorEntity behaviorEntity) {
        this._addBehaviorEntity(behaviorEntity, false);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PointInput) {
            PointInput otherInput;
            UUID inputPointUUID = this.getInputPoint().getUUID().get();
            if (!inputPointUUID.equals((otherInput = (PointInput)other).getInputPoint().getUUID().get())) {
                return false;
            }
            UUID resultPointUUID = this.getResultPoint().getUUID().get();
            if (!resultPointUUID.equals(otherInput.getResultPoint().getUUID().get())) {
                return false;
            }
            if (!Objects.equals(this._behavior, otherInput._behavior)) {
                return false;
            }
            if (!Objects.equals(this._syncEntity, otherInput._syncEntity)) {
                return false;
            }
            return this.getParams().equals(otherInput.getParams());
        }
        return false;
    }

    @Override
    public Point getInputPoint() {
        return this._inputPoint;
    }

    @Nonnull
    @CheckReturnValue
    public PointEntity getInputPointEntity() {
        return this._inputPoint;
    }

    @Override
    public Params getParams() {
        return this._params.isPresent() ? this._params.get() : Params.EMPTY_PARAMS;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Behavior> getPrimaryBehavior() {
        return this._behavior;
    }

    @Override
    public Point getResultPoint() {
        return this._resultPoint;
    }

    @Nonnull
    @CheckReturnValue
    public PointEntity getResultPointEntity() {
        return this._resultPoint;
    }

    @Override
    public Optional<Sync> getSync() {
        return Optional.ofNullable(this._syncEntity.isPresent() ? this._syncEntity.get().getSync() : null);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<SyncEntity> getSyncEntity() {
        return this._syncEntity;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @CheckReturnValue
    public boolean isControl() {
        return this._control;
    }

    public void setControl(boolean control) {
        this._control = control;
    }

    public void setInputPoint(@Nonnull Point point) {
        this._inputPoint = Require.notNull((PointEntity)point);
    }

    public void setParams(@Nonnull Optional<Params> params) {
        this._params = params;
        if (this._params.isPresent()) {
            this._params.get().freeze();
        }
    }

    public void setResultPoint(@Nonnull Point point) {
        this._resultPoint = Require.notNull((PointEntity)point);
    }

    public void setSyncEntity(@Nonnull Optional<SyncEntity> syncEntity) {
        this._syncEntity = syncEntity;
    }

    @CheckReturnValue
    public boolean setUp(@Nonnull Metadata metadata, @Nonnull Optional<TransformEntity.Arg> arg) {
        Params argParams;
        if (this._syncEntity.isPresent() && !this._syncEntity.get().setUp()) {
            return false;
        }
        if (arg.isPresent() && !(argParams = arg.get().getParams()).isEmpty()) {
            if (!this._params.isPresent()) {
                this._params = Optional.of(new Params());
            }
            this._params.get().setDefaults(argParams);
            this._params.get().freeze();
        }
        if (this._resultPoint.getTransform().isPresent() && (!this._behavior.isPresent() || this._behavior.get() instanceof BehaviorEntityReference)) {
            Optional<BehaviorEntity> primaryBehaviorEntity;
            BehaviorEntityReference primaryBehaviorReference = null;
            if (this._behavior.isPresent()) {
                primaryBehaviorReference = this._primaryBehaviorReference(metadata);
                if (primaryBehaviorReference == null) {
                    return false;
                }
                if (!primaryBehaviorReference.isPrimary()) {
                    primaryBehaviorReference = null;
                }
            }
            if (primaryBehaviorReference == null && arg.isPresent()) {
                for (BehaviorEntity behavior : arg.get().getBehaviorEntities()) {
                    this._addBehaviorEntity(behavior, true);
                }
                if (this._behavior.isPresent()) {
                    primaryBehaviorReference = this._primaryBehaviorReference(metadata);
                    if (primaryBehaviorReference == null) {
                        return false;
                    }
                    if (!primaryBehaviorReference.isPrimary()) {
                        primaryBehaviorReference = null;
                    }
                }
            }
            if (primaryBehaviorReference == null && (primaryBehaviorEntity = this._resultPoint.getTransformEntity().get().getDefaultBehavior(this)).isPresent()) {
                this._addBehaviorEntity(primaryBehaviorEntity.get(), true);
                primaryBehaviorReference = this._primaryBehaviorReference(metadata);
                if (primaryBehaviorReference == null) {
                    return false;
                }
                if (!primaryBehaviorReference.isPrimary()) {
                    primaryBehaviorReference = null;
                }
            }
            if (primaryBehaviorReference == null) {
                _LOGGER.warn(ServiceMessages.NO_PRIMARY, this._resultPoint);
                return false;
            }
            this._behavior = Optional.ofNullable(((BehaviorEntityReference)this._behavior.get()).instantiate());
            if (!this._behavior.isPresent()) {
                return false;
            }
            this._validated = false;
        }
        return true;
    }

    public void tearDown() {
        if (this._syncEntity.isPresent()) {
            this._syncEntity.get().tearDown();
        }
        if (this._behavior.isPresent()) {
            this._behavior.get().tearDown();
        }
    }

    @CheckReturnValue
    boolean validate() {
        if (!this._validated && this._behavior.isPresent()) {
            this._validated = this._behavior.get().validate();
        }
        return this._validated;
    }

    private void _addBehaviorEntity(BehaviorEntity behaviorEntity, boolean inherited) {
        BehaviorEntityReference reference = new BehaviorEntityReference(this, behaviorEntity, inherited);
        if (this._behavior.isPresent()) {
            ((BehaviorEntityReference)this._behavior.get()).add(reference);
        } else {
            this._behavior = Optional.of(reference);
        }
    }

    private BehaviorEntityReference _primaryBehaviorReference(Metadata metadata) {
        if (!((BehaviorEntityReference)this._behavior.get()).setUp(metadata)) {
            return null;
        }
        BehaviorEntityReference primaryBehaviorReference = ((BehaviorEntityReference)this._behavior.get()).primary();
        if (primaryBehaviorReference == null) {
            return null;
        }
        if (primaryBehaviorReference.isPrimary() && this._behavior.get() != primaryBehaviorReference) {
            primaryBehaviorReference.add((BehaviorEntityReference)this._behavior.get());
            this._behavior = Optional.of(primaryBehaviorReference);
        }
        return primaryBehaviorReference;
    }
}

