/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.entity;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Params;
import org.rvpf.base.UUID;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.UndefinedEntityException;
import org.rvpf.config.entity.ClassDefEntity;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.Proxied;
import org.rvpf.metadata.Text;
import org.rvpf.metadata.entity.ParamsEntity;

public abstract class ProxyEntity
extends ParamsEntity {
    private final Optional<ClassDefEntity> _classDef;
    private Optional<Proxied> _instance;

    protected ProxyEntity(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, @Nonnull Optional<KeyedGroups> attributes, @Nonnull Optional<Map<String, Text>> texts, @Nonnull Optional<Params> params, @Nonnull Optional<ClassDefEntity> classDef, @Nonnull Optional<Proxied> instance) {
        super(name, uuid, attributes, texts, params);
        this._classDef = Require.notNull(classDef);
        this._instance = Require.notNull(instance);
    }

    public final void clearInstance() {
        this._instance = null;
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            ProxyEntity otherEntity = (ProxyEntity)other;
            return Objects.equals(this._classDef, otherEntity._classDef);
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<ClassDefEntity> getClassDef() {
        return this._classDef;
    }

    @Nonnull
    @CheckReturnValue
    public final ProxyEntity getProxy(@Nonnull Proxied instance) {
        ProxyEntity proxy;
        if (this._instance.isPresent() && instance == this._instance.get()) {
            proxy = this;
        } else {
            proxy = (ProxyEntity)this.copy();
            proxy.setInstance(instance);
        }
        return proxy;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @CheckReturnValue
    public final boolean is(Class<?> classObject) throws UndefinedEntityException {
        if (!this._classDef.isPresent()) {
            return false;
        }
        return this._classDef.get().is(classObject);
    }

    @CheckReturnValue
    public final boolean is(String className) throws UndefinedEntityException {
        if (!this._classDef.isPresent()) {
            return false;
        }
        return this._classDef.get().is(className);
    }

    public final void setInstance(@Nonnull Proxied instance) {
        this._instance = Optional.of(instance);
    }

    @CheckReturnValue
    public boolean setUp(@Nonnull Metadata metadata) {
        if (!this._instance.isPresent()) {
            Proxied instance = this._classDef.isPresent() ? this._classDef.get().createInstance(Proxied.class) : this.createDefaultInstance();
            if (instance == null || !instance.setUp(metadata, this)) {
                return false;
            }
            this.setInstance(instance);
        }
        return true;
    }

    public void tearDown() {
        if (this._instance.isPresent()) {
            this._instance.get().tearDown();
            this._instance = Optional.empty();
        }
    }

    @Nonnull
    @CheckReturnValue
    protected Proxied createDefaultInstance() {
        throw Require.failure();
    }

    @Nonnull
    @CheckReturnValue
    protected final Optional<? extends Proxied> getInstance() {
        return this._instance;
    }

    public static abstract class Builder
    extends ParamsEntity.Builder {
        private Optional<ClassDefEntity> _classDef = Optional.empty();
        private Optional<Proxied> _instance = Optional.empty();

        protected Builder() {
        }

        @Nonnull
        public Builder setClassDef(@Nonnull Optional<ClassDefEntity> classDef) {
            this._classDef = classDef;
            return this;
        }

        @Nonnull
        public Builder setInstance(@Nonnull Proxied instance) {
            this._instance = Optional.of(instance);
            return this;
        }

        @Nonnull
        protected Builder copyFrom(@Nonnull ProxyEntity entity) {
            super.copyFrom(entity);
            this._classDef = entity.getClassDef();
            return this;
        }

        protected Optional<ClassDefEntity> getClassDef() {
            return this._classDef;
        }

        protected Optional<Proxied> getInstance() {
            return this._instance;
        }
    }
}

