/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.entity;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Params;
import org.rvpf.base.UUID;
import org.rvpf.base.store.Store;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.IdentityHashSet;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.entity.ClassDefEntity;
import org.rvpf.metadata.Permissions;
import org.rvpf.metadata.Proxied;
import org.rvpf.metadata.Text;
import org.rvpf.metadata.entity.PermissionsEntity;
import org.rvpf.metadata.entity.PointEntity;
import org.rvpf.metadata.entity.ProxyEntity;
import org.rvpf.store.client.RMIStore;

public final class StoreEntity
extends ProxyEntity {
    public static final String ELEMENT_NAME = "Store";
    public static final String ENTITY_PREFIX = "S";
    public static final String ENTITY_REFERENCE_NAME = "store";
    private final Optional<? extends Permissions> _permissions;
    private final Set<PointEntity> _pointReferences;

    StoreEntity(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, @Nonnull Optional<KeyedGroups> attributes, @Nonnull Optional<Map<String, Text>> texts, @Nonnull Optional<Params> params, @Nonnull Optional<ClassDefEntity> classDef, @Nonnull Optional<Proxied> instance, @Nonnull Optional<? extends Permissions> permissions, @Nonnull Set<PointEntity> pointReferences) {
        super(name, uuid, attributes, texts, params, classDef, instance);
        this._permissions = Require.notNull(permissions);
        this._pointReferences = Require.notNull(pointReferences);
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @CheckReturnValue
    public boolean addPointReference(@Nonnull PointEntity pointEntity) {
        return this._pointReferences.add(pointEntity);
    }

    @Override
    public StoreEntity copy() {
        return StoreEntity.newBuilder().copyFrom(this).build();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (super.equals(other)) {
            StoreEntity otherStore = (StoreEntity)other;
            return Objects.equals(this._permissions, otherStore._permissions);
        }
        return false;
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<? extends Permissions> getPermissions() {
        return this._permissions;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<PermissionsEntity> getPermissionsEntity() {
        return this._permissions;
    }

    @Nonnull
    @CheckReturnValue
    public Set<PointEntity> getPointReferences() {
        return this._pointReferences;
    }

    @Override
    public String getPrefix() {
        return ENTITY_PREFIX;
    }

    @Override
    public String getReferenceName() {
        return ENTITY_REFERENCE_NAME;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<? extends Store> getStore() {
        return this.getInstance();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected Proxied createDefaultInstance() {
        return new RMIStore();
    }

    public static class Builder
    extends ProxyEntity.Builder {
        private Optional<? extends Permissions> _permissions = Optional.empty();
        private Set<PointEntity> _pointReferences;

        @Override
        public StoreEntity build() {
            StoreEntity storeEntity = new StoreEntity(this.getName(), this.getUUID(), this.getAttributes(), this.getTexts(), this.getParams(), this.getClassDef(), this.getInstance(), this._permissions, this._pointReferences != null ? this._pointReferences : new IdentityHashSet<PointEntity>());
            this._pointReferences = null;
            return storeEntity;
        }

        public Builder setPermissions(@Nonnull Optional<Permissions> permissions) {
            this._permissions = permissions;
            return this;
        }

        @Nonnull
        protected Builder copyFrom(@Nonnull StoreEntity storeEntity) {
            super.copyFrom(storeEntity);
            this._permissions = storeEntity.getPermissions();
            this._pointReferences = new IdentityHashSet<PointEntity>(storeEntity.getPointReferences());
            return this;
        }
    }
}

