/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.entity;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Params;
import org.rvpf.base.UUID;
import org.rvpf.base.sync.Sync;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.entity.ClassDefEntity;
import org.rvpf.metadata.Text;
import org.rvpf.metadata.entity.ParamsEntity;

public final class SyncEntity
extends ParamsEntity {
    public static final String ELEMENT_NAME = "Sync";
    public static final String ENTITY_PREFIX = "V";
    public static final String ENTITY_REFERENCE_NAME = "sync";
    private ClassDefEntity _classDef;
    private Optional<Sync> _sync;

    protected SyncEntity(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, @Nonnull Optional<KeyedGroups> attributes, @Nonnull Optional<Map<String, Text>> texts, @Nonnull Optional<Params> params, @Nonnull ClassDefEntity classDef, @Nonnull Optional<Sync> sync) {
        super(name, uuid, attributes, texts, params);
        this._classDef = Require.notNull(classDef);
        this._sync = Require.notNull(sync);
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public SyncEntity copy() {
        return SyncEntity.newBuilder().copyFrom(this).build();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return super.equals(other);
    }

    @Nonnull
    @CheckReturnValue
    public ClassDefEntity getClassDef() {
        return Require.notNull(this._classDef);
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public String getPrefix() {
        return ENTITY_PREFIX;
    }

    @Override
    public String getReferenceName() {
        return ENTITY_REFERENCE_NAME;
    }

    @Nonnull
    @CheckReturnValue
    public Sync getSync() {
        return this._sync.get().copy();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @CheckReturnValue
    public boolean setUp() {
        if (!this._sync.isPresent()) {
            this._sync = Optional.ofNullable(this.getClassDef().createInstance(Sync.class));
            if (!this._sync.isPresent()) {
                return false;
            }
            if (this._sync.get() instanceof Sync.Abstract && !((Sync.Abstract)this._sync.get()).setUp(this.getParams())) {
                return false;
            }
        }
        return true;
    }

    public void tearDown() {
        if (this._sync.isPresent()) {
            if (this._sync.get() instanceof Sync.Abstract) {
                ((Sync.Abstract)this._sync.get()).tearDown();
            }
            this._sync = Optional.empty();
        }
    }

    public static final class Builder
    extends ParamsEntity.Builder {
        private ClassDefEntity _classDef;
        private Sync _sync;

        Builder() {
        }

        @Override
        public SyncEntity build() {
            return new SyncEntity(this.getName(), this.getUUID(), this.getAttributes(), this.getTexts(), this.getParams(), Require.notNull(this._classDef), Optional.ofNullable(this._sync));
        }

        @Nonnull
        public Builder setClassDef(@Nonnull ClassDefEntity classDef) {
            this._classDef = Require.notNull(classDef);
            return this;
        }

        @Nonnull
        protected Builder copyFrom(@Nonnull SyncEntity syncEntity) {
            super.copyFrom(syncEntity);
            this._classDef = syncEntity.getClassDef();
            this._sync = syncEntity.getSync();
            return this;
        }
    }
}

