/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.entity;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.Params;
import org.rvpf.base.PointRelation;
import org.rvpf.base.UUID;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.entity.ClassDefEntity;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.Proxied;
import org.rvpf.metadata.Text;
import org.rvpf.metadata.entity.BehaviorEntity;
import org.rvpf.metadata.entity.ContentEntity;
import org.rvpf.metadata.entity.EngineEntity;
import org.rvpf.metadata.entity.ProxyEntity;
import org.rvpf.metadata.entity.SyncEntity;
import org.rvpf.metadata.processor.Engine;
import org.rvpf.metadata.processor.Transform;

public final class TransformEntity
extends ProxyEntity {
    public static final String ELEMENT_NAME = "Transform";
    public static final String ENTITY_PREFIX = "T";
    public static final String ENTITY_REFERENCE_NAME = "transform";
    private final List<Arg> _args;
    private final Optional<EngineEntity> _engineEntity;

    protected TransformEntity(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, @Nonnull Optional<KeyedGroups> attributes, @Nonnull Optional<Map<String, Text>> texts, @Nonnull Optional<Params> params, @Nonnull Optional<ClassDefEntity> classDef, @Nonnull Optional<Proxied> instance, @Nonnull Optional<EngineEntity> engineEntity, @Nonnull List<Arg> args) {
        super(name, uuid, attributes, texts, params, classDef, instance);
        this._engineEntity = Require.notNull(engineEntity);
        this._args = Require.notNull(args);
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public TransformEntity copy() {
        return TransformEntity.newBuilder().copyFrom(this).build();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (super.equals(other)) {
            TransformEntity otherTransform = (TransformEntity)other;
            if (!Objects.equals(this._args, otherTransform._args)) {
                return false;
            }
            return this.getEngineEntity().equals(otherTransform.getEngineEntity());
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public List<Arg> getArgs() {
        return this._args;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<BehaviorEntity> getDefaultBehavior(PointRelation relation) {
        Engine engine = (Engine)this.getEngineEntity().get().getInstance().get();
        return engine.getDefaultBehavior(relation);
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<EngineEntity> getEngineEntity() {
        return this._engineEntity;
    }

    @Override
    public String getPrefix() {
        return ENTITY_PREFIX;
    }

    @Override
    public String getReferenceName() {
        return ENTITY_REFERENCE_NAME;
    }

    @Nullable
    @CheckReturnValue
    public Transform getTransform() {
        Transform transform = this.getInstance().orElse(null);
        if (transform == null) {
            Engine engine = (Engine)this.getEngineEntity().get().getInstance().get();
            transform = engine.createTransform(this);
            if (transform != null) {
                this.setInstance(transform);
            } else {
                this.clearInstance();
            }
        }
        return transform;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean setUp(Metadata metadata) {
        return this._engineEntity.get().setUp(metadata);
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this._engineEntity.get().tearDown();
    }

    List<Arg> _getArgs() {
        return this._args;
    }

    public static final class Builder
    extends ProxyEntity.Builder {
        private List<Arg> _args = new LinkedList<Arg>();
        private Optional<EngineEntity> _engineEntity = Optional.empty();

        Builder() {
        }

        @Nonnull
        public Builder addArg(@Nonnull Arg arg) {
            this._args.add(arg);
            return this;
        }

        @Override
        public TransformEntity build() {
            return new TransformEntity(this.getName(), this.getUUID(), this.getAttributes(), this.getTexts(), this.getParams(), this.getClassDef(), this.getInstance(), this._engineEntity, this._args);
        }

        @Nonnull
        public Builder copyFrom(@Nonnull TransformEntity entity) {
            super.copyFrom(entity);
            this._engineEntity = entity.getEngineEntity();
            this._args = entity._getArgs();
            return this;
        }

        @Nonnull
        public Builder setEngineEntity(@Nonnull Optional<EngineEntity> engineEntity) {
            this._engineEntity = engineEntity;
            return this;
        }
    }

    public static class Arg {
        private final List<BehaviorEntity> _behaviorEntities;
        private final Optional<ContentEntity> _contentEntity;
        private final boolean _multiple;
        private final Optional<Params> _params;
        private final Optional<SyncEntity> _syncEntity;

        Arg(@Nonnull List<BehaviorEntity> behaviorEntities, @Nonnull Optional<ContentEntity> contentEntity, @Nonnull Optional<SyncEntity> syncEntity, boolean multiple, @Nonnull Optional<Params> params) {
            this._behaviorEntities = behaviorEntities;
            this._contentEntity = contentEntity;
            this._syncEntity = syncEntity;
            this._multiple = multiple;
            this._params = params;
        }

        @Nonnull
        @CheckReturnValue
        public static Builder newBuilder() {
            return new Builder();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Arg) {
                Arg otherArg = (Arg)other;
                if (!this.getBehaviorEntities().equals(otherArg.getBehaviorEntities())) {
                    return false;
                }
                if (!this._contentEntity.equals(otherArg._contentEntity)) {
                    return false;
                }
                if (!this._syncEntity.equals(otherArg._syncEntity)) {
                    return false;
                }
                if (!this.getParams().equals(otherArg.getParams())) {
                    return false;
                }
                return this._multiple == otherArg._multiple;
            }
            return false;
        }

        @Nonnull
        @CheckReturnValue
        public List<BehaviorEntity> getBehaviorEntities() {
            return this._behaviorEntities != null ? this._behaviorEntities : Collections.emptyList();
        }

        @Nonnull
        @CheckReturnValue
        public Optional<ContentEntity> getContentEntity() {
            return this._contentEntity;
        }

        @Nonnull
        @CheckReturnValue
        public Params getParams() {
            return this._params.isPresent() ? this._params.get() : Params.EMPTY_PARAMS;
        }

        @Nonnull
        @CheckReturnValue
        public Optional<SyncEntity> getSyncEntity() {
            return this._syncEntity;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        @CheckReturnValue
        public boolean isMultiple() {
            return this._multiple;
        }

        public static final class Builder {
            private List<BehaviorEntity> _behaviorEntities;
            private ContentEntity _contentEntity;
            private boolean _multiple;
            private Optional<Params> _params = Optional.empty();
            private SyncEntity _syncEntity;

            @Nonnull
            public Builder addBehaviorEntity(BehaviorEntity behaviorEntity) {
                if (this._behaviorEntities == null) {
                    this._behaviorEntities = new LinkedList<BehaviorEntity>();
                }
                this._behaviorEntities.add(behaviorEntity);
                return this;
            }

            @Nonnull
            public Arg build() {
                return new Arg(this._behaviorEntities != null ? this._behaviorEntities : Collections.emptyList(), Optional.ofNullable(this._contentEntity), Optional.ofNullable(this._syncEntity), this._multiple, this._params);
            }

            @Nonnull
            public Builder setContentEntity(@Nonnull ContentEntity contentEntity) {
                this._contentEntity = contentEntity;
                return this;
            }

            @Nonnull
            public Builder setMultiple(boolean multiple) {
                this._multiple = multiple;
                return this;
            }

            @Nonnull
            public Builder setParams(@Nonnull Optional<Params> params) {
                this._params = params;
                return this;
            }

            @Nonnull
            public Builder setSyncEntity(@Nonnull SyncEntity syncEntity) {
                this._syncEntity = syncEntity;
                return this;
            }
        }
    }
}

