/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.metadata.processor;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.PointValuesQuery;
import org.rvpf.base.TimeInterval;
import org.rvpf.base.sync.Sync;

@Immutable
public final class BatchValuesQuery
extends PointValuesQuery.Abstract {
    private final boolean _extrapolated;
    private final boolean _interpolated;
    private final boolean _notNull;

    BatchValuesQuery(@Nonnull Optional<Point> point, @Nonnull TimeInterval interval, @Nonnull Optional<Sync> sync, boolean notNull, boolean interpolated, boolean extrapolated) {
        super(point, interval, sync);
        this._notNull = notNull;
        this._interpolated = interpolated;
        this._extrapolated = extrapolated;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean isExtrapolated() {
        return this._extrapolated;
    }

    @Override
    public boolean isInterpolated() {
        return this._interpolated;
    }

    @Override
    public boolean isNotNull() {
        return this._notNull;
    }

    @Override
    public boolean isPolated() {
        return this._interpolated || this._extrapolated;
    }

    @NotThreadSafe
    public static final class Builder {
        private boolean _extrapolated;
        private boolean _interpolated;
        private final TimeInterval.Builder _intervalBuilder = TimeInterval.newBuilder();
        private boolean _notNull;
        private Point _point;
        private Sync _sync;

        Builder() {
        }

        @Nonnull
        @CheckReturnValue
        public BatchValuesQuery build() {
            return new BatchValuesQuery(Optional.ofNullable(this._point), this._intervalBuilder.build(), Optional.ofNullable(this._sync), this._notNull, this._interpolated, this._extrapolated);
        }

        @Nonnull
        public Builder copyFrom(@Nonnull BatchValuesQuery batchValueQuery) {
            this._point = batchValueQuery.getPoint().orElse(null);
            this._intervalBuilder.copyFrom(batchValueQuery.getInterval());
            this._sync = batchValueQuery.getSync().orElse(null);
            this._notNull = batchValueQuery.isNotNull();
            this._interpolated = batchValueQuery.isInterpolated();
            this._extrapolated = batchValueQuery.isExtrapolated();
            return this;
        }

        @Nonnull
        public Builder setAfter(@Nonnull DateTime after) {
            this._intervalBuilder.setAfter(after);
            return this;
        }

        @Nonnull
        public Builder setAt(@Nonnull DateTime at) {
            this._intervalBuilder.setAt(at);
            return this;
        }

        @Nonnull
        public Builder setBefore(@Nonnull DateTime before) {
            this._intervalBuilder.setBefore(before);
            return this;
        }

        @Nonnull
        public Builder setExtrapolated(boolean extrapolated) {
            this._extrapolated = extrapolated;
            return this;
        }

        @Nonnull
        public Builder setInterpolated(boolean interpolated) {
            this._interpolated = interpolated;
            return this;
        }

        @Nonnull
        public Builder setInterval(@Nonnull TimeInterval interval) {
            this._intervalBuilder.setAfter(interval.getAfter().orElse(null));
            this._intervalBuilder.setBefore(interval.getBefore().orElse(null));
            return this;
        }

        @Nonnull
        public Builder setInterval(@Nonnull TimeInterval.Builder intervalBuilder) {
            return this.setInterval(intervalBuilder.build());
        }

        @Nonnull
        public Builder setNotAfter(@Nonnull DateTime notAfter) {
            this._intervalBuilder.setNotAfter(notAfter);
            return this;
        }

        @Nonnull
        public Builder setNotBefore(@Nonnull DateTime notBefore) {
            this._intervalBuilder.setNotBefore(notBefore);
            return this;
        }

        @Nonnull
        public final Builder setNotNull(boolean notNull) {
            this._notNull = notNull;
            return this;
        }

        @Nonnull
        public Builder setPoint(@Nonnull Optional<Point> point) {
            this._point = point.orElse(null);
            return this;
        }

        @Nonnull
        public Builder setSync(@Nonnull Optional<Sync> sync) {
            this._sync = sync.orElse(null);
            return this;
        }
    }
}

