/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ThreadExecutor;

public final class ScriptEngineDriver {
    public static final String DEFAULT_ENGINE_NAME = "ECMAScript";
    private static final Logger _LOGGER = Logger.getInstance(ScriptEngineDriver.class);
    private Future<?> _asyncTask;
    private Bindings _bindings = new SimpleBindings();
    private final ScriptEngine _engine;
    private final _ScriptThreadExecutor _executor = new _ScriptThreadExecutor();

    private ScriptEngineDriver(ScriptEngine engine) {
        ScriptEngineFactory engineFactory = engine.getFactory();
        _LOGGER.info(ServiceMessages.SCRIPT_ENGINE, engineFactory.getEngineName(), engineFactory.getNames(), engineFactory.getEngineVersion());
        _LOGGER.info(ServiceMessages.SCRIPT_LANGUAGE, engineFactory.getLanguageName(), engineFactory.getLanguageVersion());
        this._engine = engine;
    }

    @Nullable
    @CheckReturnValue
    public static ScriptEngineDriver newInstance(@Nonnull Optional<String> optionalEngineName) {
        ScriptEngineManager engineManager = new ScriptEngineManager();
        String engineName = optionalEngineName.orElse(DEFAULT_ENGINE_NAME);
        ScriptEngine engine = engineManager.getEngineByName(engineName);
        if (engine == null) {
            _LOGGER.error(ServiceMessages.SCRIPT_ENGINE_UNKNOWN, engineName);
            return null;
        }
        return new ScriptEngineDriver(engine);
    }

    public synchronized void bind(@Nonnull Map<String, Object> bindings) {
        this._bindings.putAll((Map<? extends String, ? extends Object>)bindings);
    }

    public synchronized void bind(@Nonnull String key, @Nonnull Object value) {
        this._bindings.put(key, value);
    }

    @Nonnull
    @CheckReturnValue
    public synchronized Optional<Object> bound(@Nonnull String key) {
        return Optional.ofNullable(this._bindings.get(key));
    }

    @Nonnull
    @CheckReturnValue
    public ScriptEngineFactory getEngineFactory() {
        return this._engine.getFactory();
    }

    @CheckReturnValue
    public boolean isRunning() {
        return !this._executor.isShutdown();
    }

    public void start(@Nonnull String threadName) {
        this._executor.reset(Optional.of(threadName), true);
        this._executor.startThread();
    }

    public void stop() {
        this._executor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public boolean submit(@Nonnull Task task) {
        Future<?> future;
        ScriptEngineDriver scriptEngineDriver = this;
        synchronized (scriptEngineDriver) {
            if (this._asyncTask != null) {
                if (this._asyncTask.cancel(true)) {
                    _LOGGER.warn(ServiceMessages.SCRIPT_CANCELLED, new Object[0]);
                }
                this._asyncTask = null;
            }
        }
        try {
            future = this._executor.submit(() -> task.execute(this));
        }
        catch (RejectedExecutionException exception) {
            return false;
        }
        if (task.isAsync()) {
            ScriptEngineDriver exception = this;
            synchronized (exception) {
                this._asyncTask = future;
            }
        }
        try {
            future.get();
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException exception) {
            throw new RuntimeException(exception);
        }
        return true;
    }

    public synchronized void unbind(@Nonnull Map<String, Object> bindings) {
        this._bindings.clear();
    }

    public synchronized void unbind(@Nonnull String key) {
        this._bindings.remove(key);
    }

    @Nonnull
    @CheckReturnValue
    Optional<Object> _compile(@Nonnull Object scriptObject) throws ScriptException {
        if (!(this._engine instanceof Compilable)) {
            return Optional.empty();
        }
        if (scriptObject instanceof File) {
            scriptObject = ScriptEngineDriver._newScriptReader((File)scriptObject);
        }
        CompiledScript compiled = scriptObject instanceof Reader ? ((Compilable)((Object)this._engine)).compile((Reader)scriptObject) : ((Compilable)((Object)this._engine)).compile(String.valueOf(scriptObject));
        return Optional.of(compiled);
    }

    void _eval(@Nonnull Object scriptObject) throws ScriptException {
        if (scriptObject instanceof CompiledScript) {
            ((CompiledScript)scriptObject).eval();
        } else {
            if (scriptObject instanceof File) {
                scriptObject = ScriptEngineDriver._newScriptReader((File)scriptObject);
            }
            if (scriptObject instanceof Reader) {
                this._engine.eval((Reader)scriptObject);
            } else {
                this._engine.eval(String.valueOf(scriptObject));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _updateContext() {
        Bindings bindings;
        ScriptContext context = this._engine.getContext();
        if (context == null) {
            context = new SimpleScriptContext();
            this._engine.setContext(context);
        }
        if ((bindings = context.getBindings(100)) == null) {
            bindings = this._engine.createBindings();
            context.setBindings(bindings, 100);
        }
        ScriptEngineDriver scriptEngineDriver = this;
        synchronized (scriptEngineDriver) {
            bindings.putAll(this._bindings);
            this._bindings = bindings;
        }
    }

    private static Reader _newScriptReader(File scriptFile) {
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(scriptFile), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }

    private class _ScriptThreadExecutor
    extends ThreadExecutor {
        _ScriptThreadExecutor() {
            super(Optional.empty());
        }

        @Override
        public void run() {
            ScriptEngineDriver.this._updateContext();
            super.run();
        }
    }

    public static abstract class Task {
        protected void execute(@Nonnull ScriptEngineDriver driver) {
        }

        @CheckReturnValue
        protected boolean isAsync() {
            return false;
        }
    }

    public static final class ExecuteException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        ExecuteException(@Nonnull Throwable cause) {
            super(cause);
        }
    }

    public static class EvalTask
    extends Task {
        private final Object _scriptObject;

        public EvalTask(@Nonnull Object scriptObject) {
            this._scriptObject = Require.notNull(scriptObject);
        }

        @Override
        protected void execute(ScriptEngineDriver driver) {
            try {
                driver._eval(this._scriptObject);
            }
            catch (ScriptException exception) {
                throw new ExecuteException(exception);
            }
        }
    }

    public static class CompileTask
    extends Task {
        private Optional<Object> _compiled = Optional.empty();
        private final Object _scriptObject;

        public CompileTask(@Nonnull Object scriptObject) {
            this._scriptObject = Require.notNull(scriptObject);
        }

        @Nonnull
        @CheckReturnValue
        public Optional<Object> getCompiled() {
            return this._compiled;
        }

        @Override
        protected void execute(ScriptEngineDriver driver) {
            try {
                this._compiled = driver._compile(this._scriptObject);
            }
            catch (ScriptException exception) {
                throw new ExecuteException(exception);
            }
        }
    }
}

