/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.script;

import java.io.File;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.script.ScriptEngineDriver;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;
import org.rvpf.service.app.ServiceAppImpl;

public final class ScriptServiceAppImpl
extends ServiceAppImpl
implements ServiceThread.Target {
    public static final String CONFIG_ATTRIBUTE = "CONFIG";
    public static final int DEFAULT_INTERRUPT_DELAY = 60000;
    public static final String ENGINE_NAME_PROPERTY = "engine.name";
    public static final String ENGINE_VERSION_PROPERTY = "engine.version";
    public static final String RUN_FILE_PROPERTY = "file.run";
    public static final String RUN_TEXT_PROPERTY = "text.run";
    public static final String SERVICE_PROPERTIES = "script.service";
    public static final String START_FILE_PROPERTY = "file.start";
    public static final String START_TEXT_PROPERTY = "text.start";
    public static final String STOP_TEXT_PROPERTY = "text.stop";
    private volatile ScriptEngineDriver _engineDriver;
    private File _runFile;
    private String _runText;
    private File _startFile;
    private String _startText;
    private String _stopText;
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();

    @Override
    public void run() {
        if (this._runFile != null && !this._eval(this._runFile, this._runText != null || this._stopText != null)) {
            this.getService().fail();
        }
        if (this._runText != null && !this._eval(this._runText, this._stopText != null)) {
            this.getService().fail();
        }
    }

    @Override
    public boolean setUp(Service service) {
        if (!super.setUp(service)) {
            return false;
        }
        Config config = service.getConfig();
        KeyedGroups serviceProperties = config.getPropertiesGroup(SERVICE_PROPERTIES);
        Optional<String> engineName = serviceProperties.getString(ENGINE_NAME_PROPERTY);
        Optional<String> startFileName = serviceProperties.getString(START_FILE_PROPERTY);
        Optional<String> runFileName = serviceProperties.getString(RUN_FILE_PROPERTY);
        this._startFile = startFileName.isPresent() ? new File(startFileName.get()) : null;
        this._startText = serviceProperties.getString(START_TEXT_PROPERTY).orElse(null);
        this._runFile = runFileName.isPresent() ? new File(runFileName.get()) : null;
        this._runText = serviceProperties.getString(RUN_TEXT_PROPERTY).orElse(null);
        this._stopText = serviceProperties.getString(STOP_TEXT_PROPERTY).orElse(null);
        if (this.getThisLogger().isDebugEnabled()) {
            if (this._startFile != null) {
                this.getThisLogger().debug(ServiceMessages.SCRIPT_START_FILE, this._startFile.getAbsolutePath());
            }
            if (this._startText != null) {
                this.getThisLogger().debug(ServiceMessages.SCRIPT_START_TEXT, this._startText);
            }
            if (this._runFile != null) {
                this.getThisLogger().debug(ServiceMessages.SCRIPT_RUN_FILE, this._runFile.getAbsolutePath());
            }
            if (this._runText != null) {
                this.getThisLogger().debug(ServiceMessages.SCRIPT_RUN_TEXT, this._runText);
            }
            if (this._stopText != null) {
                this.getThisLogger().debug(ServiceMessages.SCRIPT_STOP_TEXT, this._stopText);
            }
        }
        if (this._startFile != null && !this._startFile.exists()) {
            this.getThisLogger().error(ServiceMessages.SCRIPT_START_FILE_UNKNOWN, startFileName);
            return false;
        }
        if (this._runFile != null && !this._runFile.exists()) {
            this.getThisLogger().error(ServiceMessages.SCRIPT_RUN_FILE_UNKNOWN, runFileName);
            return false;
        }
        this._engineDriver = ScriptEngineDriver.newInstance(engineName);
        if (this._engineDriver == null) {
            return false;
        }
        this._engineDriver.bind(CONFIG_ATTRIBUTE, config);
        this._engineDriver.bind(ENGINE_VERSION_PROPERTY, this._engineDriver.getEngineFactory().getEngineVersion());
        return true;
    }

    @Override
    public void start() {
        ServiceThread thread;
        String serviceName = this.getService().getServiceName();
        this._engineDriver.start("Script driver for [" + serviceName + "]");
        if (this._startFile != null && !this._eval(this._startFile, true)) {
            this.getService().fail();
        }
        if (this._startText != null && !this._eval(this._startText, true)) {
            this.getService().fail();
        }
        if ((this._runFile != null || this._runText != null) && this._thread.compareAndSet(null, thread = new ServiceThread(this, "Script service"))) {
            this.getThisLogger().debug(ServiceMessages.STARTING_THREAD, thread.getName());
            thread.start();
        }
    }

    @Override
    public void stop() {
        ServiceThread thread;
        if (this._engineDriver.isRunning()) {
            if (this._stopText != null) {
                this._eval(this._stopText, true);
            }
            this._engineDriver.stop();
        }
        if ((thread = (ServiceThread)this._thread.getAndSet(null)) != null) {
            this.getThisLogger().debug(ServiceMessages.STOPPING_THREAD, thread.getName());
            thread.interrupt();
            Require.ignored(thread.join(this.getThisLogger(), this.getService().getJoinTimeout()));
        }
    }

    @Override
    public void tearDown() {
        this._engineDriver = null;
        super.tearDown();
    }

    private boolean _eval(@Nonnull Object scriptObject, boolean wait) {
        ScriptEngineDriver engineDriver = this._engineDriver;
        if (engineDriver == null) {
            return false;
        }
        _EvalTask task = new _EvalTask(scriptObject, wait);
        if (!engineDriver.submit(task)) {
            if (Thread.currentThread().isInterrupted()) {
                this.getThisLogger().debug(ServiceMessages.SCRIPT_EVAL_INTERRUPTED, scriptObject);
            }
            return false;
        }
        return true;
    }

    private static final class _EvalTask
    extends ScriptEngineDriver.EvalTask {
        private final boolean _wait;

        _EvalTask(@Nonnull Object scriptObject, boolean wait) {
            super(scriptObject);
            this._wait = wait;
        }

        @Override
        protected boolean isAsync() {
            return !this._wait;
        }
    }
}

