/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.ClassDef;
import org.rvpf.base.ClassDefImpl;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.alert.Alert;
import org.rvpf.base.alert.Event;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.Listeners;
import org.rvpf.config.Config;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.som.SOMAlerter;

public interface Alerter {
    @CheckReturnValue
    public boolean addListener(@Nonnull Listener var1);

    @Nonnull
    @CheckReturnValue
    public Optional<Alerter> getActiveInstance();

    @CheckReturnValue
    public boolean isEmbedded();

    @CheckReturnValue
    public boolean isRunning();

    @CheckReturnValue
    public boolean isShared();

    @CheckReturnValue
    public boolean isStealth();

    @CheckReturnValue
    public boolean removeListener(@Nonnull Listener var1);

    public void send(@Nonnull Alert var1) throws InterruptedException, ServiceNotAvailableException;

    @CheckReturnValue
    public boolean setUp(@Nonnull Config var1, @Nonnull KeyedGroups var2, @Nonnull Thread.UncaughtExceptionHandler var3);

    public void start() throws InterruptedException;

    public void stop();

    public void tearDown();

    public static class SharedContext {
        private final AtomicInteger _holders = new AtomicInteger();
        private volatile Optional<Alerter> _sharedAlerter = Optional.empty();

        @Nonnull
        @CheckReturnValue
        public AtomicInteger getHolders() {
            return this._holders;
        }

        @Nonnull
        @CheckReturnValue
        public Optional<Alerter> getSharedAlerter() {
            return this._sharedAlerter;
        }

        public void setSharedAlerter(@Nonnull Optional<Alerter> sharedAlerter) {
            this._sharedAlerter = sharedAlerter;
        }
    }

    @ThreadSafe
    public static final class Factory {
        public static final String ALERTER_CLASS_PROPERTY = "alerter.class";
        public static final ClassDef DEFAULT_ALERTER_CLASS = new ClassDefImpl(SOMAlerter.class);
        public static final String SERVICE_ALERTER_PROPERTIES = "service.alerter";

        private Factory() {
        }

        @Nullable
        @CheckReturnValue
        public static Alerter getAnAlerter(@Nonnull Config config, @Nonnull Thread.UncaughtExceptionHandler owner) {
            KeyedGroups alerterProperties = config.getPropertiesGroup(SERVICE_ALERTER_PROPERTIES);
            ClassDef classDef = alerterProperties.getClassDef(ALERTER_CLASS_PROPERTY, DEFAULT_ALERTER_CLASS);
            Alerter alerter = classDef.createInstance(Alerter.class);
            if (alerter == null || !alerter.setUp(config, alerterProperties, owner)) {
                return null;
            }
            return alerter.getActiveInstance().orElse(null);
        }
    }

    @ThreadSafe
    public static abstract class Abstract
    implements Alerter {
        public static final String CONNECTION_RETRY_DELAY_PROPERTY = "connection.retry.delay";
        public static final ElapsedTime DEFAULT_CONNECTION_RETRY_DELAY = ElapsedTime.fromMillis(15000L);
        public static final ElapsedTime DEFAULT_WATCHDOG_PERIOD = ElapsedTime.fromMillis(60000L);
        public static final ElapsedTime DEFAULT_WATCHDOG_TRIGGER = ElapsedTime.fromMillis(300000L);
        public static final String EMBEDDED_PROPERTY = "embedded";
        public static final String SHARED_PROPERTY = "shared";
        public static final String STEALTH_PROPERTY = "stealth";
        public static final String WATCHDOG_PERIOD_PROPERTY = "watchdog.period";
        public static final String WATCHDOG_TRIGGER_PROPERTY = "watchdog.trigger";
        private KeyedGroups _alerterProperties;
        private volatile Config _config;
        private final Listeners<Listener> _listeners = new Listeners();
        private final Logger _logger = Logger.getInstance(this.getClass());
        private boolean _midnightEnabled;
        private final AtomicReference<_MidnightEvent> _midnightEvent = new AtomicReference();
        private Object _owner;
        private volatile Optional<Service> _service;
        private boolean _shared;
        private final SharedContext _sharedContext = this.sharedContext();
        private boolean _stealth;
        private volatile _Watchdog _watchdog;

        protected Abstract() {
        }

        @Override
        public final boolean addListener(Listener listener) {
            return this._listeners.add(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Optional<Alerter> getActiveInstance() {
            Class<Alerter> clazz = Alerter.class;
            synchronized (Alerter.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this._shared ? this._sharedContext.getSharedAlerter() : Optional.of(this);
            }
        }

        @Nonnull
        @CheckReturnValue
        public final KeyedGroups getAlerterProperties() {
            return Require.notNull(this._alerterProperties);
        }

        @Nonnull
        @CheckReturnValue
        public final Config getConfig() {
            return Require.notNull(this._config);
        }

        @Nonnull
        @CheckReturnValue
        public final KeyedGroups getConfigProperties() {
            return this.getConfig().getProperties();
        }

        @Nonnull
        @CheckReturnValue
        public final Object getOwner() {
            return Require.notNull(this._owner);
        }

        @Nonnull
        @CheckReturnValue
        public final Optional<Service> getService() {
            return this._service;
        }

        @Nonnull
        @CheckReturnValue
        public final Logger getThisLogger() {
            return this._logger;
        }

        @Override
        public boolean isEmbedded() {
            return false;
        }

        @Override
        public final boolean isShared() {
            return this._shared;
        }

        @Override
        public boolean isStealth() {
            return this._stealth;
        }

        @Override
        public final boolean removeListener(Listener listener) {
            return this._listeners.remove(listener);
        }

        @Override
        public final void send(Alert alert) throws InterruptedException, ServiceNotAvailableException {
            Require.notNull(alert);
            if (!this.isStealth() || !(alert instanceof Event)) {
                this.getThisLogger().debug(ServiceMessages.ALERT_PUBLISHING, alert);
                this.doSend(alert);
                this.getThisLogger().trace(ServiceMessages.ALERT_PUBLISHED, alert);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean setUp(Config config, KeyedGroups alerterProperties, Thread.UncaughtExceptionHandler owner) {
            this._stealth = alerterProperties.getBoolean(STEALTH_PROPERTY);
            if (this.isStealth()) {
                this.getThisLogger().info(ServiceMessages.ALERTER_STEALTH, new Object[0]);
            }
            this._shared = !this.isStealth() && alerterProperties.getBoolean(SHARED_PROPERTY);
            Class<Alerter> clazz = Alerter.class;
            synchronized (Alerter.class) {
                if (!this._shared || !this._sharedContext.getSharedAlerter().isPresent()) {
                    boolean midnightEnabled;
                    this._service = Optional.ofNullable(config.hasService() ? config.getService() : null);
                    this._config = config;
                    this._alerterProperties = alerterProperties;
                    this._owner = owner;
                    if (!this.doSetUp()) {
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return false;
                    }
                    boolean bl = midnightEnabled = this.isEmbedded() && !this.isStealth();
                    if (midnightEnabled) {
                        this.getThisLogger().info(ServiceMessages.MIDNIGHT_EVENT_ENABLED, new Object[0]);
                    }
                    this._midnightEnabled = midnightEnabled;
                    if (this._shared) {
                        this._sharedContext.setSharedAlerter(Optional.of(this));
                        this._sharedContext.getHolders().incrementAndGet();
                        this.getThisLogger().debug(ServiceMessages.ALERTER_SHARING, new Object[0]);
                    }
                    this.getThisLogger().debug(ServiceMessages.SET_UP_COMPLETED, new Object[0]);
                } else {
                    this._sharedContext.getHolders().incrementAndGet();
                    this.getThisLogger().debug(ServiceMessages.ALERTER_SHARED, new Object[0]);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return true;
            }
        }

        @Override
        public final void start() throws InterruptedException {
            if (this._shared && this._sharedContext.getHolders().get() != 1) {
                return;
            }
            this.doStart();
            if (this._midnightEnabled) {
                Optional<Timer> timer = this._getTimer();
                if (timer.isPresent()) {
                    Optional<ElapsedTime> watchdogPeriod = this._alerterProperties.getElapsed(WATCHDOG_PERIOD_PROPERTY, Optional.of(DEFAULT_WATCHDOG_PERIOD), Optional.empty());
                    Optional<ElapsedTime> watchdogTrigger = this._alerterProperties.getElapsed(WATCHDOG_TRIGGER_PROPERTY, Optional.of(DEFAULT_WATCHDOG_TRIGGER), Optional.empty());
                    if (watchdogPeriod.isPresent() && watchdogTrigger.isPresent()) {
                        this.getThisLogger().debug(ServiceMessages.WATCHDOG_PERIOD, watchdogPeriod.get());
                        this.getThisLogger().debug(ServiceMessages.WATCHDOG_TRIGGER, watchdogTrigger.get());
                        _Watchdog watchdog = new _Watchdog(watchdogTrigger.get().toMillis());
                        timer.get().schedule((TimerTask)watchdog, 0L, watchdogPeriod.get().toMillis());
                        this._watchdog = watchdog;
                    }
                }
                this._scheduleMidnightEvent(true);
            }
        }

        @Override
        public final void stop() {
            _Watchdog watchdog;
            if (this._shared && this._sharedContext.getHolders().get() != 1) {
                return;
            }
            _MidnightEvent midnightEvent = this._midnightEvent.getAndSet(null);
            if (midnightEvent != null) {
                midnightEvent.cancel();
            }
            if ((watchdog = this._watchdog) != null) {
                this._watchdog = null;
                watchdog.cancel();
            }
            this.doStop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void tearDown() {
            this.stop();
            Class<Alerter> clazz = Alerter.class;
            synchronized (Alerter.class) {
                if (!this._shared || this._sharedContext.getHolders().decrementAndGet() == 0) {
                    this._listeners.clear();
                    this.doTearDown();
                    this._config = null;
                    this._alerterProperties = null;
                    this._service = null;
                    this._owner = null;
                    if (this._shared) {
                        this._sharedContext.setSharedAlerter(Optional.empty());
                    }
                    this.getThisLogger().debug(ServiceMessages.TEAR_DOWN_COMPLETED, new Object[0]);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        protected abstract void doSend(@Nonnull Alert var1) throws InterruptedException, ServiceNotAvailableException;

        @CheckReturnValue
        protected abstract boolean doSetUp();

        protected void doStart() throws InterruptedException {
        }

        protected void doStop() {
        }

        protected abstract void doTearDown();

        protected final void notifyListeners(@Nonnull Optional<Alert> alert) {
            for (Listener listener : this._listeners) {
                Require.ignored(listener.onAlert(alert));
            }
        }

        @Nonnull
        @CheckReturnValue
        protected abstract SharedContext sharedContext();

        boolean _hasMidnightEvent() {
            return this._midnightEvent.get() != null;
        }

        void _scheduleMidnightEvent(boolean starting) {
            Optional<Timer> timer = this._getTimer();
            if (timer.isPresent()) {
                DateTime midnight = DateTime.now().nextDay();
                _MidnightEvent midnightEvent = new _MidnightEvent();
                try {
                    timer.get().schedule((TimerTask)midnightEvent, midnight.toTimestamp());
                }
                catch (IllegalStateException exception) {
                    this.getThisLogger().debug(ServiceMessages.MIDNIGHT_EVENT_CANCELED, new Object[0]);
                    return;
                }
                if (this._midnightEvent.getAndSet(midnightEvent) == null && !starting) {
                    midnightEvent.cancel();
                    this._midnightEvent.set(null);
                    this.getThisLogger().debug(ServiceMessages.MIDNIGHT_EVENT_CANCELED, new Object[0]);
                } else {
                    this.getThisLogger().debug(ServiceMessages.MIDNIGHT_EVENT_SCHEDULED, midnight);
                }
            } else {
                this.getThisLogger().debug(ServiceMessages.MIDNIGHT_EVENT_CANCELED, new Object[0]);
            }
        }

        void _sendEvent(@Nonnull Event event) {
            block3: {
                this.getThisLogger().trace(ServiceMessages.PUBLISHING_EVENT, event.getName());
                try {
                    this.send(event);
                }
                catch (InterruptedException exception) {
                    throw new InternalError(exception);
                }
                catch (ServiceNotAvailableException exception) {
                    Optional<Service> service = this.getService();
                    if (!service.isPresent()) break block3;
                    this.getThisLogger().error((Throwable)exception, ServiceMessages.RESTART_NEEDED, new Object[0]);
                    service.get().restart(false);
                    return;
                }
            }
        }

        private Optional<Timer> _getTimer() {
            Optional<Service> service = this._service;
            return service.isPresent() ? service.get().getTimer() : Optional.empty();
        }

        private class _Watchdog
        extends TimerTask {
            private String _logID;
            private long _previousSystemMillis;
            private final long _trigger;

            _Watchdog(long trigger) {
                this._trigger = trigger;
                this._logID = Logger.currentLogID().orElse(null);
            }

            @Override
            public void run() {
                if (this._previousSystemMillis == 0L) {
                    Logger.setLogID(Optional.ofNullable(this._logID));
                    Abstract.this.getThisLogger().debug(ServiceMessages.WATCHDOG_STARTED, new Object[0]);
                    this._previousSystemMillis = System.currentTimeMillis();
                    return;
                }
                long systemMillis = System.currentTimeMillis();
                long elapsedMillis = systemMillis - this._previousSystemMillis;
                if (elapsedMillis > this._trigger) {
                    Optional<Service> service = Abstract.this.getService();
                    Abstract.this.getThisLogger().info(ServiceMessages.WATCHDOG_TRIGGERED, ElapsedTime.fromMillis(elapsedMillis));
                    Abstract.this._sendEvent(new Event("Watchdog", service.isPresent() ? Optional.of(service.get().getServiceName()) : Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(ElapsedTime.fromMillis(elapsedMillis))));
                }
                this._previousSystemMillis = systemMillis;
            }
        }

        private class _MidnightEvent
        extends TimerTask {
            _MidnightEvent() {
            }

            @Override
            public void run() {
                if (Abstract.this._hasMidnightEvent()) {
                    Abstract.this._sendEvent(new Event("Midnight", Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
                    Abstract.this._scheduleMidnightEvent(false);
                }
            }
        }
    }

    public static interface Listener {
        @CheckReturnValue
        public boolean onAlert(@Nonnull Optional<Alert> var1);
    }
}

