/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public final class ProcessLogWriter
implements ServiceThread.Target {
    private static final String _DEBUG_PREFIX = "DEBUG ";
    private static final String _ERROR_PREFIX = "ERROR ";
    private static final String _FATAL_PREFIX = "FATAL ";
    private static final String _INFO_PREFIX = "INFO ";
    private static final String _TRACE_PREFIX = "TRACE ";
    private static final String _WARN_PREFIX = "WARN ";
    private volatile boolean _closed;
    private final Logger _logger;
    private final String _ownerName;
    private final BufferedReader _stderr;
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();

    ProcessLogWriter(@Nonnull String ownerName, @Nonnull BufferedReader stderr) {
        this._ownerName = ownerName;
        this._logger = Logger.getInstance(this.getClass().getName() + ':' + ownerName);
        this._stderr = stderr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Level previousLevel = Level.WARN;
        try {
            while (true) {
                Level level;
                String prefix;
                String line;
                try {
                    line = this._stderr.readLine();
                }
                catch (IOException exception) {
                    line = null;
                }
                if (line == null) {
                    if (!this._closed) {
                        this._logger.debug(ServiceMessages.PROCESS_LOG_END, new Object[0]);
                    }
                    try {
                        this._stderr.close();
                    }
                    catch (IOException exception) {
                        this._logger.debug(ServiceMessages.PROCESS_LOG_CLOSE_FAILED, exception.getMessage());
                    }
                    break;
                }
                if (this._closed || line.trim().isEmpty()) continue;
                if (line.startsWith(_TRACE_PREFIX)) {
                    prefix = _TRACE_PREFIX;
                    level = Level.TRACE;
                } else if (line.startsWith(_DEBUG_PREFIX)) {
                    prefix = _DEBUG_PREFIX;
                    level = Level.DEBUG;
                } else if (line.startsWith(_INFO_PREFIX)) {
                    prefix = _INFO_PREFIX;
                    level = Level.INFO;
                } else if (line.startsWith(_WARN_PREFIX)) {
                    prefix = _WARN_PREFIX;
                    level = Level.WARN;
                } else if (line.startsWith(_ERROR_PREFIX)) {
                    prefix = _ERROR_PREFIX;
                    level = Level.ERROR;
                } else if (line.startsWith(_FATAL_PREFIX)) {
                    prefix = _FATAL_PREFIX;
                    level = Level.FATAL;
                } else {
                    prefix = "";
                    level = line.startsWith(" ") || line.startsWith("\t") ? previousLevel : Level.WARN;
                }
                line = line.substring(prefix.length());
                switch (level) {
                    case TRACE: {
                        this._logger.trace(BaseMessages.VERBATIM, line);
                        break;
                    }
                    case DEBUG: {
                        this._logger.debug(BaseMessages.VERBATIM, line);
                        break;
                    }
                    case INFO: {
                        this._logger.info(BaseMessages.VERBATIM, line);
                        break;
                    }
                    case WARN: {
                        this._logger.warn(BaseMessages.VERBATIM, line);
                        break;
                    }
                    case ERROR: {
                        this._logger.error(BaseMessages.VERBATIM, line);
                        break;
                    }
                    case FATAL: {
                        this._logger.fatal(BaseMessages.VERBATIM, line);
                        break;
                    }
                    default: {
                        Require.failure();
                    }
                }
                previousLevel = level;
            }
        }
        finally {
            if (this._closed) {
                this._thread.get().setQuiet(true);
            }
        }
    }

    void close() {
        this._closed = true;
    }

    @CheckReturnValue
    boolean isAlive() {
        ServiceThread thread = this._thread.get();
        return thread != null && thread.isAlive();
    }

    void join(long millis) throws InterruptedException {
        ServiceThread thread = this._thread.get();
        if (thread != null) {
            thread.join(millis);
        }
    }

    void start() {
        ServiceThread thread = new ServiceThread(this, "Log writer (" + this._ownerName + ")");
        if (this._thread.compareAndSet(null, thread)) {
            thread.setDaemon(true);
            this._logger.debug(ServiceMessages.STARTING_THREAD, thread.getName());
            thread.start();
        }
    }

    private static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

