/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.ValueConverter;
import org.rvpf.service.ProcessLogWriter;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public final class ProcessMonitor
implements ServiceThread.Target {
    private static final String _END_MESSAGE = "0";
    private static long _lastRequestID;
    private boolean _busy;
    private final Charset _charset;
    private volatile boolean _closing;
    private TimerTask _expirator;
    private final Optional<ElapsedTime> _keepProcess;
    private final ElapsedTime _killDelay;
    private TimerTask _limiter;
    private final Logger _logger;
    private final Object _mutex = new Object();
    private final String _ownerName;
    private final ProcessBuilder _processBuilder;
    private volatile boolean _ready;
    private final Optional<Service> _service;
    private volatile PrintWriter _stdin;
    private volatile BufferedReader _stdout;
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();
    private volatile long _timeLimit;

    ProcessMonitor(@Nonnull String ownerName, @Nonnull Logger logger, @Nonnull ElapsedTime killDelay, @Nonnull Optional<Service> service, @Nonnull Charset charset, @Nonnull ProcessBuilder processBuilder, @Nonnull Optional<ElapsedTime> keepProcess) {
        this._ownerName = ownerName;
        this._logger = logger;
        this._killDelay = killDelay;
        this._service = service;
        this._processBuilder = processBuilder;
        this._charset = charset;
        this._keepProcess = keepProcess;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @CheckReturnValue
    public static synchronized long newRequestID() {
        long millis = System.currentTimeMillis();
        _lastRequestID = millis > _lastRequestID ? millis : ++_lastRequestID;
        return _lastRequestID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public boolean activateProcess() {
        Object object = this._mutex;
        synchronized (object) {
            if (this._ready) {
                this._busy = true;
                this._cancelExpirator();
            } else {
                String line;
                while (this._thread.get() != null) {
                    try {
                        this._mutex.wait();
                    }
                    catch (InterruptedException exception) {
                        this._logger.debug(ServiceMessages.INTERRUPTED, new Object[0]);
                        Thread.currentThread().interrupt();
                        return false;
                    }
                }
                ServiceThread thread = new ServiceThread(this, "Process monitor (" + this._ownerName + ")");
                if (this._thread.compareAndSet(null, thread)) {
                    this._logger.debug(ServiceMessages.STARTING_THREAD, thread.getName());
                    thread.start();
                }
                while (!this._ready) {
                    if (this._thread.get() == null) {
                        return false;
                    }
                    try {
                        this._mutex.wait();
                    }
                    catch (InterruptedException exception) {
                        this._logger.debug(ServiceMessages.INTERRUPTED, new Object[0]);
                        Thread.currentThread().interrupt();
                        return false;
                    }
                }
                String requestID = String.valueOf(ProcessMonitor.newRequestID());
                if (!this.writeLine(requestID)) {
                    this.cancelProcess(Optional.empty());
                    return false;
                }
                do {
                    if ((line = this.readLine()) != null) continue;
                    this.cancelProcess(Optional.empty());
                    return false;
                } while (!line.equals(requestID));
                this._busy = true;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Thread thread;
        Object object = this._mutex;
        synchronized (object) {
            if (this._closing) {
                return;
            }
            this._closing = true;
            this._cancelLimiter();
            this._cancelExpirator();
            thread = this._thread.get();
            this._busy = false;
        }
        if (thread != null) {
            this._logger.trace(ServiceMessages.CLOSING_PROCESS, new Object[0]);
            this._stopProcess(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeProcess() {
        Thread thread;
        Object object = this._mutex;
        synchronized (object) {
            long graceMillis = this._keepProcess.isPresent() ? this._keepProcess.get().toMillis() : -1L;
            Optional<Timer> timer = this._getTimer();
            this._busy = false;
            this._cancelLimiter();
            if (graceMillis > 0L && timer.isPresent()) {
                this._expirator = new TimerTask(){

                    @Override
                    public void run() {
                        ProcessMonitor.this.expireProcess();
                    }
                };
                timer.get().schedule(this._expirator, graceMillis);
                thread = null;
            } else {
                thread = graceMillis >= 0L ? (Thread)this._thread.get() : null;
            }
        }
        if (thread != null) {
            this._logger.trace(ServiceMessages.FREEING_PROCESS, new Object[0]);
            this._stopProcess(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void limit(long timeLimit) {
        Object object = this._mutex;
        synchronized (object) {
            Optional<Timer> timer = this._getTimer();
            if (timer.isPresent()) {
                this._timeLimit = timeLimit;
                if (this._timeLimit > 0L) {
                    this._logger.trace(ServiceMessages.TIME_LIMIT_SET, ElapsedTime.fromMillis(this._timeLimit));
                    this._limiter = new TimerTask(){

                        @Override
                        public void run() {
                            ProcessMonitor.this.cancelProcess(Optional.of(ServiceMessages.TIME_LIMIT_EXCEEDED));
                        }
                    };
                    timer.get().schedule(this._limiter, this._timeLimit);
                }
            }
        }
    }

    @Nullable
    @CheckReturnValue
    public String readLine() {
        String line;
        BufferedReader stdout = this._stdout;
        if (stdout == null) {
            this._logger.warn(ServiceMessages.PROCESS_PREMATURE_EXIT, this._ownerName);
            return null;
        }
        do {
            try {
                line = stdout.readLine();
            }
            catch (IOException exception) {
                this._logger.warn((Throwable)exception, ServiceMessages.EXCEPTION_ON_RESPONSE, this._ownerName);
                return null;
            }
            if (line == null) {
                this._logger.warn(ServiceMessages.PROCESS_UNEXPECTED_END, this._ownerName);
                break;
            }
            this._logger.trace(ServiceMessages.RECEIVED_FROM_PROCESS, line);
        } while ((line = line.trim()).length() <= 0);
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object exception12;
        ProcessLogWriter logWriter;
        Process process;
        Charset charset = this._charset;
        Object object = this._mutex;
        synchronized (object) {
            this._logger.trace(ServiceMessages.STARTING_PROCESS, new Object[0]);
            try {
                process = this._processBuilder.start();
            }
            catch (IOException exception) {
                this._logger.error((Throwable)exception, ServiceMessages.PROCESS_START_FAILED, new Object[0]);
                this._thread.set(null);
                this._mutex.notifyAll();
                return;
            }
            this._logger.debug(ServiceMessages.PROCESS_STARTED, new Object[0]);
            this._stdin = new PrintWriter(new BufferedWriter(new OutputStreamWriter(process.getOutputStream(), charset)));
            this._stdout = new BufferedReader(new InputStreamReader(process.getInputStream(), charset));
            logWriter = new ProcessLogWriter(this._ownerName, new BufferedReader(new InputStreamReader(process.getErrorStream(), charset)));
            logWriter.start();
            this._ready = true;
            this._mutex.notifyAll();
            this._logger.debug(ServiceMessages.THREAD_READY, Thread.currentThread().getName());
        }
        try {
            this._logger.trace(ServiceMessages.MONITORING_PROCESS, new Object[0]);
            try {
                process.waitFor();
                int exitValue = process.exitValue();
                if (exitValue != 0) {
                    this._logger.warn(ServiceMessages.PROCESS_EXIT_CODE, String.valueOf(exitValue));
                } else {
                    this._logger.debug(this._ready ? ServiceMessages.PROCESS_STOPPED_ITSELF : ServiceMessages.PROCESS_STOPPED, new Object[0]);
                }
            }
            catch (InterruptedException exception12) {
                this._logger.trace(ServiceMessages.PROCESS_WAIT_INTERRUPTED, new Object[0]);
                this._logger.debug(ServiceMessages.INTERRUPTING_PROCESS, new Object[0]);
                process.destroy();
                this._logger.trace(ServiceMessages.PROCESS_WAIT, new Object[0]);
                try {
                    process.waitFor();
                }
                catch (InterruptedException exception2) {
                    this._logger.debug(ServiceMessages.PROCESS_WAIT_INTERRUPTED_AGAIN, new Object[0]);
                }
            }
            exception12 = this._mutex;
        }
        catch (Throwable throwable) {
            Object object2 = this._mutex;
            synchronized (object2) {
                this._cancelLimiter();
                this._cancelExpirator();
                this._closeStdin();
                try {
                    this._stdout.close();
                    this._logger.trace(ServiceMessages.PROCESS_OUTPUT_CLOSED, new Object[0]);
                }
                catch (IOException exception) {
                    this._logger.debug(ServiceMessages.PROCESS_OUTPUT_CLOSE_FAILED, exception.getMessage());
                }
                finally {
                    this._stdout = null;
                    this._ready = false;
                }
            }
            if (this._closing) {
                this._logger.trace(ServiceMessages.CLOSING_LOG_WRITER, new Object[0]);
                logWriter.close();
            } else {
                try {
                    if (logWriter.isAlive()) {
                        this._logger.trace(ServiceMessages.LOG_WRITER_WAIT, new Object[0]);
                        logWriter.join(this._timeLimit);
                    }
                    this._logger.trace(ServiceMessages.PROCESS_LOG_CLOSED, new Object[0]);
                }
                catch (InterruptedException exception) {
                    this._logger.debug(ServiceMessages.LOG_WRITER_WAIT_INTERRUPTED, new Object[0]);
                    logWriter.close();
                }
            }
            object2 = this._mutex;
            synchronized (object2) {
                this._thread.set(null);
                this._mutex.notifyAll();
            }
            throw throwable;
        }
        synchronized (exception12) {
            this._cancelLimiter();
            this._cancelExpirator();
            this._closeStdin();
            try {
                this._stdout.close();
                this._logger.trace(ServiceMessages.PROCESS_OUTPUT_CLOSED, new Object[0]);
            }
            catch (IOException exception) {
                this._logger.debug(ServiceMessages.PROCESS_OUTPUT_CLOSE_FAILED, exception.getMessage());
            }
            finally {
                this._stdout = null;
                this._ready = false;
            }
        }
        if (this._closing) {
            this._logger.trace(ServiceMessages.CLOSING_LOG_WRITER, new Object[0]);
            logWriter.close();
        } else {
            try {
                if (logWriter.isAlive()) {
                    this._logger.trace(ServiceMessages.LOG_WRITER_WAIT, new Object[0]);
                    logWriter.join(this._timeLimit);
                }
                this._logger.trace(ServiceMessages.PROCESS_LOG_CLOSED, new Object[0]);
            }
            catch (InterruptedException exception) {
                this._logger.debug(ServiceMessages.LOG_WRITER_WAIT_INTERRUPTED, new Object[0]);
                logWriter.close();
            }
        }
        Object object3 = this._mutex;
        synchronized (object3) {
            this._thread.set(null);
            this._mutex.notifyAll();
        }
    }

    @CheckReturnValue
    public boolean writeLine(@Nonnull String line) {
        PrintWriter processStdin = this._stdin;
        if (processStdin == null) {
            this._logger.warn(ServiceMessages.PROCESS_LOST, this._ownerName);
            return false;
        }
        processStdin.println(line);
        if (processStdin.checkError()) {
            this._logger.warn(ServiceMessages.PROCESS_REQUEST_FAILED, this._ownerName);
            return false;
        }
        this._logger.trace(ServiceMessages.SENT_TO_PROCESS, line);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelProcess(@Nonnull Optional<Object> warning) {
        Thread thread = this._thread.get();
        Object object = this._mutex;
        synchronized (object) {
            if (thread == null || !this._busy || thread.isInterrupted()) {
                return;
            }
            this._busy = false;
        }
        if (warning.isPresent()) {
            this._logger.warn(ServiceMessages.CANCELLING_PROCESS_WARN, warning.get());
        } else {
            this._logger.debug(ServiceMessages.CANCELLING_PROCESS, new Object[0]);
        }
        this._stopProcess(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expireProcess() {
        Thread thread = this._thread.get();
        Object object = this._mutex;
        synchronized (object) {
            if (thread == null || this._busy || thread.isInterrupted()) {
                return;
            }
        }
        this._logger.trace(ServiceMessages.PROCESS_INACTIVE, new Object[0]);
        this._stopProcess(true);
    }

    private void _cancelExpirator() {
        if (this._expirator != null) {
            this._expirator.cancel();
            this._expirator = null;
            this._logger.trace(ServiceMessages.PROCESS_EXPIRATOR_CANCELLED, new Object[0]);
        }
    }

    private void _cancelLimiter() {
        if (this._limiter != null) {
            this._limiter.cancel();
            this._limiter = null;
            this._logger.trace(ServiceMessages.PROCESS_LIMITER_CANCELLED, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _closeStdin() {
        Object object = this._mutex;
        synchronized (object) {
            PrintWriter stdin = this._stdin;
            if (stdin != null) {
                boolean hadErrors = stdin.checkError();
                stdin.close();
                if (stdin.checkError() && !hadErrors) {
                    this._logger.warn(ServiceMessages.PROCESS_INPUT_CLOSE_FAILED, new Object[0]);
                } else {
                    this._logger.trace(ServiceMessages.PROCESS_INPUT_CLOSED, new Object[0]);
                }
                this._stdin = null;
            }
        }
    }

    private Optional<Timer> _getTimer() {
        Optional<Service> service = this._service;
        return service.isPresent() ? service.get().getTimer() : Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _stopProcess(boolean wait) {
        Object object = this._mutex;
        synchronized (object) {
            if (this._busy) {
                this._logger.trace(ServiceMessages.PROCESS_STOP_CANCELLED, new Object[0]);
                return;
            }
            this._ready = false;
        }
        if (wait) {
            object = this._mutex;
            synchronized (object) {
                PrintWriter stdin = this._stdin;
                if (stdin != null) {
                    boolean hadErrors = stdin.checkError();
                    stdin.println(_END_MESSAGE);
                    if (stdin.checkError() && !hadErrors) {
                        this._logger.warn(ServiceMessages.PROCESS_END_FAILED, _END_MESSAGE);
                    } else {
                        this._logger.trace(ServiceMessages.SENT_TO_PROCESS, _END_MESSAGE);
                    }
                }
            }
        }
        this._closeStdin();
        ServiceThread thread = this._thread.getAndSet(null);
        if (thread != null) {
            this._logger.debug(ServiceMessages.STOPPING_THREAD, thread.getName());
            if (wait) {
                Require.ignored(thread.join(this._logger, this._killDelay.toMillis()));
            }
            if (thread.isAlive()) {
                Require.ignored(thread.interruptAndJoin(this._logger, this._service.get().getJoinTimeout()));
            }
        }
    }

    public static final class Builder {
        private static final String _CLASSPATH_KEY = "CLASSPATH";
        private static final ElapsedTime _DEFAULT_KILL_DELAY = ElapsedTime.fromMillis(60000L);
        private static final String _PATH_KEY = "PATH";
        private static final String _PATH_SEPARATOR = File.pathSeparator;
        private static final Pattern _WHITESPACE_PATTERN = Pattern.compile("\\s");
        private String[] _args;
        private Optional<Charset> _charset = Optional.empty();
        private Optional<String> _command = Optional.empty();
        private Optional<File> _directory = Optional.empty();
        private Optional<ElapsedTime> _keepProcess = Optional.empty();
        private Optional<ElapsedTime> _killDelay = Optional.empty();
        private String _ownerName;
        private Optional<String> _program = Optional.empty();
        private Optional<Service> _service = Optional.empty();
        private String[] _sets;

        Builder() {
        }

        @Nullable
        @CheckReturnValue
        public ProcessMonitor build() {
            String[] args;
            Optional<String> command;
            String ownerName = Require.notNull(this._ownerName);
            Optional<ElapsedTime> killDelay = this._killDelay;
            Logger logger = Logger.getInstance(this.getClass().getName() + ':' + ownerName);
            Charset charset = this._charset.orElse(null);
            if (charset == null) {
                charset = Charset.defaultCharset();
            }
            LinkedList<String> list = new LinkedList<String>();
            String program = this._program.orElse(null);
            if (program != null && (program = program.trim()).length() > 0) {
                list.add(program);
            }
            if ((command = this._command).isPresent()) {
                list.addAll(Arrays.asList(_WHITESPACE_PATTERN.split(command.get().trim())));
            }
            if ((args = this._args) != null) {
                for (String arg : args) {
                    list.add(arg.trim());
                }
            }
            if (list.isEmpty()) {
                logger.error(ServiceMessages.NOTHING_TO_EXECUTE, new Object[0]);
                return null;
            }
            if (logger.isDebugEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String arg : list) {
                    stringBuilder.append(' ');
                    stringBuilder.append(arg);
                }
                logger.debug(ServiceMessages.COMMAND, stringBuilder);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(list);
            if (this._directory.isPresent()) {
                processBuilder.directory(this._directory.get());
                logger.debug(() -> new Message(ServiceMessages.DIRECTORY, this._directory.get().getAbsolutePath()));
            }
            Map<String, String> env = processBuilder.environment();
            if (this._sets != null) {
                String pathKey = null;
                for (String set : this._sets) {
                    String key;
                    int equalPos = set.indexOf(61);
                    int operPos = equalPos > 0 && set.charAt(equalPos - 1) == '+' ? equalPos - 1 : equalPos;
                    String string = key = operPos < 0 ? set : set.substring(0, operPos);
                    if (key.equalsIgnoreCase(_PATH_KEY)) {
                        if (pathKey == null) {
                            pathKey = key;
                            for (String envKey : env.keySet()) {
                                if (!envKey.equalsIgnoreCase(_PATH_KEY)) continue;
                                pathKey = envKey;
                                break;
                            }
                        }
                        key = pathKey;
                    }
                    if (operPos >= 0) {
                        String prefix;
                        String text = set.substring(equalPos + 1);
                        if (key.equalsIgnoreCase(_PATH_KEY) || key.equals(_CLASSPATH_KEY)) {
                            try {
                                text = ValueConverter.canonicalizePath(text);
                            }
                            catch (IOException exception) {
                                throw new RuntimeException(exception);
                            }
                        }
                        if (operPos != equalPos && (prefix = env.get(key)) != null && prefix.trim().length() > 0) {
                            text = key.equalsIgnoreCase(_PATH_KEY) || key.equals(_CLASSPATH_KEY) ? prefix + _PATH_SEPARATOR + text : prefix + text;
                        }
                        env.put(key, text);
                        logger.debug(ServiceMessages.ENVIRONMENT_SET, key, text);
                        continue;
                    }
                    env.remove(key);
                }
            }
            return new ProcessMonitor(ownerName, Logger.getInstance(this.getClass().getName() + ':' + ownerName), killDelay.isPresent() && killDelay.get().toMillis() > 0L ? killDelay.get() : _DEFAULT_KILL_DELAY, this._service, charset, processBuilder, this._keepProcess);
        }

        @Nonnull
        public Builder setArgs(@Nonnull String[] args) {
            this._args = args;
            return this;
        }

        @Nonnull
        public Builder setCharset(@Nonnull Optional<Charset> charset) {
            this._charset = charset;
            return this;
        }

        @Nonnull
        public Builder setCommand(@Nonnull Optional<String> command) {
            this._command = command;
            return this;
        }

        @Nonnull
        public Builder setDirectory(@Nonnull Optional<File> directory) {
            this._directory = directory;
            return this;
        }

        @Nonnull
        public Builder setKeepProcess(@Nonnull Optional<ElapsedTime> keepProcess) {
            this._keepProcess = keepProcess;
            return this;
        }

        @Nonnull
        public Builder setKillDelay(@Nonnull Optional<ElapsedTime> killDelay) {
            this._killDelay = killDelay;
            return this;
        }

        @Nonnull
        public Builder setOwnerName(@Nonnull String ownerName) {
            this._ownerName = ownerName;
            return this;
        }

        @Nonnull
        public Builder setProgram(@Nonnull Optional<String> program) {
            this._program = program;
            return this;
        }

        @Nonnull
        public Builder setService(@Nonnull Optional<Service> service) {
            this._service = service;
            return this;
        }

        @Nonnull
        public Builder setSets(@Nonnull String[] sets) {
            this._sets = sets;
            return this;
        }
    }
}

