/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.io.File;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.UUID;
import org.rvpf.base.alert.Alert;
import org.rvpf.config.Config;
import org.rvpf.service.Alerter;
import org.rvpf.service.ServiceActivator;
import org.rvpf.service.ServiceBase;
import org.rvpf.service.rmi.SessionFactory;

public interface Service
extends ServiceBase {
    public static final String MIDNIGHT_EVENT = "Midnight";
    public static final String PING_SIGNAL = "Ping";
    public static final String PONG_EVENT = "Pong";
    public static final String RESTART_NOW_SIGNAL = "RestartNow";
    public static final String RESTART_SIGNAL = "Restart";
    public static final String RESUMED_EVENT = "ServiceResumed";
    public static final String RESUME_SIGNAL = "Resume";
    public static final String STARTED_EVENT = "ServiceStarted";
    public static final String STOPPED_EVENT = "ServiceStopped";
    public static final String STOP_NOW_SIGNAL = "StopNow";
    public static final String STOP_SIGNAL = "Stop";
    public static final String SUSPENDED_EVENT = "ServiceSuspended";
    public static final String SUSPEND_SIGNAL = "Suspend";
    public static final String WATCHDOG_EVENT = "Watchdog";
    public static final String ZOMBIE_EVENT = "ServiceIsZombie";

    @CheckReturnValue
    public boolean addAlertListener(@Nonnull Alerter.Listener var1);

    public void disableSuspend() throws InterruptedException;

    public void enableSuspend();

    @CheckReturnValue
    public boolean exportAgent();

    @Nonnull
    @CheckReturnValue
    public Alerter getAlerter();

    @Nonnull
    @CheckReturnValue
    public Config getConfig();

    @Nonnull
    @CheckReturnValue
    public File getDataDir();

    @Nonnull
    @CheckReturnValue
    public Optional<String> getEntityName();

    @CheckReturnValue
    public long getJoinTimeout();

    @Nonnull
    @CheckReturnValue
    public Optional<UUID> getOptionalSourceUUID();

    @Nonnull
    @CheckReturnValue
    public ServiceActivator getServiceActivator();

    @Nonnull
    @CheckReturnValue
    public Optional<UUID> getServiceUUID();

    @Nonnull
    @CheckReturnValue
    public UUID getSourceUUID();

    @CheckReturnValue
    public boolean isRunning();

    @CheckReturnValue
    public boolean isStarted();

    @CheckReturnValue
    public boolean isStopped();

    @CheckReturnValue
    public boolean isStopping();

    @CheckReturnValue
    public boolean isWait();

    @CheckReturnValue
    public boolean isZombie();

    public void monitorService(@Nonnull Optional<String> var1, @Nonnull Optional<UUID> var2, @Nonnull Optional<String> var3);

    @Nullable
    @CheckReturnValue
    public String registerServer(@Nonnull SessionFactory var1, @Nonnull String var2);

    @CheckReturnValue
    public boolean removeAlertListener(@Nonnull Alerter.Listener var1);

    public void restart(boolean var1);

    public void restoreConfigState();

    public void restoreMonitored();

    public void resume();

    public void saveConfigState();

    public void saveMonitored();

    public void sendAlert(@Nonnull Alert var1);

    public void sendEvent(@Nonnull String var1, @Nonnull Optional<Object> var2);

    public void sendSignal(@Nonnull String var1, @Nonnull Optional<?> var2);

    @CheckReturnValue
    public boolean setRestartEnabled(boolean var1);

    public void setSourceUUID(@Nonnull UUID var1);

    public void starting();

    public void stopping();

    public void suspend() throws InterruptedException;

    @CheckReturnValue
    public boolean trySuspend(long var1) throws InterruptedException;

    public void unregisterServer(@Nonnull String var1);
}

