/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.ClassDef;
import org.rvpf.base.ClassDefImpl;
import org.rvpf.base.Stats;
import org.rvpf.base.tool.Require;
import org.rvpf.config.Config;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceActivatorBase;
import org.rvpf.service.ServiceActivatorMBean;
import org.rvpf.service.ServiceClassLoader;
import org.rvpf.service.ServiceImpl;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;
import org.rvpf.service.rmi.ServiceRegistry;

public abstract class ServiceActivator
extends ServiceActivatorBase
implements ServiceActivatorMBean {
    private volatile String _configURL;
    private volatile boolean _export;
    private volatile ServiceImpl _serviceImpl;
    private volatile boolean _wait;

    @Override
    public void create() throws Exception {
        super.create();
        this.created();
    }

    @Override
    public void destroy() {
        super.destroy();
        ServiceRegistry.purge();
        this.destroyed();
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<Config> getConfig() {
        ServiceImpl service = this._serviceImpl;
        return Optional.ofNullable(service != null ? this._serviceImpl.getConfig() : null);
    }

    @Override
    public final String getConfigURL() {
        return this._configURL;
    }

    @Override
    public final Optional<String> getObjectVersion() {
        ServiceImpl serviceImpl = this._serviceImpl;
        return serviceImpl != null ? Optional.of(this._serviceImpl.getVersion().getImplementationVersion()) : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public final Service getService() {
        return Require.notNull(this._serviceImpl);
    }

    public final Optional<Stats> getStats() {
        ServiceImpl service = this._serviceImpl;
        return Optional.ofNullable(service != null ? service.getStats() : null);
    }

    @Override
    public final boolean isRunning() {
        ServiceImpl service = this._serviceImpl;
        return service != null && service.isRunning();
    }

    @Override
    public final boolean isStarted() {
        ServiceImpl service = this._serviceImpl;
        return service != null && service.isStarted();
    }

    @Override
    public final boolean isStopped() {
        ServiceImpl service = this._serviceImpl;
        return service == null || service.isStopped();
    }

    @Override
    public final boolean isZombie() {
        ServiceImpl service = this._serviceImpl;
        return service != null && service.isZombie();
    }

    @Override
    public final void setConfigURL(String configURL) {
        this._configURL = Require.notNull(configURL);
        ServiceImpl serviceImpl = this._serviceImpl;
        if (serviceImpl != null) {
            serviceImpl.setConfigURL(configURL);
        }
        this.getThisLogger().debug(ServiceMessages.CONFIG_URL, configURL);
    }

    public final void setWait(boolean wait) {
        this._wait = wait;
    }

    @Override
    public void start() throws Exception {
        this.start(this._wait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(boolean wait) throws Exception {
        ServiceActivator serviceActivator = this;
        synchronized (serviceActivator) {
            if (this._serviceImpl != null) {
                this.getThisLogger().warn(ServiceMessages.SERVICE_START_IGNORED, this.getObjectName());
                return;
            }
            super.start();
            ServiceImpl serviceImpl = this.createServiceImpl();
            String configURL = this._configURL;
            if (configURL != null) {
                serviceImpl.setConfigURL(configURL);
            }
            serviceImpl.putProperties(this.getProperties());
            serviceImpl.setServiceName(this.getObjectName().toString());
            this._serviceImpl = serviceImpl;
        }
        this._serviceImpl.startService(wait);
        if (this.isStarted() && (!wait || this.isRunning())) {
            if (this._export && !this.getService().exportAgent()) {
                this.getThisLogger().warn(ServiceMessages.FAILED_AGENT_EXPORT, this.getObjectName());
            }
            this.started();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ServiceThread.yieldAll();
        ServiceActivator serviceActivator = this;
        synchronized (serviceActivator) {
            if (this.isStopping()) {
                return;
            }
            super.stop();
        }
        if (this.isStopped()) {
            return;
        }
        ServiceImpl serviceImpl = this._serviceImpl;
        if (serviceImpl != null) {
            serviceImpl.stopService();
            this._serviceImpl = null;
        }
        this.stopped();
        ServiceThread.yieldAll();
    }

    @Override
    public final void updateStats() {
        ServiceImpl serviceImpl = this._serviceImpl;
        if (serviceImpl != null) {
            serviceImpl.updateStats();
        }
    }

    @Override
    protected boolean acceptMainArg(String arg) {
        if (super.acceptMainArg(arg)) {
            return true;
        }
        if (this._configURL == null) {
            this.setConfigURL(arg);
            return true;
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    protected abstract ServiceImpl createServiceImpl();

    @Nonnull
    @CheckReturnValue
    protected final ServiceImpl createServiceImpl(@Nonnull Class<? extends ServiceImpl> serviceImplClass) {
        return Require.notNull(this.createServiceImpl(new ClassDefImpl(serviceImplClass)));
    }

    @Nullable
    @CheckReturnValue
    protected final ServiceImpl createServiceImpl(@Nonnull ClassDef classDef) {
        ServiceClassLoader classLoader = ServiceClassLoader.getInstance();
        if (classDef.getInstanceClass(Optional.of(classLoader)) == null) {
            return null;
        }
        ServiceImpl serviceImpl = classDef.createInstance(ServiceImpl.class);
        if (serviceImpl == null) {
            return null;
        }
        serviceImpl.setServiceActivatorBase(this);
        serviceImpl.setClassLoader(classLoader);
        return serviceImpl;
    }

    @Override
    protected final void export() {
        this._export = true;
    }

    @Override
    protected void tearDownStandAlone() {
        ServiceImpl.cancelRestarters();
        super.tearDownStandAlone();
    }

    private static void _setSystemProperty(String key, String value) {
        if (System.getProperty(key) == null) {
            System.setProperty(key, value);
        }
    }

    static {
        ServiceActivator._setSystemProperty("java.rmi.server.useCodebaseOnly", "true");
        ServiceActivator._setSystemProperty("java.rmi.server.disableHttp", "true");
        ServiceActivator._setSystemProperty("java.rmi.server.randomIDs", "true");
    }
}

