/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Stats;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Profiler;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.UncaughtExceptionHandler;
import org.rvpf.base.util.Version;
import org.rvpf.service.ServiceActivatorBaseMBean;
import org.rvpf.service.ServiceActivatorListener;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceVersion;
import org.rvpf.service.StatsHolder;

@ThreadSafe
public abstract class ServiceActivatorBase
extends StatsHolder
implements ServiceActivatorBaseMBean,
MBeanRegistration {
    public static final String NAME_ARG_PREFIX = "name=";
    public static final String OBJECT_NAME_PROPERTY = "rvpf.object.name";
    private volatile ServiceActivatorListener _listener;
    private AtomicReference<Thread> _mainThread = new AtomicReference();
    private volatile String _objectNameProperty = "rvpf.object.name";
    private final Properties _properties = new Properties();
    private volatile boolean _restarting;
    private volatile MBeanServer _server;
    private volatile boolean _stopping;

    @Override
    public void create() throws Exception {
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            Thread.setDefaultUncaughtExceptionHandler(Logger.getInstance(Logger.class));
        }
    }

    @Override
    public void destroy() {
    }

    public final boolean equals(Object other) {
        if (!(other instanceof ServiceActivatorBase)) {
            return false;
        }
        return this.getObjectName().equals(((ServiceActivatorBase)other).getObjectName());
    }

    @Override
    public final ObjectName getObjectName() {
        Optional<ObjectName> objectName = this.objectName();
        if (!objectName.isPresent()) {
            String objectNameProperty = this._objectNameProperty;
            String nameString = objectNameProperty != null ? System.getProperty(objectNameProperty) : null;
            try {
                objectName = Optional.of(nameString != null ? ObjectName.getInstance(nameString) : this.makeObjectName(Optional.empty()));
            }
            catch (MalformedObjectNameException exception) {
                throw new RuntimeException(exception);
            }
            this.setObjectName(objectName.get());
        }
        return objectName.get();
    }

    @Override
    public final Properties getProperties() {
        return this._properties;
    }

    @Override
    public final Optional<String> getProperty(String key) {
        return Optional.ofNullable(this._properties.getProperty(key));
    }

    @Override
    public Optional<? extends Stats> getStats() {
        return Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public Version getVersion() {
        return new ServiceVersion();
    }

    public final int hashCode() {
        return this.getObjectName().hashCode();
    }

    @Override
    public boolean isRunning() {
        return this.isStarted();
    }

    @Override
    public boolean isStopped() {
        return !this.isStarted();
    }

    @Override
    public final void postDeregister() {
    }

    @Override
    public final void postRegister(Boolean done) {
    }

    @Override
    public final void preDeregister() {
    }

    @Override
    public final ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this._server = server;
        if (name != null) {
            this.setObjectName(name);
        }
        ObjectName objectName = this.getObjectName();
        this.getThisLogger().debug(ServiceMessages.SERVICE_NAME, objectName);
        return objectName;
    }

    @Override
    public void restart() throws Exception {
        this.restart(Optional.empty());
    }

    public final void restart(@Nonnull Optional<ElapsedTime> delay) throws Exception {
        Require.success(!this._restarting);
        this._restarting = true;
        ServiceActivatorListener listener = this._listener;
        if (listener != null) {
            listener.restart(delay);
        } else {
            if (!this.isStopped()) {
                this.stop();
            }
            if (delay.isPresent()) {
                Thread.sleep(delay.get().toMillis());
            }
            this.start();
        }
        this._restarting = false;
    }

    public final void setListener(@Nonnull ServiceActivatorListener listener) {
        this._listener = Require.notNull(listener);
    }

    public final void setObjectNameProperty(@Nonnull Optional<String> propertyName) {
        this._objectNameProperty = propertyName.orElse(null);
    }

    @Override
    public final void setProperties(Properties properties) {
        this._properties.putAll((Map<?, ?>)properties);
        this.getThisLogger().debug(ServiceMessages.SERVICE_PROPERTIES, properties);
    }

    @Override
    public final void setProperty(String key, String value) {
        this._properties.setProperty(key, value);
        this.getThisLogger().debug(ServiceMessages.SERVICE_PROPERTY, key, value);
    }

    @Override
    public void start() throws Exception {
        if (this.isStarted()) {
            this.getThisLogger().warn(ServiceMessages.SERVICE_START_IGNORED, this.getObjectName());
        } else {
            this._stopping = false;
        }
    }

    public final void starting(@Nonnull Optional<ElapsedTime> waitHint) {
        ServiceActivatorListener listener = this._listener;
        if (listener != null) {
            listener.starting(waitHint);
        }
    }

    @Override
    public void stop() {
        if (this.isStopped()) {
            this.getThisLogger().warn(ServiceMessages.SERVICE_STOP_IGNORED, this.getObjectName());
        } else {
            this._stopping = true;
        }
    }

    public final void stopping(@Nonnull Optional<ElapsedTime> waitHint) {
        ServiceActivatorListener listener = this._listener;
        if (listener != null) {
            listener.stopping(waitHint);
        }
    }

    public void terminate() {
        ServiceActivatorListener listener = this._listener;
        Optional<Thread> mainThread = this._clearMainThread();
        if (listener != null) {
            listener.terminate();
        } else if (mainThread.isPresent()) {
            mainThread.get().interrupt();
        } else {
            System.exit(-1);
        }
    }

    public final String toString() {
        return this.getObjectName().toString();
    }

    @Override
    public void updateStats() {
    }

    @CheckReturnValue
    protected boolean acceptMainArg(@Nonnull String arg) {
        if (arg.startsWith(NAME_ARG_PREFIX)) {
            String name = arg.substring(NAME_ARG_PREFIX.length()).trim();
            this.setObjectName(this.makeObjectName(Optional.ofNullable(name.length() > 0 ? name : null)));
            return true;
        }
        return false;
    }

    protected void created() {
        this.getThisLogger().debug(ServiceMessages.SERVICE_CREATED, this.getObjectName());
    }

    protected void destroyed() {
        this.getThisLogger().debug(ServiceMessages.SERVICE_DESTROYED, this.getObjectName());
    }

    protected void export() {
    }

    @Nonnull
    @CheckReturnValue
    protected final MBeanServer getServer() {
        return Require.notNull(this._server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void run(@Nonnull String[] args) {
        boolean standAlone;
        boolean bl = standAlone = Logger.class.getClassLoader() == this.getClass().getClassLoader();
        if (standAlone) {
            Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandler());
            System.setProperty("line.separator", "\n");
            Logger.startUp(true);
            Logger.setLogID();
        }
        try {
            block17: {
                try {
                    this.create(args);
                    this._mainThread.set(Thread.currentThread());
                    this.export();
                    this.start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (standAlone) {
                        Logger.shutDown();
                    }
                    return;
                }
                if (this.isStarted()) {
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                        Optional<Thread> mainThread = this._clearMainThread();
                        if (mainThread.isPresent()) {
                            mainThread.get().interrupt();
                            try {
                                mainThread.get().join();
                            }
                            catch (InterruptedException exception) {
                                throw new RuntimeException(exception);
                            }
                        }
                    }, "Main thread shutdown"));
                    if (standAlone) {
                        Profiler.start();
                    }
                    try {
                        new Semaphore(0).acquire();
                    }
                    catch (InterruptedException exception) {
                        if (standAlone) {
                            Profiler.stop();
                        }
                        if (this.isStopped()) break block17;
                        this.stop();
                    }
                }
            }
            this.destroy();
            System.gc();
        }
        catch (Throwable throwable) {
            if (standAlone) {
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), throwable);
            }
        }
        finally {
            if (standAlone) {
                Logger.shutDown();
            }
        }
    }

    protected void started() {
    }

    protected void stopped() {
        Optional<Thread> mainThread;
        ServiceActivatorListener listener = this._listener;
        if (listener != null) {
            listener.stopped();
        }
        if (!this._restarting && (mainThread = this._clearMainThread()).isPresent()) {
            mainThread.get().interrupt();
        }
    }

    protected void tearDownStandAlone() {
    }

    @Nonnull
    final Optional<Thread> _clearMainThread() {
        return Optional.ofNullable(this._mainThread.getAndSet(null));
    }

    final void create(@Nonnull String[] args) throws Exception {
        this.getVersion().logSystemInfo(this.getClass().getSimpleName());
        for (String arg : args) {
            if (this.acceptMainArg(arg)) continue;
            this.getThisLogger().warn(ServiceMessages.ARGUMENT_NOT_ACCEPTED, arg);
        }
    }

    @CheckReturnValue
    boolean isStopping() {
        return this._stopping;
    }
}

